/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.shadowfacts.discordchat.repack.com.neovisionaries.ws.client.ProxySettings;
import net.shadowfacts.discordchat.repack.com.neovisionaries.ws.client.WebSocket;
import net.shadowfacts.discordchat.repack.com.neovisionaries.ws.client.WebSocketAdapter;
import net.shadowfacts.discordchat.repack.com.neovisionaries.ws.client.WebSocketException;
import net.shadowfacts.discordchat.repack.com.neovisionaries.ws.client.WebSocketFactory;
import net.shadowfacts.discordchat.repack.com.neovisionaries.ws.client.WebSocketFrame;
import net.shadowfacts.discordchat.repack.com.neovisionaries.ws.client.WebSocketListener;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.handle.CallCreateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.handle.CallDeleteHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.handle.CallUpdateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.handle.ChannelRecipientAddHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.handle.ChannelRecipientRemoveHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.handle.RelationshipAddHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.handle.RelationshipRemoveHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.AccountType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.ReadyEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.ReconnectedEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.ResumedEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.ChannelCreateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.ChannelDeleteHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.ChannelUpdateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.EventCache;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.GuildBanHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.GuildCreateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.GuildDeleteHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.GuildEmojisUpdateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.GuildMemberAddHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.GuildMemberRemoveHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.GuildMemberUpdateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.GuildMembersChunkHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.GuildRoleCreateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.GuildRoleDeleteHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.GuildRoleUpdateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.GuildSyncHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.GuildUpdateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.MessageBulkDeleteHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.MessageCreateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.MessageDeleteHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.MessageUpdateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.PresenceUpdateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.ReadyHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.SocketHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.TypingStartHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.UserUpdateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.VoiceStateUpdateHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.impl.PresenceImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.GuildLock;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.SimpleLog;
import net.shadowfacts.discordchat.repack.org.apache.http.HttpHost;
import net.shadowfacts.discordchat.repack.org.json.JSONArray;
import net.shadowfacts.discordchat.repack.org.json.JSONException;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class WebSocketClient
extends WebSocketAdapter
implements WebSocketListener {
    public static final SimpleLog LOG = SimpleLog.getLog("JDASocket");
    public static final int DISCORD_GATEWAY_VERSION = 6;
    protected final JDAImpl api;
    protected final JDA.ShardInfo shardInfo;
    protected final HttpHost proxy;
    protected final HashMap<String, SocketHandler> handlers = new HashMap();
    protected WebSocket socket;
    protected String gatewayUrl = null;
    protected String sessionId = null;
    protected volatile Thread keepAliveThread;
    protected boolean connected;
    protected volatile boolean chunkingAndSyncing = false;
    protected boolean initiating;
    protected final List<JSONObject> cachedEvents = new LinkedList<JSONObject>();
    protected boolean shouldReconnect = true;
    protected int reconnectTimeoutS = 2;
    protected boolean firstInit = true;

    public WebSocketClient(JDAImpl api) {
        this.api = api;
        this.shardInfo = api.getShardInfo();
        this.proxy = api.getGlobalProxy();
        this.shouldReconnect = api.isAutoReconnect();
        this.setupHandlers();
        this.connect();
    }

    public void setAutoReconnect(boolean reconnect) {
        this.shouldReconnect = reconnect;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void ready() {
        if (this.initiating) {
            this.initiating = false;
            this.reconnectTimeoutS = 2;
            if (this.firstInit) {
                this.firstInit = false;
                JDAImpl.LOG.info("Finished Loading!");
                if (this.api.getGuilds().size() >= 2500) {
                    JDAImpl.LOG.warn(" __      __ _    ___  _  _  ___  _  _   ___  _ ");
                    JDAImpl.LOG.warn(" \\ \\    / //_\\  | _ \\| \\| ||_ _|| \\| | / __|| |");
                    JDAImpl.LOG.warn("  \\ \\/\\/ // _ \\ |   /| .` | | | | .` || (_ ||_|");
                    JDAImpl.LOG.warn("   \\_/\\_//_/ \\_\\|_|_\\|_|\\_||___||_|\\_| \\___|(_)");
                    JDAImpl.LOG.warn("You're running a session with over 2500 connected");
                    JDAImpl.LOG.warn("guilds. You should shard the connection in order");
                    JDAImpl.LOG.warn("to split the load or things like resuming");
                    JDAImpl.LOG.warn("connection might not work as expected.");
                    JDAImpl.LOG.warn("For more info see https://git.io/vrFWP");
                }
                this.api.getEventManager().handle(new ReadyEvent(this.api, this.api.getResponseTotal()));
            } else {
                this.restoreAudioHandlers();
                this.reconnectAudioConnections();
                JDAImpl.LOG.info("Finished (Re)Loading!");
                this.api.getEventManager().handle(new ReconnectedEvent(this.api, this.api.getResponseTotal()));
            }
        } else {
            this.reconnectAudioConnections();
            JDAImpl.LOG.info("Successfully resumed Session!");
            this.api.getEventManager().handle(new ResumedEvent(this.api, this.api.getResponseTotal()));
        }
        this.api.setStatus(JDA.Status.CONNECTED);
        LOG.debug("Resending " + this.cachedEvents.size() + " cached events...");
        this.handle(this.cachedEvents);
        LOG.debug("Sending of cached events finished.");
        this.cachedEvents.clear();
    }

    public boolean isReady() {
        return !this.initiating;
    }

    public void handle(List<JSONObject> events) {
        events.forEach(this::handleEvent);
    }

    public void send(String message) {
        LOG.trace("<- " + message);
        this.socket.sendText(message);
    }

    public void close() {
        this.socket.sendClose(1000);
    }

    protected void connect() {
        if (this.api.getStatus() != JDA.Status.ATTEMPTING_TO_RECONNECT) {
            this.api.setStatus(JDA.Status.CONNECTING_TO_WEBSOCKET);
        }
        this.initiating = true;
        WebSocketFactory factory = new WebSocketFactory();
        if (this.proxy != null) {
            ProxySettings settings = factory.getProxySettings();
            settings.setHost(this.proxy.getHostName());
            settings.setPort(this.proxy.getPort());
        }
        try {
            if (this.gatewayUrl == null) {
                this.gatewayUrl = this.getGateway();
                if (this.gatewayUrl == null) {
                    throw new RuntimeException("Could not fetch WS-Gateway!");
                }
            }
            this.socket = factory.createSocket(this.gatewayUrl).addHeader("Accept-Encoding", "gzip").addListener(this);
            this.socket.connect();
        }
        catch (IOException | WebSocketException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getGateway() {
        try {
            RestAction<String> gateway = new RestAction<String>((JDA)this.api, Route.Self.GATEWAY.compile(new String[0]), null){

                @Override
                protected void handleResponse(Response response, Request request) {
                    try {
                        if (response.isOk()) {
                            request.onSuccess(response.getObject().getString("url"));
                        } else {
                            request.onFailure(new Exception("Failed to get gateway url"));
                        }
                    }
                    catch (Exception e) {
                        request.onFailure(e);
                    }
                }
            };
            return (String)gateway.block() + "?encoding=json&v=" + 6;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void onConnected(WebSocket websocket, Map<String, List<String>> headers) {
        this.api.setStatus(JDA.Status.LOADING_SUBSYSTEMS);
        LOG.info("Connected to WebSocket");
        if (this.sessionId == null) {
            this.sendIdentify();
        } else {
            this.sendResume();
        }
        this.connected = true;
    }

    @Override
    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
        this.connected = false;
        this.api.setStatus(JDA.Status.DISCONNECTED);
        if (this.keepAliveThread != null) {
            this.keepAliveThread.interrupt();
            this.keepAliveThread = null;
        }
        if (!this.shouldReconnect) {
            LOG.info("The connection was closed!");
            LOG.info("By remote? " + closedByServer);
            if (serverCloseFrame != null) {
                LOG.info("Reason: " + serverCloseFrame.getCloseReason());
                LOG.info("Close code: " + serverCloseFrame.getCloseCode());
            }
            this.api.setStatus(JDA.Status.SHUTDOWN);
        } else {
            this.reconnect();
        }
    }

    protected void reconnect() {
        LOG.warn("Got disconnected from WebSocket (Internet?!)... Attempting to reconnect in " + this.reconnectTimeoutS + "s");
        while (this.shouldReconnect) {
            try {
                this.api.setStatus(JDA.Status.WAITING_TO_RECONNECT);
                Thread.sleep(this.reconnectTimeoutS * 1000);
                this.api.setStatus(JDA.Status.ATTEMPTING_TO_RECONNECT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.warn("Attempting to reconnect!");
            try {
                this.connect();
                break;
            }
            catch (RuntimeException ex) {
                this.reconnectTimeoutS = Math.min(this.reconnectTimeoutS << 1, 900);
                LOG.warn("Reconnect failed! Next attempt in " + this.reconnectTimeoutS + "s");
            }
        }
    }

    @Override
    public void onTextMessage(WebSocket websocket, String message) {
        JSONObject content = new JSONObject(message);
        int opCode = content.getInt("op");
        if (content.has("s") && !content.isNull("s")) {
            this.api.setResponseTotal(content.getInt("s"));
        }
        switch (opCode) {
            case 0: {
                this.handleEvent(content);
                break;
            }
            case 1: {
                LOG.debug("Got Keep-Alive request (OP 1). Sending response...");
                this.sendKeepAlive();
                break;
            }
            case 7: {
                LOG.debug("Got Reconnect request (OP 7). Closing connection now...");
                this.close();
                break;
            }
            case 9: {
                LOG.debug("Got Invalidate request (OP 9). Invalidating...");
                this.invalidate();
                this.sendIdentify();
                break;
            }
            case 10: {
                LOG.debug("Got HELLO packet (OP 10). Initializing keep-alive.");
                this.setupKeepAlive(content.getJSONObject("d").getLong("heartbeat_interval"));
                break;
            }
            case 11: {
                LOG.trace("Got Heartbeat Ack (OP 11).");
                break;
            }
            default: {
                LOG.debug("Got unknown op-code: " + opCode + " with content: " + message);
            }
        }
    }

    protected void setupKeepAlive(long timeout) {
        this.keepAliveThread = new Thread(() -> {
            while (this.connected) {
                try {
                    this.sendKeepAlive();
                    Thread.sleep(timeout);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        });
        this.keepAliveThread.setName("JDA MainWS-KeepAlive" + (this.shardInfo != null ? " Shard [" + this.shardInfo.getShardId() + " / " + this.shardInfo.getShardTotal() + "]" : ""));
        this.keepAliveThread.setPriority(10);
        this.keepAliveThread.setDaemon(true);
        this.keepAliveThread.start();
    }

    protected void sendKeepAlive() {
        this.send(new JSONObject().put("op", 1).put("d", this.api.getResponseTotal()).toString());
    }

    protected void sendIdentify() {
        LOG.debug("Sending Identify-packet...");
        PresenceImpl presenceObj = (PresenceImpl)this.api.getPresence();
        JSONObject identify = new JSONObject().put("op", 2).put("d", new JSONObject().put("presence", presenceObj.getFullPresence()).put("token", this.api.getToken()).put("properties", new JSONObject().put("$os", System.getProperty("os.name")).put("$browser", "JDA").put("$device", "JDA").put("$referring_domain", "").put("$referrer", "")).put("v", 6).put("large_threshold", 250).put("compress", true));
        if (this.shardInfo != null) {
            identify.getJSONObject("d").put("shard", new JSONArray().put(this.shardInfo.getShardId()).put(this.shardInfo.getShardTotal()));
        }
        this.send(identify.toString());
    }

    protected void sendResume() {
        LOG.debug("Sending Resume-packet...");
        this.send(new JSONObject().put("op", 6).put("d", new JSONObject().put("session_id", this.sessionId).put("token", this.api.getToken()).put("seq", this.api.getResponseTotal())).toString());
    }

    protected void invalidate() {
        this.sessionId = null;
        this.chunkingAndSyncing = false;
        this.api.getTextChannelMap().clear();
        this.api.getVoiceChannelMap().clear();
        this.api.getGuildMap().clear();
        this.api.getUserMap().clear();
        this.api.getPrivateChannelMap().clear();
        this.api.getFakeUserMap().clear();
        this.api.getFakePrivateChannelMap().clear();
        EntityBuilder.get(this.api).clearCache();
        EventCache.get(this.api).clear();
        GuildLock.get(this.api).clear();
        ((ReadyHandler)this.getHandler("READY")).clearCache();
        ((GuildMembersChunkHandler)this.getHandler("GUILD_MEMBERS_CHUNK")).clearCache();
        if (this.api.getAccountType() == AccountType.CLIENT) {
            JDAClientImpl client = (JDAClientImpl)this.api.asClient();
            client.getRelationshipMap().clear();
            client.getGroupMap().clear();
            client.getCallUserMap().clear();
        }
    }

    protected void restoreAudioHandlers() {
        LOG.trace("Restoring cached AudioHandlers.");
    }

    protected void reconnectAudioConnections() {
    }

    protected void handleEvent(JSONObject raw) {
        String type = raw.getString("t");
        long responseTotal = this.api.getResponseTotal();
        if (type.equals("GUILD_MEMBER_ADD")) {
            ((GuildMembersChunkHandler)this.getHandler("GUILD_MEMBERS_CHUNK")).modifyExpectedGuildMember(raw.getJSONObject("d").getString("guild_id"), 1);
        }
        if (type.equals("GUILD_MEMBER_REMOVE")) {
            ((GuildMembersChunkHandler)this.getHandler("GUILD_MEMBERS_CHUNK")).modifyExpectedGuildMember(raw.getJSONObject("d").getString("guild_id"), -1);
        }
        if (!(!this.initiating || type.equals("READY") || type.equals("GUILD_MEMBERS_CHUNK") || type.equals("RESUMED") || type.equals("GUILD_SYNC") || !this.chunkingAndSyncing && type.equals("GUILD_CREATE"))) {
            LOG.debug("Caching " + type + " event during init!");
            this.cachedEvents.add(raw);
            return;
        }
        JSONObject content = raw.getJSONObject("d");
        LOG.trace(String.format("%s -> %s", type, content.toString()));
        try {
            switch (type) {
                case "READY": {
                    LOG.debug(String.format("%s -> %s", type, content.toString()));
                    this.sessionId = content.getString("session_id");
                    this.handlers.get("READY").handle(responseTotal, raw);
                    break;
                }
                case "RESUMED": {
                    this.initiating = false;
                    this.ready();
                    break;
                }
                default: {
                    SocketHandler handler = this.handlers.get(type);
                    if (handler != null) {
                        handler.handle(responseTotal, raw);
                        break;
                    }
                    LOG.debug("Unrecognized event:\n" + raw);
                    break;
                }
            }
        }
        catch (JSONException ex) {
            LOG.warn("Got an unexpected Json-parse error. Please redirect following message to the devs:\n\t" + ex.getMessage() + "\n\t" + type + " -> " + content);
        }
        catch (Exception ex) {
            LOG.log(ex);
        }
    }

    @Override
    public void onBinaryMessage(WebSocket websocket, byte[] binary) throws UnsupportedEncodingException, DataFormatException {
        StringBuilder builder = new StringBuilder();
        Inflater decompresser = new Inflater();
        decompresser.setInput(binary, 0, binary.length);
        byte[] result = new byte[128];
        while (!decompresser.finished()) {
            int resultLength = decompresser.inflate(result);
            builder.append(new String(result, 0, resultLength, "UTF-8"));
        }
        decompresser.end();
        this.onTextMessage(websocket, builder.toString());
    }

    @Override
    public void onUnexpectedError(WebSocket websocket, WebSocketException cause) throws Exception {
        this.handleCallbackError(websocket, cause);
    }

    @Override
    public void handleCallbackError(WebSocket websocket, Throwable cause) {
    }

    public void setChunkingAndSyncing(boolean active) {
        this.chunkingAndSyncing = active;
    }

    public HashMap<String, SocketHandler> getHandlers() {
        return this.handlers;
    }

    public <T> T getHandler(String type) {
        return (T)this.handlers.get(type);
    }

    private void setupHandlers() {
        this.handlers.put("CHANNEL_CREATE", new ChannelCreateHandler(this.api));
        this.handlers.put("CHANNEL_DELETE", new ChannelDeleteHandler(this.api));
        this.handlers.put("CHANNEL_UPDATE", new ChannelUpdateHandler(this.api));
        this.handlers.put("GUILD_BAN_ADD", new GuildBanHandler(this.api, true));
        this.handlers.put("GUILD_BAN_REMOVE", new GuildBanHandler(this.api, false));
        this.handlers.put("GUILD_CREATE", new GuildCreateHandler(this.api));
        this.handlers.put("GUILD_DELETE", new GuildDeleteHandler(this.api));
        this.handlers.put("GUILD_EMOJIS_UPDATE", new GuildEmojisUpdateHandler(this.api));
        this.handlers.put("GUILD_MEMBER_ADD", new GuildMemberAddHandler(this.api));
        this.handlers.put("GUILD_MEMBER_REMOVE", new GuildMemberRemoveHandler(this.api));
        this.handlers.put("GUILD_MEMBER_UPDATE", new GuildMemberUpdateHandler(this.api));
        this.handlers.put("GUILD_MEMBERS_CHUNK", new GuildMembersChunkHandler(this.api));
        this.handlers.put("GUILD_ROLE_CREATE", new GuildRoleCreateHandler(this.api));
        this.handlers.put("GUILD_ROLE_DELETE", new GuildRoleDeleteHandler(this.api));
        this.handlers.put("GUILD_ROLE_UPDATE", new GuildRoleUpdateHandler(this.api));
        this.handlers.put("GUILD_SYNC", new GuildSyncHandler(this.api));
        this.handlers.put("GUILD_UPDATE", new GuildUpdateHandler(this.api));
        this.handlers.put("MESSAGE_CREATE", new MessageCreateHandler(this.api));
        this.handlers.put("MESSAGE_DELETE", new MessageDeleteHandler(this.api));
        this.handlers.put("MESSAGE_DELETE_BULK", new MessageBulkDeleteHandler(this.api));
        this.handlers.put("MESSAGE_UPDATE", new MessageUpdateHandler(this.api));
        this.handlers.put("PRESENCE_UPDATE", new PresenceUpdateHandler(this.api));
        this.handlers.put("READY", new ReadyHandler(this.api));
        this.handlers.put("TYPING_START", new TypingStartHandler(this.api));
        this.handlers.put("USER_UPDATE", new UserUpdateHandler(this.api));
        this.handlers.put("VOICE_STATE_UPDATE", new VoiceStateUpdateHandler(this.api));
        if (this.api.getAccountType() == AccountType.CLIENT) {
            this.handlers.put("CALL_CREATE", new CallCreateHandler(this.api));
            this.handlers.put("CALL_DELETE", new CallDeleteHandler(this.api));
            this.handlers.put("CALL_UPDATE", new CallUpdateHandler(this.api));
            this.handlers.put("CHANNEL_RECIPIENT_ADD", new ChannelRecipientAddHandler(this.api));
            this.handlers.put("CHANNEL_RECIPIENT_REMOVE", new ChannelRecipientRemoveHandler(this.api));
            this.handlers.put("RELATIONSHIP_ADD", new RelationshipAddHandler(this.api));
            this.handlers.put("RELATIONSHIP_REMOVE", new RelationshipRemoveHandler(this.api));
            this.handlers.put("MESSAGE_ACK", new SocketHandler(this.api){

                @Override
                protected String handleInternally(JSONObject content) {
                    return null;
                }
            });
        }
    }
}

