/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.shadowfacts.discordchat.repack.com.mashape.unirest.http.HttpMethod;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.repack.org.apache.commons.lang3.StringUtils;

public class Route {
    private final String route;
    private final String ratelimitRoute;
    private final String compilableRoute;
    private final int paramCount;
    private final HttpMethod method;
    private final List<Integer> majorParamIndexes = new ArrayList<Integer>();

    private Route(HttpMethod method, String route, String ... majorParameters) {
        this.method = method;
        this.route = route;
        this.paramCount = StringUtils.countMatches((CharSequence)route, '{');
        if (this.paramCount != StringUtils.countMatches((CharSequence)route, '}')) {
            throw new IllegalArgumentException("An argument does not have both {}'s for route: " + (Object)((Object)method) + "  " + route);
        }
        this.compilableRoute = route.replaceAll("\\{.*?\\}", "%s");
        if (majorParameters.length != 0) {
            int paramIndex = 0;
            String replaceRoute = route;
            Pattern keyP = Pattern.compile("\\{(.*?)\\}");
            Matcher keyM = keyP.matcher(route);
            while (keyM.find()) {
                String param = keyM.group(1);
                for (String majorParam : majorParameters) {
                    if (!param.equals(majorParam)) continue;
                    replaceRoute = replaceRoute.replace(keyM.group(0), "%s");
                    this.majorParamIndexes.add(paramIndex);
                }
                ++paramIndex;
            }
            this.ratelimitRoute = replaceRoute;
        } else {
            this.ratelimitRoute = route;
        }
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getRoute() {
        return this.route;
    }

    public String getRatelimitRoute() {
        return this.ratelimitRoute;
    }

    public String getCompilableRoute() {
        return this.compilableRoute;
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public CompiledRoute compile(String ... params) {
        if (params.length != this.paramCount) {
            throw new IllegalArgumentException("Error Compiling Route: [" + this.route + "], incorrect amount of parameters provided.Expected: " + this.paramCount + ", Provided: " + params.length);
        }
        String compiledRoute = String.format(this.compilableRoute, params);
        String compiledRatelimitRoute = this.ratelimitRoute;
        if (!this.majorParamIndexes.isEmpty()) {
            String[] majorParams = new String[this.majorParamIndexes.size()];
            for (int i = 0; i < majorParams.length; ++i) {
                majorParams[i] = params[this.majorParamIndexes.get(i)];
            }
            compiledRatelimitRoute = String.format(compiledRatelimitRoute, majorParams);
        }
        return new CompiledRoute(this, compiledRatelimitRoute, compiledRoute);
    }

    public int hashCode() {
        return (this.route + this.method.toString()).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Route)) {
            return false;
        }
        Route oRoute = (Route)o;
        return this.method.equals((Object)oRoute.method) && this.route.equals(oRoute.route);
    }

    public String toString() {
        return "Route(" + (Object)((Object)this.method) + ": " + this.route + ")";
    }

    public static void main(String[] args) {
        System.out.println("Forcing static load to test for invalid {} parameters!");
        Route r = Self.CREATE_PRIVATE_CHANNEL;
        r = Users.GET_USER;
        r = Guilds.BAN;
        r = Roles.CREATE_ROLE;
        r = Channels.CREATE_PERM_OVERRIDE;
        r = Messages.ADD_PINNED_MESSAGE;
        r = Invites.ACCEPT_INVITE;
        System.out.println("Done!");
    }

    public class CompiledRoute {
        private final Route baseRoute;
        private final String ratelimitRoute;
        private final String compiledRoute;

        private CompiledRoute(Route baseRoute, String ratelimitRoute, String compiledRoute) {
            this.baseRoute = baseRoute;
            this.ratelimitRoute = ratelimitRoute;
            this.compiledRoute = compiledRoute;
        }

        public String getRatelimitRoute() {
            return this.ratelimitRoute;
        }

        public String getCompiledRoute() {
            return this.compiledRoute;
        }

        public Route getBaseRoute() {
            return this.baseRoute;
        }

        public HttpMethod getMethod() {
            return this.baseRoute.method;
        }

        public int hashCode() {
            return (this.compiledRoute + Route.this.method.toString()).hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CompiledRoute)) {
                return false;
            }
            CompiledRoute oCompiled = (CompiledRoute)o;
            return this.baseRoute.equals(oCompiled.getBaseRoute()) && this.compiledRoute.equals(oCompiled.compiledRoute);
        }

        public String toString() {
            return "CompiledRoute(" + (Object)((Object)Route.this.method) + ": " + this.compiledRoute + ")";
        }
    }

    public static class Custom {
        public static final Route DELETE_ROUTE = new Route(HttpMethod.DELETE, "{}", new String[0]);
        public static final Route GET_ROUTE = new Route(HttpMethod.GET, "{}", new String[0]);
        public static final Route POST_ROUTE = new Route(HttpMethod.POST, "{}", new String[0]);
        public static final Route PUT_ROUTE = new Route(HttpMethod.PUT, "{}", new String[0]);
        public static final Route PATCH_ROUTE = new Route(HttpMethod.PATCH, "{}", new String[0]);
    }

    public static class Invites {
        public static final Route GET_INVITE = new Route(HttpMethod.GET, "invites/{code}", new String[0]);
        public static final Route DELETE_INVITE = new Route(HttpMethod.DELETE, "invites/{code}", new String[0]);
        public static final Route GET_GUILD_INVITES = new Route(HttpMethod.GET, "guilds/{guild_id}/invites", new String[]{"guild_id"});
        public static final Route GET_CHANNEL_INVITES = new Route(HttpMethod.GET, "channels/{channel_id}/invites", new String[]{"channel_id"});
        public static final Route CREATE_INVITE = new Route(HttpMethod.POST, "channels/{channel_id}/invites", new String[]{"channel_id"});
        public static final Route ACCEPT_INVITE = new Route(HttpMethod.POST, "invites/{code}", new String[0]);
    }

    public static class Messages {
        public static final Route SEND_MESSAGE = new Route(HttpMethod.POST, "channels/{channel_id}/messages", new String[]{"channel_id"});
        public static final Route EDIT_MESSAGE = new Route(HttpMethod.PATCH, "channels/{channel_id}/messages/{message_id}", new String[]{"channel_id"});
        public static final Route DELETE_MESSAGE = new Route(HttpMethod.DELETE, "channels/{channel_id}/messages/{message_id}", new String[]{"channel_id"});
        public static final Route GET_PINNED_MESSAGES = new Route(HttpMethod.GET, "channels/{channel_id}/pins", new String[]{"channel_id"});
        public static final Route ADD_PINNED_MESSAGE = new Route(HttpMethod.PUT, "channels/{channel_id}/pins/{message_id}", new String[]{"channel_id"});
        public static final Route REMOVE_PINNED_MESSAGE = new Route(HttpMethod.DELETE, "channels/{channel_id}/pins/{message_id}", new String[]{"channel_id"});
        public static final Route GET_MESSAGE_HISTORY = new Route(HttpMethod.GET, "channels/{channel_id}/messages?limit={}", new String[]{"channel_id"});
        public static final Route GET_MESSAGE_HISTORY_BEFORE = new Route(HttpMethod.GET, "channels/{channel_id}/messages?limit={}&before={}", new String[]{"channel_id"});
        public static final Route GET_MESSAGE_HISTORY_AFTER = new Route(HttpMethod.GET, "channels/{channel_id}/messages?limit={}&after={}", new String[]{"channel_id"});
        public static final Route GET_MESSAGE_HISTORY_AROUND = new Route(HttpMethod.GET, "channels/{channel_id}/messages?limit={}&around={}", new String[]{"channel_id"});
        public static final Route GET_MESSAGE = new Route(HttpMethod.GET, "channels/{channel_id}/messages/{message_id}", new String[]{"channel_id"});
        public static final Route DELETE_MESSAGES = new Route(HttpMethod.POST, "channels/{channel_id}/messages/bulk_delete", new String[]{"channel_id"});
    }

    public static class Channels {
        public static final Route DELETE_CHANNEL = new Route(HttpMethod.DELETE, "channels/{channel_id}", new String[0]);
        public static final Route MODIFY_CHANNEL = new Route(HttpMethod.PATCH, "channels/{channel_id}", new String[]{"channel_id"});
        public static final Route SEND_TYPING = new Route(HttpMethod.POST, "channels/{channel_id}/typing", new String[]{"channel_id"});
        public static final Route GET_PERMISSIONS = new Route(HttpMethod.GET, "channels/{channel_id}/permissions", new String[]{"channel_id"});
        public static final Route GET_PERM_OVERRIDE = new Route(HttpMethod.GET, "channels/{channel_id}/permissions/{permoverride_id}", new String[]{"channel_id"});
        public static final Route CREATE_PERM_OVERRIDE = new Route(HttpMethod.PUT, "channels/{channel_id}/permissions/{permoverride_id}", new String[]{"channel_id"});
        public static final Route MODIFY_PERM_OVERRIDE = new Route(HttpMethod.PUT, "channels/{channel_id}/permissions/{permoverride_id}", new String[]{"channel_id"});
        public static final Route DELETE_PERM_OVERRIDE = new Route(HttpMethod.DELETE, "channels/{channel_id}/permissions/{permoverride_id}", new String[]{"channel_id"});
    }

    public static class Roles {
        public static final Route GET_ROLES = new Route(HttpMethod.GET, "guilds/{guild_id}/roles", new String[]{"guild_id"});
        public static final Route CREATE_ROLE = new Route(HttpMethod.POST, "guilds/{guild_id}/roles", new String[]{"guild_id"});
        public static final Route GET_ROLE = new Route(HttpMethod.GET, "guilds/{guild_id}/roles/{role_id}", new String[]{"guild_id"});
        public static final Route MODIFY_ROLE = new Route(HttpMethod.PATCH, "guilds/{guild_id}/roles/{role_id}", new String[]{"guild_id"});
        public static final Route DELETE_ROLE = new Route(HttpMethod.DELETE, "guilds/{guild_id}/roles/{role_id}", new String[]{"guild_id"});
    }

    public static class Emotes {
        public static final Route MODIFY_EMOTE = new Route(HttpMethod.PATCH, "guilds/{guild_id}/emojis/{emote_id}", new String[0]);
        public static final Route DELETE_EMOTE = new Route(HttpMethod.DELETE, "guilds/{guild_id}/emojis/{emote_id}", new String[0]);
        public static final Route CREATE_EMOTE = new Route(HttpMethod.POST, "guilds/{guild_id}/emojis", new String[0]);
    }

    public static class Guilds {
        public static final Route GET_GUILD = new Route(HttpMethod.GET, "guilds/{guild_id}", new String[]{"guild_id"});
        public static final Route MODIFY_GUILD = new Route(HttpMethod.PATCH, "guilds/{guild_id}", new String[]{"guild_id"});
        public static final Route CREATE_CHANNEL = new Route(HttpMethod.POST, "guilds/{guild_id}/channels", new String[]{"guild_id"});
        public static final Route GET_CHANNELS = new Route(HttpMethod.GET, "guilds/{guild_id}/channels", new String[]{"guild_id"});
        public static final Route MODIFY_CHANNELS = new Route(HttpMethod.PATCH, "guilds/{guild_id}/channels", new String[]{"guild_id"});
        public static final Route GET_BANS = new Route(HttpMethod.GET, "guilds/{guild_id}/bans", new String[]{"guild_id"});
        public static final Route BAN = new Route(HttpMethod.PUT, "guilds/{guild_id}/bans/{user_id}", new String[]{"guild_id"});
        public static final Route BAN_WITH_DELETE = new Route(HttpMethod.PUT, "guilds/{guild_id}/bans/{user_id}?delete-message-days={}", new String[]{"guild_id"});
        public static final Route UNBAN = new Route(HttpMethod.DELETE, "guilds/{guild_id}/bans/{user_id}", new String[]{"guild_id"});
        public static final Route KICK_MEMBER = new Route(HttpMethod.DELETE, "guilds/{guild_id}/members/{user_id}", new String[]{"guild_id"});
        public static final Route MODIFY_MEMBER = new Route(HttpMethod.PATCH, "guilds/{guild_id}/members/{user_id}", new String[]{"guild_id"});
        public static final Route MODIFY_SELF_NICK = new Route(HttpMethod.PATCH, "guilds/{guild_id}/members/@me/nick", new String[]{"guild_id"});
        public static final Route PRUNABLE_COUNT = new Route(HttpMethod.GET, "guilds/{guild_id}/prune?days={}", new String[]{"guild_id"});
        public static final Route PRUNE_MEMBERS = new Route(HttpMethod.POST, "guilds/{guild_id}/prune?days={}", new String[]{"guild_id"});
        public static final Route CREATE_GUILD = new Route(HttpMethod.POST, "guilds", new String[0]);
        public static final Route DELETE_GUILD = new Route(HttpMethod.POST, "guilds/{guild_id}/delete", new String[0]);
    }

    public static class Users {
        public static final Route GET_USER = new Route(HttpMethod.GET, "users/{user_id}", new String[0]);
    }

    public static class Self {
        public static final Route GET_SELF = new Route(HttpMethod.GET, "users/@me", new String[0]);
        public static final Route MODIFY_SELF = new Route(HttpMethod.PATCH, "users/@me", new String[0]);
        public static final Route GET_GUILDS = new Route(HttpMethod.GET, "users/@me/guilds", new String[0]);
        public static final Route LEAVE_GUILD = new Route(HttpMethod.DELETE, "users/@me/guilds/{guild_id}", new String[0]);
        public static final Route GET_PRIVATE_CHANNELS = new Route(HttpMethod.GET, "users/@me/channels", new String[0]);
        public static final Route CREATE_PRIVATE_CHANNEL = new Route(HttpMethod.POST, "users/@me/channels", new String[0]);
        public static final Route GATEWAY = new Route(HttpMethod.GET, "gateway", new String[0]);
        public static final Route USER_SETTINGS = new Route(HttpMethod.GET, "users/@me/settings", new String[0]);
    }
}

