/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests;

import net.shadowfacts.discordchat.repack.org.json.JSONArray;
import net.shadowfacts.discordchat.repack.org.json.JSONException;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class Response {
    public static final int ERROR_CODE = -1;
    public final Exception exception;
    public final int code;
    public final long retryAfter;
    public final String responseText;

    protected Response(int code, String response, long retryAfter) {
        this.code = code;
        this.responseText = response;
        this.exception = null;
        this.retryAfter = retryAfter;
    }

    protected Response(Exception exception) {
        this.code = -1;
        this.responseText = null;
        this.exception = exception;
        this.retryAfter = -1L;
    }

    public boolean isError() {
        return this.code == -1;
    }

    public boolean isOk() {
        return this.code > 199 && this.code < 300;
    }

    public boolean isRateLimit() {
        return this.code == 429;
    }

    public JSONObject getObject() {
        try {
            return this.responseText == null ? null : new JSONObject(this.responseText);
        }
        catch (JSONException ex) {
            return null;
        }
    }

    public JSONArray getArray() {
        try {
            return this.responseText == null ? null : new JSONArray(this.responseText);
        }
        catch (JSONException ex) {
            return null;
        }
    }

    public String getString() {
        return this.responseText;
    }

    public String toString() {
        return this.exception == null ? "HTTPResponse[" + this.code + ": " + this.responseText + ']' : "HTTPException[" + this.exception.getMessage() + ']';
    }
}

