/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.shadowfacts.discordchat.repack.com.mashape.unirest.http.HttpResponse;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Requester;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.ratelimit.IBucket;

public abstract class RateLimiter {
    protected final Requester requester;
    protected final ExecutorService pool;
    protected volatile boolean isShutdown;
    protected volatile ConcurrentHashMap<String, IBucket> buckets = new ConcurrentHashMap();
    protected volatile ConcurrentLinkedQueue<IBucket> submittedBuckets = new ConcurrentLinkedQueue();

    protected RateLimiter(Requester requester, int poolSize) {
        this.requester = requester;
        this.pool = Executors.newFixedThreadPool(poolSize);
        this.isShutdown = false;
    }

    public abstract Long getRateLimit(Route.CompiledRoute var1);

    protected abstract void queueRequest(Request var1);

    protected abstract Long handleResponse(Route.CompiledRoute var1, HttpResponse<String> var2);

    public boolean isRateLimited(Route.CompiledRoute route) {
        return this.getRateLimit(route) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBucket> getRouteBuckets() {
        ConcurrentHashMap<String, IBucket> concurrentHashMap = this.buckets;
        synchronized (concurrentHashMap) {
            return Collections.unmodifiableList(new ArrayList<IBucket>(this.buckets.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBucket> getQueuedRouteBuckets() {
        ConcurrentLinkedQueue<IBucket> concurrentLinkedQueue = this.submittedBuckets;
        synchronized (concurrentLinkedQueue) {
            return Collections.unmodifiableList(new ArrayList<IBucket>(this.submittedBuckets));
        }
    }

    protected void shutdown() {
        this.isShutdown = true;
        try {
            while (!this.submittedBuckets.isEmpty()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.pool.shutdownNow();
    }

    protected List<IBucket> shutdownNow() {
        this.isShutdown = true;
        this.pool.shutdownNow();
        try {
            while (!this.pool.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.buckets.values().stream().filter(b -> !b.getRequests().isEmpty()).collect(Collectors.toList());
    }
}

