/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.impl;

import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.OnlineStatus;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Game;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.Presence;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class PresenceImpl
implements Presence {
    private final JDAImpl api;
    private boolean idle = false;
    private Game game = null;
    private OnlineStatus status = OnlineStatus.ONLINE;

    public PresenceImpl(JDAImpl jda) {
        this.api = jda;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public OnlineStatus getStatus() {
        return this.status;
    }

    @Override
    public Game getGame() {
        return this.game;
    }

    @Override
    public boolean isIdle() {
        return this.idle;
    }

    @Override
    public void setStatus(OnlineStatus status) {
        if (status == OnlineStatus.UNKNOWN) {
            throw new IllegalArgumentException("Cannot set the presence status to an unknown OnlineStatus!");
        }
        if (status == OnlineStatus.OFFLINE || status == null) {
            status = OnlineStatus.INVISIBLE;
        }
        JSONObject object = this.getFullPresence();
        object.put("status", status.getKey());
        this.update(object);
        this.status = status;
    }

    @Override
    public void setGame(Game game) {
        JSONObject gameObj = this.getGameJson(game);
        if (gameObj == null) {
            this.update(this.getFullPresence().put("game", JSONObject.NULL));
            this.game = null;
            return;
        }
        JSONObject object = this.getFullPresence();
        object.put("game", gameObj);
        this.update(object);
        this.game = game;
    }

    @Override
    public void setIdle(boolean idle) {
        JSONObject object = this.getFullPresence();
        object.put("afk", idle);
        this.update(object);
        this.idle = idle;
    }

    public PresenceImpl setCacheStatus(OnlineStatus status) {
        if (status == null) {
            throw new NullPointerException("Null OnlineStatus is not allowed.");
        }
        if (status == OnlineStatus.OFFLINE) {
            status = OnlineStatus.INVISIBLE;
        }
        this.status = status;
        return this;
    }

    public PresenceImpl setCacheGame(Game game) {
        this.game = game;
        return this;
    }

    public PresenceImpl setCacheIdle(boolean idle) {
        this.idle = idle;
        return this;
    }

    public JSONObject getFullPresence() {
        JSONObject game = this.getGameJson(this.game);
        return new JSONObject().put("afk", this.idle).put("since", System.currentTimeMillis()).put("game", game == null ? JSONObject.NULL : game).put("status", this.getStatus().getKey());
    }

    private JSONObject getGameJson(Game game) {
        if (game == null || game.getName() == null || game.getType() == null) {
            return null;
        }
        JSONObject gameObj = new JSONObject();
        gameObj.put("name", game.getName());
        gameObj.put("type", game.getType().getKey());
        if (game.getType() == Game.GameType.TWITCH && game.getUrl() != null) {
            gameObj.put("url", game.getUrl());
        }
        return gameObj;
    }

    protected void update(JSONObject data) {
        this.api.getClient().send(new JSONObject().put("d", data).put("op", 3).toString());
    }
}

