/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.fields;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.PermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.RoleManagerUpdatable;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.fields.RoleField;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.PermissionUtil;

public class PermissionField
extends RoleField<Long> {
    Set<Permission> permsGiven = new HashSet<Permission>();
    Set<Permission> permsRevoked = new HashSet<Permission>();

    public PermissionField(RoleManagerUpdatable manager, Supplier<Long> originalValue) {
        super(manager, originalValue);
    }

    @Override
    public RoleManagerUpdatable setValue(Long value) {
        this.checkValue(value);
        this.value = value;
        this.set = true;
        this.permsGiven.clear();
        this.permsRevoked.clear();
        return (RoleManagerUpdatable)this.manager;
    }

    public RoleManagerUpdatable setPermissions(Permission ... permissions) {
        return this.setPermissions(Arrays.asList(permissions));
    }

    public RoleManagerUpdatable setPermissions(Collection<Permission> permissions) {
        PermissionField.checkNull(permissions, "permissions Collection");
        permissions.forEach(p -> PermissionField.checkNull(p, "Permission in the Collection"));
        return this.setValue(Permission.getRaw(permissions));
    }

    @Override
    public void checkValue(Long value) {
        PermissionField.checkNull(value, "permission value");
        Permission.getPermissions(value).forEach(p -> this.checkPermission((Permission)((Object)p)));
    }

    public RoleManagerUpdatable givePermissions(Permission ... permissions) {
        return this.givePermissions(Arrays.asList(permissions));
    }

    public RoleManagerUpdatable givePermissions(Collection<Permission> permissions) {
        PermissionField.checkNull(permissions, "Permission Collection");
        permissions.forEach(p -> {
            PermissionField.checkNull(p, "Permission in the Collection");
            this.checkPermission((Permission)((Object)p));
        });
        this.permsGiven.addAll(permissions);
        this.permsRevoked.removeAll(permissions);
        this.set = true;
        return (RoleManagerUpdatable)this.manager;
    }

    public RoleManagerUpdatable revokePermissions(Permission ... permissions) {
        return this.revokePermissions(Arrays.asList(permissions));
    }

    public RoleManagerUpdatable revokePermissions(Collection<Permission> permissions) {
        PermissionField.checkNull(permissions, "Permission Collection");
        permissions.forEach(p -> {
            PermissionField.checkNull(p, "Permission in the Collection");
            this.checkPermission((Permission)((Object)p));
        });
        this.permsRevoked.addAll(permissions);
        this.permsGiven.remove(permissions);
        this.set = true;
        return (RoleManagerUpdatable)this.manager;
    }

    @Override
    public Long getValue() {
        if (!this.isSet()) {
            return null;
        }
        long perms = this.value != null ? ((Long)this.value).longValue() : ((Long)this.getOriginalValue()).longValue();
        long given = Permission.getRaw(this.permsGiven);
        long removed = Permission.getRaw(this.permsRevoked);
        perms |= given;
        return perms &= removed ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public RoleManagerUpdatable reset() {
        super.reset();
        this.permsGiven.clear();
        this.permsRevoked.clear();
        return (RoleManagerUpdatable)this.manager;
    }

    public List<Permission> getPermissions() {
        Long perms = this.getValue();
        return perms != null ? Permission.getPermissions(perms) : null;
    }

    public List<Permission> getOriginalPermissions() {
        return Permission.getPermissions((Long)this.getOriginalValue());
    }

    protected void checkPermission(Permission perm) {
        if (!PermissionUtil.checkPermission(((RoleManagerUpdatable)this.manager).getGuild(), ((RoleManagerUpdatable)this.manager).getGuild().getSelfMember(), perm)) {
            throw new PermissionException(perm, "Cannot give / revoke the permission because the logged in account does not have access to it! Permission: " + (Object)((Object)perm));
        }
    }
}

