/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers;

import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Region;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Icon;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.VoiceChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.GuildUnavailableException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.PermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.fields.GuildField;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.PermissionUtil;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class GuildManagerUpdatable {
    protected final Guild guild;
    protected GuildField<String> name;
    protected GuildField<Guild.Timeout> timeout;
    protected GuildField<Icon> icon;
    protected GuildField<Icon> splash;
    protected GuildField<Region> region;
    protected GuildField<VoiceChannel> afkChannel;
    protected GuildField<Guild.VerificationLevel> verificationLevel;
    protected GuildField<Guild.NotificationLevel> defaultNotificationLevel;
    protected GuildField<Guild.MFALevel> mfaLevel;

    public GuildManagerUpdatable(Guild guild) {
        this.guild = guild;
        this.setupFields();
    }

    public JDA getJDA() {
        return this.guild.getJDA();
    }

    public Guild getGuild() {
        return this.guild;
    }

    public GuildField<String> getNameField() {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_SERVER);
        return this.name;
    }

    public GuildField<Region> getRegionField() {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_SERVER);
        return this.region;
    }

    public GuildField<Icon> getIconField() {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_SERVER);
        return this.icon;
    }

    public GuildField<Icon> getSplashField() {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_SERVER);
        return this.splash;
    }

    public GuildField<VoiceChannel> getAfkChannelField() {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_SERVER);
        return this.afkChannel;
    }

    public GuildField<Guild.Timeout> getAfkTimeoutField() {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_SERVER);
        return this.timeout;
    }

    public GuildField<Guild.VerificationLevel> getVerificationLevelField() {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_SERVER);
        return this.verificationLevel;
    }

    public GuildField<Guild.NotificationLevel> getDefaultNotificationLevelField() {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_SERVER);
        return this.defaultNotificationLevel;
    }

    public GuildField<Guild.MFALevel> getRequiredMFALevelField() {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_SERVER);
        return this.mfaLevel;
    }

    public void reset() {
        this.name.reset();
        this.region.reset();
        this.timeout.reset();
        this.icon.reset();
        this.splash.reset();
        this.afkChannel.reset();
        this.verificationLevel.reset();
        this.defaultNotificationLevel.reset();
        this.mfaLevel.reset();
    }

    public RestAction<Void> update() {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_SERVER);
        if (!this.needToUpdate()) {
            return new RestAction.EmptyRestAction<Object>(null);
        }
        JSONObject body = new JSONObject().put("name", this.guild.getName());
        if (this.name.shouldUpdate()) {
            body.put("name", this.name.getValue());
        }
        if (this.region.shouldUpdate()) {
            body.put("region", ((Region)((Object)this.region.getValue())).getKey());
        }
        if (this.timeout.shouldUpdate()) {
            body.put("afk_timeout", ((Guild.Timeout)((Object)this.timeout.getValue())).getSeconds());
        }
        if (this.icon.shouldUpdate()) {
            body.put("icon", this.icon.getValue() == null ? JSONObject.NULL : ((Icon)this.icon.getValue()).getEncoding());
        }
        if (this.splash.shouldUpdate()) {
            body.put("splash", this.splash.getValue() == null ? JSONObject.NULL : ((Icon)this.splash.getValue()).getEncoding());
        }
        if (this.afkChannel.shouldUpdate()) {
            body.put("afk_channel_id", this.afkChannel.getValue() == null ? JSONObject.NULL : ((VoiceChannel)this.afkChannel.getValue()).getId());
        }
        if (this.verificationLevel.shouldUpdate()) {
            body.put("verification_level", ((Guild.VerificationLevel)((Object)this.verificationLevel.getValue())).getKey());
        }
        if (this.defaultNotificationLevel.shouldUpdate()) {
            body.put("default_notification_level", ((Guild.NotificationLevel)((Object)this.defaultNotificationLevel.getValue())).getKey());
        }
        if (this.mfaLevel.shouldUpdate()) {
            body.put("mfa_level", ((Guild.MFALevel)((Object)this.mfaLevel.getValue())).getKey());
        }
        this.reset();
        Route.CompiledRoute route = Route.Guilds.MODIFY_GUILD.compile(this.guild.getId());
        return new RestAction<Void>(this.guild.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    protected boolean needToUpdate() {
        return this.name.shouldUpdate() || this.region.shouldUpdate() || this.timeout.shouldUpdate() || this.icon.shouldUpdate() || this.splash.shouldUpdate() || this.afkChannel.shouldUpdate() || this.verificationLevel.shouldUpdate() || this.defaultNotificationLevel.shouldUpdate() || this.mfaLevel.shouldUpdate();
    }

    protected void checkAvailable() {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
    }

    protected void checkPermission(Permission perm) {
        if (!PermissionUtil.checkPermission(this.guild, this.guild.getSelfMember(), perm)) {
            throw new PermissionException(perm);
        }
    }

    protected void setupFields() {
        this.name = new GuildField<String>(this, this.guild::getName){

            @Override
            public void checkValue(String value) {
                2.checkNull(value, "guild name");
                if (value.length() < 2 || value.length() > 100) {
                    throw new IllegalArgumentException("Provided guild name must be 2 to 100 characters in length");
                }
            }
        };
        this.timeout = new GuildField<Guild.Timeout>(this, this.guild::getAfkTimeout){

            @Override
            public void checkValue(Guild.Timeout value) {
                3.checkNull((Object)value, "Timeout");
            }
        };
        this.icon = new GuildField<Icon>(this, null){

            @Override
            public void checkValue(Icon value) {
                4.checkNull(value, "guild icon");
            }

            @Override
            public Icon getOriginalValue() {
                throw new UnsupportedOperationException("Cannot easily provide the original Icon. Use Guild#getIconUrl() and download it yourself.");
            }

            @Override
            public boolean shouldUpdate() {
                return this.isSet();
            }
        };
        this.splash = new GuildField<Icon>(this, null){

            @Override
            public void checkValue(Icon value) {
                5.checkNull(value, "guild splash");
            }

            @Override
            public Icon getOriginalValue() {
                throw new UnsupportedOperationException("Cannot easily provide the original Splash. Use Guild#getSplashUrl() and download it yourself.");
            }

            @Override
            public boolean shouldUpdate() {
                return this.isSet();
            }
        };
        this.region = new GuildField<Region>(this, this.guild::getRegion){

            @Override
            public void checkValue(Region value) {
                6.checkNull((Object)value, "Region");
                if (value == Region.UNKNOWN) {
                    throw new IllegalArgumentException("Cannot set Guild Region to UNKNOWN!");
                }
            }
        };
        this.afkChannel = new GuildField<VoiceChannel>(this, this.guild::getAfkChannel){

            @Override
            public void checkValue(VoiceChannel value) {
                if (value != null && !GuildManagerUpdatable.this.guild.equals(value.getGuild())) {
                    throw new IllegalArgumentException("Provided AFK Channel is not from this Guild!");
                }
            }
        };
        this.verificationLevel = new GuildField<Guild.VerificationLevel>(this, this.guild::getVerificationLevel){

            @Override
            public void checkValue(Guild.VerificationLevel value) {
                8.checkNull((Object)value, "VerificationLevel");
                if (value == Guild.VerificationLevel.UNKNOWN) {
                    throw new IllegalArgumentException("Cannot set Guild VerificationLevel to UNKNOWN");
                }
            }
        };
        this.defaultNotificationLevel = new GuildField<Guild.NotificationLevel>(this, this.guild::getDefaultNotificationLevel){

            @Override
            public void checkValue(Guild.NotificationLevel value) {
                9.checkNull((Object)value, "NotificationLevel");
                if (value == Guild.NotificationLevel.UNKNOWN) {
                    throw new IllegalArgumentException("Cannot set NotificationLevel to UNKNOWN");
                }
            }
        };
        this.mfaLevel = new GuildField<Guild.MFALevel>(this, this.guild::getRequiredMFALevel){

            @Override
            public void checkValue(Guild.MFALevel value) {
                10.checkNull((Object)value, "MFALevel");
                if (value == Guild.MFALevel.UNKNOWN) {
                    throw new IllegalArgumentException("Cannot set MFALevel to UNKNOWN");
                }
            }
        };
    }
}

