/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.AccountType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Emote;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.GuildVoiceState;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.ISnowflake;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Icon;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.VoiceChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.MemberImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.GuildUnavailableException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.PermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.RoleManagerUpdatable;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.PermissionUtil;
import net.shadowfacts.discordchat.repack.org.json.JSONArray;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class GuildController {
    protected final Guild guild;

    public GuildController(Guild guild) {
        this.guild = guild;
    }

    public Guild getGuild() {
        return this.guild;
    }

    public JDA getJDA() {
        return this.guild.getJDA();
    }

    public RestAction<Void> setNickname(Member member, String nickname) {
        this.checkAvailable();
        this.checkNull(member, "member");
        this.checkGuild(member.getGuild(), "member");
        if (member.equals(this.guild.getSelfMember())) {
            if (!PermissionUtil.checkPermission(this.guild, member, Permission.NICKNAME_CHANGE) && !PermissionUtil.checkPermission(this.guild, member, Permission.NICKNAME_MANAGE)) {
                throw new PermissionException(Permission.NICKNAME_CHANGE, "You neither have NICKNAME_CHANGE nor NICKNAME_MANAGE permission!");
            }
        } else {
            this.checkPermission(Permission.NICKNAME_MANAGE);
            this.checkPosition(member);
        }
        if (Objects.equals(nickname, member.getNickname())) {
            return new RestAction.EmptyRestAction<Object>(null);
        }
        if (nickname == null) {
            nickname = "";
        }
        JSONObject body = new JSONObject().put("nick", nickname);
        Route.CompiledRoute route = member.equals(this.guild.getSelfMember()) ? Route.Guilds.MODIFY_SELF_NICK.compile(this.guild.getId()) : Route.Guilds.MODIFY_MEMBER.compile(this.guild.getId(), member.getUser().getId());
        return new RestAction<Void>(this.guild.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<Void> moveVoiceMember(Member member, VoiceChannel voiceChannel) {
        this.checkAvailable();
        this.checkNull(member, "member");
        this.checkNull(member, "voiceChannel");
        this.checkGuild(member.getGuild(), "member");
        this.checkGuild(voiceChannel.getGuild(), "voiceChannel");
        GuildVoiceState vState = member.getVoiceState();
        if (!vState.inVoiceChannel()) {
            throw new IllegalStateException("You cannot move a Member who isn't in a VoiceChannel!");
        }
        if (!PermissionUtil.checkPermission(vState.getChannel(), this.guild.getSelfMember(), Permission.VOICE_MOVE_OTHERS)) {
            throw new PermissionException(Permission.VOICE_MOVE_OTHERS, "This account does not have Permission to MOVE_OTHERS out of the channel that the Member is currently in.");
        }
        if (!PermissionUtil.checkPermission(voiceChannel, this.guild.getSelfMember(), Permission.VOICE_CONNECT) && !PermissionUtil.checkPermission(voiceChannel, member, Permission.VOICE_CONNECT)) {
            throw new PermissionException(Permission.VOICE_CONNECT, "Neither this account nor the Member that is attempting to be moved have the VOICE_CONNECT permission for the destination VoiceChannel, so the move cannot be done.");
        }
        JSONObject body = new JSONObject().put("channel_id", voiceChannel.getId());
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.guild.getId(), member.getUser().getId());
        return new RestAction<Void>(this.guild.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<Integer> prune(int days) {
        this.checkAvailable();
        this.checkPermission(Permission.KICK_MEMBERS);
        if (days < 1) {
            throw new IllegalArgumentException("Days amount must be at minimum 1 day.");
        }
        Route.CompiledRoute route = Route.Guilds.PRUNE_MEMBERS.compile(this.guild.getId(), Integer.toString(days));
        return new RestAction<Integer>(this.guild.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(response.getObject().getInt("pruned"));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<Integer> getPrunableMemberCount(int days) {
        this.checkAvailable();
        this.checkPermission(Permission.KICK_MEMBERS);
        if (days < 1) {
            throw new IllegalArgumentException("Days amount must be at minimum 1 day.");
        }
        Route.CompiledRoute route = Route.Guilds.PRUNABLE_COUNT.compile(this.guild.getId(), Integer.toString(days));
        return new RestAction<Integer>(this.guild.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(response.getObject().getInt("pruned"));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<Void> kick(Member member) {
        this.checkAvailable();
        this.checkNull(member, "member");
        this.checkGuild(member.getGuild(), "member");
        this.checkPermission(Permission.KICK_MEMBERS);
        this.checkPosition(member);
        Route.CompiledRoute route = Route.Guilds.KICK_MEMBER.compile(this.guild.getId(), member.getUser().getId());
        return new RestAction<Void>(this.guild.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<Void> kick(String userId) {
        this.checkNull(userId, "userId");
        Member member = this.guild.getMemberById(userId);
        if (member == null) {
            throw new IllegalArgumentException("The provided userId does not correspond to a member in this guild! Provided userId: " + userId);
        }
        return this.kick(member);
    }

    public RestAction<Void> ban(Member member, int delDays) {
        this.checkAvailable();
        this.checkNull(member, "member");
        return this.ban(member.getUser(), delDays);
    }

    public RestAction<Void> ban(User user, int delDays) {
        this.checkAvailable();
        this.checkNull(user, "user");
        this.checkPermission(Permission.BAN_MEMBERS);
        if (this.guild.isMember(user)) {
            this.checkPosition(this.guild.getMember(user));
        }
        if (delDays < 0) {
            throw new IllegalArgumentException("Provided delDays cannot be less that 0. How can you delete messages that are -1 days old?");
        }
        Route.CompiledRoute route = delDays > 0 ? Route.Guilds.BAN_WITH_DELETE.compile(this.guild.getId(), user.getId(), Integer.toString(delDays)) : Route.Guilds.BAN.compile(this.guild.getId(), user.getId());
        return new RestAction<Void>(this.guild.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<Void> ban(final String userId, int delDays) {
        this.checkAvailable();
        this.checkNull(userId, "userId");
        this.checkPermission(Permission.BAN_MEMBERS);
        User user = this.guild.getJDA().getUserById(userId);
        if (user != null) {
            return this.ban(user, delDays);
        }
        Route.CompiledRoute route = delDays > 0 ? Route.Guilds.BAN_WITH_DELETE.compile(this.guild.getId(), userId, Integer.toString(delDays)) : Route.Guilds.BAN.compile(this.guild.getId(), userId);
        return new RestAction<Void>(this.guild.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else if (response.code == 404) {
                    request.onFailure(new IllegalArgumentException("User with provided id \"" + userId + "\" does not exist! Cannot ban a non-existent user!"));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<Void> unban(User user) {
        this.checkNull(user, "user");
        return this.unban(user.getId());
    }

    public RestAction<Void> unban(final String userId) {
        this.checkAvailable();
        this.checkNull(userId, "userId");
        this.checkPermission(Permission.BAN_MEMBERS);
        Route.CompiledRoute route = Route.Guilds.UNBAN.compile(this.guild.getId(), userId);
        return new RestAction<Void>(this.guild.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else if (response.code == 404) {
                    request.onFailure(new IllegalArgumentException("User with provided id \"" + userId + "\" does not exist! Cannot unban a non-existent user!"));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<Void> setDeafen(Member member, boolean deafen) {
        this.checkAvailable();
        this.checkNull(member, "member");
        this.checkGuild(member.getGuild(), "member");
        this.checkPermission(Permission.VOICE_DEAF_OTHERS);
        if (this.guild.getOwner().equals(member)) {
            throw new PermissionException("Cannot modified Guild Deafen status the Owner of the Guild");
        }
        if (member.getVoiceState().isGuildDeafened() == deafen) {
            return new RestAction.EmptyRestAction<Object>(null);
        }
        JSONObject body = new JSONObject().put("deaf", deafen);
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.guild.getId(), member.getUser().getId());
        return new RestAction<Void>(this.guild.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<Void> setMute(Member member, boolean mute) {
        this.checkAvailable();
        this.checkNull(member, "member");
        this.checkGuild(member.getGuild(), "member");
        this.checkPermission(Permission.VOICE_MUTE_OTHERS);
        if (this.guild.getOwner().equals(member)) {
            throw new PermissionException("Cannot modified Guild Mute status the Owner of the Guild");
        }
        if (member.getVoiceState().isGuildMuted() == mute) {
            return new RestAction.EmptyRestAction<Object>(null);
        }
        JSONObject body = new JSONObject().put("mute", mute);
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.guild.getId(), member.getUser().getId());
        return new RestAction<Void>(this.guild.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<List<User>> getBans() {
        this.checkAvailable();
        this.checkPermission(Permission.BAN_MEMBERS);
        Route.CompiledRoute route = Route.Guilds.GET_BANS.compile(this.guild.getId());
        return new RestAction<List<User>>(this.guild.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                EntityBuilder builder = EntityBuilder.get(GuildController.this.guild.getJDA());
                LinkedList<User> bans = new LinkedList<User>();
                JSONArray bannedArr = response.getArray();
                for (int i = 0; i < bannedArr.length(); ++i) {
                    JSONObject user = bannedArr.getJSONObject(i).getJSONObject("user");
                    bans.add(builder.createFakeUser(user, false));
                }
                request.onSuccess(Collections.unmodifiableList(bans));
            }
        };
    }

    public RestAction<Void> addRolesToMember(Member member, Role ... roles) {
        return this.modifyMemberRoles(member, Arrays.asList(roles), Collections.emptyList());
    }

    public RestAction<Void> addRolesToMember(Member member, Collection<Role> roles) {
        return this.modifyMemberRoles(member, roles, Collections.emptyList());
    }

    public RestAction<Void> removeRolesFromMember(Member member, Role ... roles) {
        return this.modifyMemberRoles(member, Collections.emptyList(), Arrays.asList(roles));
    }

    public RestAction<Void> removeRolesFromMember(Member member, Collection<Role> roles) {
        return this.modifyMemberRoles(member, Collections.emptyList(), roles);
    }

    public RestAction<Void> modifyMemberRoles(Member member, Collection<Role> rolesToAdd, Collection<Role> rolesToRemove) {
        this.checkAvailable();
        this.checkNull(member, "member");
        this.checkNull(rolesToAdd, "Collection containing roles to be added to the member");
        this.checkNull(rolesToRemove, "Collection containing roles to be removed from the member");
        this.checkGuild(member.getGuild(), "member");
        this.checkPermission(Permission.MANAGE_ROLES);
        rolesToAdd.forEach(role -> {
            this.checkNull(role, "role in rolesToAdd");
            this.checkGuild(role.getGuild(), "role: " + role.toString());
            this.checkPosition((Role)role);
            if (role.isManaged()) {
                throw new IllegalArgumentException("Cannot add a Managed role to a Member. Role: " + role.toString());
            }
        });
        rolesToRemove.forEach(role -> {
            this.checkNull(role, "role in rolesToRemove");
            this.checkGuild(role.getGuild(), "role: " + role.toString());
            this.checkPosition((Role)role);
            if (role.isManaged()) {
                throw new IllegalArgumentException("Cannot remove a Managed role from a Member. Role: " + role.toString());
            }
        });
        HashSet<Role> currentRoles = new HashSet<Role>(((MemberImpl)member).getRoleSet());
        currentRoles.addAll(rolesToAdd);
        currentRoles.removeAll(rolesToRemove);
        if (currentRoles.contains(this.guild.getPublicRole())) {
            throw new IllegalArgumentException("Cannot add the PublicRole of a Guild to a Member. All members have this role by default!");
        }
        JSONObject body = new JSONObject().put("roles", currentRoles.stream().map(ISnowflake::getId).collect(Collectors.toList()));
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.guild.getId(), member.getUser().getId());
        return new RestAction<Void>(this.guild.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<Void> modifyMemberRoles(Member member, Role ... roles) {
        return this.modifyMemberRoles(member, Arrays.asList(roles));
    }

    public RestAction<Void> modifyMemberRoles(Member member, Collection<Role> roles) {
        this.checkAvailable();
        this.checkNull(member, "member");
        this.checkNull(roles, "roles");
        this.checkGuild(member.getGuild(), "member");
        roles.forEach(role -> {
            this.checkNull(role, "role in collection");
            this.checkGuild(role.getGuild(), "role: " + role.toString());
            this.checkPosition((Role)role);
        });
        if (roles.contains(this.guild.getPublicRole())) {
            throw new IllegalArgumentException("Cannot add the PublicRole of a Guild to a Member. All members have this role by default!");
        }
        List currentManaged = roles.stream().filter(r -> r.isManaged()).collect(Collectors.toList());
        List newManaged = roles.stream().filter(r -> r.isManaged()).collect(Collectors.toList());
        if (currentManaged.size() != 0 || newManaged.size() != 0) {
            Iterator it = currentManaged.iterator();
            while (it.hasNext()) {
                Role r2 = (Role)it.next();
                if (!newManaged.contains(r2)) continue;
                it.remove();
            }
            if (currentManaged.size() > 0) {
                throw new IllegalArgumentException("Cannot remove managed roles from a member! Roles: " + currentManaged.toString());
            }
            if (newManaged.size() > 0) {
                throw new IllegalArgumentException("Cannot add managed roles to a member! Roles: " + newManaged.toString());
            }
        }
        JSONObject body = new JSONObject().put("roles", roles.stream().map(ISnowflake::getId).collect(Collectors.toList()));
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.guild.getId(), member.getUser().getId());
        return new RestAction<Void>(this.guild.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<Void> transferOwnership(Member newOwner) {
        this.checkAvailable();
        this.checkNull(newOwner, "newOwner member");
        this.checkGuild(newOwner.getGuild(), "newOwner member");
        if (!this.guild.getOwner().equals(this.guild.getSelfMember())) {
            throw new PermissionException("The logged in account must be the owner of this Guild to be able to transfer ownership");
        }
        if (this.guild.getSelfMember().equals(newOwner)) {
            throw new IllegalArgumentException("The member provided as the newOwner is the currently logged in account. Provide a different member to give ownership to.");
        }
        if (newOwner.getUser().isBot()) {
            throw new IllegalArgumentException("Cannot transfer ownership of a Guild to a Bot!");
        }
        JSONObject body = new JSONObject().put("owner_id", newOwner.getUser().getId());
        Route.CompiledRoute route = Route.Guilds.MODIFY_GUILD.compile(this.guild.getId());
        return new RestAction<Void>(this.guild.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public RestAction<TextChannel> createTextChannel(String name) {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_CHANNEL);
        this.checkNull(name, "name");
        if (name.length() < 2 || name.length() > 100) {
            throw new IllegalArgumentException("Provided name must be 2 - 100 characters in length");
        }
        JSONObject body = new JSONObject().put("type", "text").put("name", name);
        Route.CompiledRoute route = Route.Guilds.CREATE_CHANNEL.compile(this.guild.getId());
        return new RestAction<TextChannel>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                }
                JSONObject chanJson = response.getObject();
                TextChannel tc = EntityBuilder.get(this.api).createTextChannel(chanJson, GuildController.this.guild.getId());
                request.onSuccess(tc);
            }
        };
    }

    public RestAction<VoiceChannel> createVoiceChannel(String name) {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_CHANNEL);
        this.checkNull(name, "name");
        if (name.length() < 2 || name.length() > 100) {
            throw new IllegalArgumentException("Provided name must be 2 to 100 characters in length");
        }
        JSONObject body = new JSONObject().put("type", "voice").put("name", name);
        Route.CompiledRoute route = Route.Guilds.CREATE_CHANNEL.compile(this.guild.getId());
        return new RestAction<VoiceChannel>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                }
                JSONObject chanJson = response.getObject();
                VoiceChannel vc = EntityBuilder.get(this.api).createVoiceChannel(chanJson, GuildController.this.guild.getId());
                request.onSuccess(vc);
            }
        };
    }

    public RestAction<Role> createRole() {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_ROLES);
        Route.CompiledRoute route = Route.Roles.CREATE_ROLE.compile(this.guild.getId());
        return new RestAction<Role>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                }
                JSONObject roleJson = response.getObject();
                Role role = EntityBuilder.get(this.api).createRole(roleJson, GuildController.this.guild.getId());
                request.onSuccess(role);
            }
        };
    }

    public RestAction<Role> createCopyOfRole(final Role role) {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_ROLES);
        role.getPermissions().forEach(this::checkPermission);
        Route.CompiledRoute route = Route.Roles.CREATE_ROLE.compile(this.guild.getId());
        return new RestAction<Role>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                }
                JSONObject roleJson = response.getObject();
                Role r = EntityBuilder.get(this.api).createRole(roleJson, GuildController.this.guild.getId());
                RoleManagerUpdatable mng = ((RoleManagerUpdatable)((RoleManagerUpdatable)((RoleManagerUpdatable)((RoleManagerUpdatable)r.getManagerUpdatable().getNameField().setValue(role.getName())).getColorField().setValue(role.getColor())).getMentionableField().setValue(role.isMentionable())).getHoistedField().setValue(role.isHoisted())).getPermissionField().setValue(role.getPermissionsRaw());
                mng.update().queue(request.getOnSuccess(), request.getOnFailure());
            }
        };
    }

    public RestAction<Emote> createEmote(String name, Icon icon, Role ... roles) {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_EMOTES);
        this.checkNull(name, "emote name");
        this.checkNull(icon, "emote icon");
        if (this.getJDA().getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT);
        }
        JSONObject body = new JSONObject();
        body.put("name", name);
        body.put("image", icon.getEncoding());
        if (roles.length > 0) {
            body.put("roles", Stream.of(roles).filter(r -> r != null).map(ISnowflake::getId).collect(Collectors.toSet()));
        }
        Route.CompiledRoute route = Route.Emotes.CREATE_EMOTE.compile(this.guild.getId());
        return new RestAction<Emote>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    JSONObject obj = response.getObject();
                    String id = obj.getString("id");
                    String name = obj.getString("name");
                    EmoteImpl emote = new EmoteImpl(id, GuildController.this.guild).setName(name);
                    JSONArray rolesArr = obj.getJSONArray("roles");
                    HashSet<Role> roleSet = emote.getRoleSet();
                    for (int i = 0; i < rolesArr.length(); ++i) {
                        roleSet.add(GuildController.this.guild.getRoleById(rolesArr.getString(i)));
                    }
                    ((GuildImpl)GuildController.this.guild).getEmoteMap().put(id, emote);
                    request.onSuccess(emote);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    protected void checkAvailable() {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
    }

    protected void checkNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Provided " + name + " was null!");
        }
    }

    protected void checkGuild(Guild providedGuild, String comment) {
        if (!this.guild.equals(providedGuild)) {
            throw new IllegalArgumentException("Provided " + comment + " is not part of this Guild!");
        }
    }

    protected void checkPermission(Permission perm) {
        if (!PermissionUtil.checkPermission(this.guild, this.guild.getSelfMember(), perm)) {
            throw new PermissionException(perm);
        }
    }

    protected void checkPosition(Member member) {
        if (!PermissionUtil.canInteract(this.guild.getSelfMember(), member)) {
            throw new PermissionException("Can't modify a member with higher or equal highest role than yourself!");
        }
    }

    protected void checkPosition(Role role) {
        if (!PermissionUtil.canInteract(this.guild.getSelfMember(), role)) {
            throw new PermissionException("Can't modify a role with higher or equal highest role than yourself! Role: " + role.toString());
        }
    }
}

