/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers;

import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Channel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.VoiceChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.PermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.fields.ChannelField;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.PermissionUtil;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class ChannelManagerUpdatable {
    protected final Channel channel;
    protected ChannelField<String> name;
    protected ChannelField<String> topic;
    protected ChannelField<Integer> userLimit;
    protected ChannelField<Integer> bitrate;

    public ChannelManagerUpdatable(Channel channel) {
        this.channel = channel;
        this.setupFields();
    }

    public JDA getJDA() {
        return this.channel.getJDA();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Guild getGuild() {
        return this.channel.getGuild();
    }

    public ChannelField<String> getNameField() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        return this.name;
    }

    public ChannelField<String> getTopicField() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        if (this.channel instanceof VoiceChannel) {
            throw new UnsupportedOperationException("Setting a Topic on VoiceChannels is not allowed!");
        }
        return this.topic;
    }

    public ChannelField<Integer> getUserLimitField() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        if (this.channel instanceof TextChannel) {
            throw new UnsupportedOperationException("Setting user limit for TextChannels is not allowed!");
        }
        return this.userLimit;
    }

    public ChannelField<Integer> getBitrateField() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        if (this.channel instanceof TextChannel) {
            throw new UnsupportedOperationException("Setting user limit for TextChannels is not allowed!");
        }
        return this.bitrate;
    }

    public void reset() {
        this.name.reset();
        if (this.channel instanceof TextChannel) {
            this.topic.reset();
        } else {
            this.bitrate.reset();
            this.userLimit.reset();
        }
    }

    public RestAction<Void> update() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        if (!this.needToUpdate()) {
            return new RestAction.EmptyRestAction<Object>(null);
        }
        JSONObject frame = new JSONObject().put("name", this.channel.getName());
        if (this.name.shouldUpdate()) {
            frame.put("name", this.name.getValue());
        }
        if (this.topic != null && this.topic.shouldUpdate()) {
            frame.put("topic", this.topic.getValue() == null ? JSONObject.NULL : this.topic.getValue());
        }
        if (this.userLimit != null && this.userLimit.shouldUpdate()) {
            frame.put("user_limit", this.userLimit.getValue());
        }
        if (this.bitrate != null && this.bitrate.shouldUpdate()) {
            frame.put("bitrate", this.bitrate.getValue());
        }
        this.reset();
        Route.CompiledRoute route = Route.Channels.MODIFY_CHANNEL.compile(this.channel.getId());
        return new RestAction<Void>(this.channel.getJDA(), route, (Object)frame){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    protected boolean needToUpdate() {
        return this.name.shouldUpdate() || this.topic.shouldUpdate() || this.userLimit.shouldUpdate() || this.bitrate.shouldUpdate();
    }

    protected void checkPermission(Permission perm) {
        if (!PermissionUtil.checkPermission(this.channel, this.getGuild().getSelfMember(), perm)) {
            throw new PermissionException(perm);
        }
    }

    protected void setupFields() {
        this.name = new ChannelField<String>(this, this.channel::getName){

            @Override
            public void checkValue(String value) {
                2.checkNull(value, "name");
                if (value.length() < 2 || value.length() > 100) {
                    throw new IllegalArgumentException("Provided channel name must be 2 to 100 characters in length");
                }
            }
        };
        if (this.channel instanceof TextChannel) {
            TextChannel tc = (TextChannel)this.channel;
            this.topic = new ChannelField<String>(this, tc::getTopic){

                @Override
                public void checkValue(String value) {
                    if (value != null && value.length() > 1024) {
                        throw new IllegalArgumentException("Provided topic must less than or equal to 1024 characters in length");
                    }
                }
            };
        } else {
            VoiceChannel vc = (VoiceChannel)this.channel;
            this.userLimit = new ChannelField<Integer>(this, vc::getUserLimit){

                @Override
                public void checkValue(Integer value) {
                    4.checkNull(value, "user limit");
                    if (value < 1 || value > 99) {
                        throw new IllegalArgumentException("Provided user limit must be 1 to 99.");
                    }
                }
            };
            this.bitrate = new ChannelField<Integer>(this, vc::getBitrate){

                @Override
                public void checkValue(Integer value) {
                    5.checkNull(value, "bitrate");
                    if (value < 8000 || value > 96000) {
                        throw new IllegalArgumentException("Provided bitrate must be 8000 to 96000");
                    }
                }
            };
        }
    }
}

