/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Group;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.AccountType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.PrivateChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.user.UserTypingEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.SocketHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.GuildLock;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class TypingStartHandler
extends SocketHandler {
    public TypingStartHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String channelId = content.getString("channel_id");
        MessageChannel channel = this.api.getTextChannelMap().get(channelId);
        if (channel == null) {
            channel = this.api.getPrivateChannelMap().get(channelId);
        }
        if (channel == null) {
            channel = this.api.getFakePrivateChannelMap().get(channelId);
        }
        if (channel == null && this.api.getAccountType() == AccountType.CLIENT) {
            channel = this.api.asClient().getGroupById(channelId);
        }
        if (channel == null) {
            return null;
        }
        if (channel instanceof TextChannel) {
            String guildId = ((TextChannel)channel).getGuild().getId();
            if (GuildLock.get(this.api).isLocked(guildId)) {
                return guildId;
            }
        }
        String userId = content.getString("user_id");
        User user = channel instanceof PrivateChannel ? ((PrivateChannel)channel).getUser() : (channel instanceof Group ? ((GroupImpl)channel).getUserMap().get(userId) : this.api.getUserMap().get(userId));
        if (user == null) {
            return null;
        }
        OffsetDateTime timestamp = Instant.ofEpochSecond(content.getInt("timestamp")).atOffset(ZoneOffset.UTC);
        this.api.getEventManager().handle(new UserTypingEvent(this.api, this.responseNumber, user, channel, timestamp));
        return null;
    }
}

