/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle;

import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Group;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.events.message.group.GroupMessageDeleteEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.AccountType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.PrivateChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.message.MessageDeleteEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.message.guild.GuildMessageDeleteEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.message.priv.PrivateMessageDeleteEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.EventCache;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.SocketHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.GuildLock;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class MessageDeleteHandler
extends SocketHandler {
    public MessageDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String messageId = content.getString("id");
        String channelId = content.getString("channel_id");
        MessageChannel channel = this.api.getTextChannelById(channelId);
        if (channel == null) {
            channel = this.api.getPrivateChannelById(channelId);
        }
        if (channel == null) {
            channel = this.api.getFakePrivateChannelMap().get(channelId);
        }
        if (channel == null && this.api.getAccountType() == AccountType.CLIENT) {
            channel = this.api.asClient().getGroupById(channelId);
        }
        if (channel == null) {
            EventCache.get(this.api).cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Got message delete for a channel/group that is not yet cached. ChannelId: " + channelId);
            return null;
        }
        if (channel instanceof TextChannel) {
            MessageChannel tChan = channel;
            if (GuildLock.get(this.api).isLocked(tChan.getGuild().getId())) {
                return tChan.getGuild().getId();
            }
            this.api.getEventManager().handle(new GuildMessageDeleteEvent((JDA)this.api, this.responseNumber, messageId, (TextChannel)tChan));
        } else if (channel instanceof PrivateChannel) {
            this.api.getEventManager().handle(new PrivateMessageDeleteEvent((JDA)this.api, this.responseNumber, messageId, (PrivateChannel)channel));
        } else {
            this.api.getEventManager().handle(new GroupMessageDeleteEvent((JDA)this.api, this.responseNumber, messageId, (Group)channel));
        }
        this.api.getEventManager().handle(new MessageDeleteEvent(this.api, this.responseNumber, messageId, channel));
        return null;
    }
}

