/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle;

import java.awt.Color;
import java.util.Objects;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.RoleImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.role.update.RoleUpdateColorEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.role.update.RoleUpdateHoistedEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.role.update.RoleUpdateMentionableEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.role.update.RoleUpdateNameEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.role.update.RoleUpdatePermissionsEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.role.update.RoleUpdatePositionEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.EventCache;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.SocketHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.GuildLock;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class GuildRoleUpdateHandler
extends SocketHandler {
    public GuildRoleUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String guildId = content.getString("guild_id");
        if (GuildLock.get(this.api).isLocked(guildId)) {
            return guildId;
        }
        JSONObject rolejson = content.getJSONObject("role");
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
        if (guild == null) {
            EventCache.get(this.api).cache(EventCache.Type.GUILD, guildId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a Role Update for a Guild that is not yet cached: " + content);
            return null;
        }
        RoleImpl role = (RoleImpl)guild.getRolesMap().get(rolejson.getString("id"));
        if (role == null) {
            EventCache.get(this.api).cache(EventCache.Type.ROLE, rolejson.getString("id"), () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a Role Update for Role that is not yet cached: " + content);
            return null;
        }
        String name = rolejson.getString("name");
        Color color = rolejson.getInt("color") != 0 ? new Color(rolejson.getInt("color")) : null;
        int position = rolejson.getInt("position");
        long permissions = rolejson.getLong("permissions");
        boolean hoisted = rolejson.getBoolean("hoist");
        boolean mentionable = rolejson.getBoolean("mentionable");
        if (!Objects.equals(name, role.getName())) {
            String oldName = role.getName();
            role.setName(name);
            this.api.getEventManager().handle(new RoleUpdateNameEvent(this.api, this.responseNumber, role, oldName));
        }
        if (!Objects.equals(color, role.getColor())) {
            Color oldColor = role.getColor();
            role.setColor(color);
            this.api.getEventManager().handle(new RoleUpdateColorEvent(this.api, this.responseNumber, role, oldColor));
        }
        if (!Objects.equals(position, role.getPositionRaw())) {
            int oldPosition = role.getPosition();
            int oldPositionRaw = role.getPositionRaw();
            role.setRawPosition(position);
            this.api.getEventManager().handle(new RoleUpdatePositionEvent(this.api, this.responseNumber, role, oldPosition, oldPositionRaw));
        }
        if (!Objects.equals(permissions, role.getPermissionsRaw())) {
            long oldPermissionsRaw = role.getPermissionsRaw();
            role.setRawPermissions(permissions);
            this.api.getEventManager().handle(new RoleUpdatePermissionsEvent(this.api, this.responseNumber, role, oldPermissionsRaw));
        }
        if (hoisted != role.isHoisted()) {
            boolean wasHoisted = role.isHoisted();
            role.setHoisted(hoisted);
            this.api.getEventManager().handle(new RoleUpdateHoistedEvent(this.api, this.responseNumber, role, wasHoisted));
        }
        if (mentionable != role.isMentionable()) {
            boolean wasMentionable = role.isMentionable();
            role.setMentionable(mentionable);
            this.api.getEventManager().handle(new RoleUpdateMentionableEvent(this.api, this.responseNumber, role, wasMentionable));
        }
        return null;
    }
}

