/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle;

import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.MemberImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.role.RoleDeleteEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.EventCache;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.SocketHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.GuildLock;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class GuildRoleDeleteHandler
extends SocketHandler {
    public GuildRoleDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String guildId = content.getString("guild_id");
        if (GuildLock.get(this.api).isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
        if (guild == null) {
            EventCache.get(this.api).cache(EventCache.Type.GUILD, guildId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("GUILD_ROLE_DELETE was received for a Guild that is not yet cached: " + content);
            return null;
        }
        Role removedRole = guild.getRolesMap().remove(content.getString("role_id"));
        if (removedRole == null) {
            EventCache.get(this.api).cache(EventCache.Type.ROLE, content.getString("role_id"), () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("GUILD_ROLE_DELETE was received for a Role that is not yet cached: " + content);
            return null;
        }
        for (Member m : guild.getMembersMap().values()) {
            MemberImpl member = (MemberImpl)m;
            member.getRoleSet().remove(removedRole);
        }
        this.api.getEventManager().handle(new RoleDeleteEvent(this.api, this.responseNumber, removedRole));
        return null;
    }
}

