/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.events.group.update.GroupUpdateIconEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.events.group.update.GroupUpdateNameEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.events.group.update.GroupUpdateOwnerEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Channel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.ChannelType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.PermissionOverride;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.PermissionOverrideImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.TextChannelImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.VoiceChannelImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateNameEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdatePermissionsEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdatePositionEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.text.update.TextChannelUpdateTopicEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateBitrateEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateNameEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdatePermissionsEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdatePositionEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.channel.voice.update.VoiceChannelUpdateUserLimitEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.EventCache;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.SocketHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.repack.org.apache.commons.lang3.StringUtils;
import net.shadowfacts.discordchat.repack.org.json.JSONArray;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class ChannelUpdateHandler
extends SocketHandler {
    public ChannelUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        if (type == ChannelType.GROUP) {
            this.handleGroup(content);
            return null;
        }
        ArrayList<Role> changedRoles = new ArrayList<Role>();
        ArrayList<Member> changedMembers = new ArrayList<Member>();
        ArrayList<Role> containedRoles = new ArrayList<Role>();
        ArrayList<Member> containedMembers = new ArrayList<Member>();
        String name = content.getString("name");
        int position = content.getInt("position");
        JSONArray permOverwrites = content.getJSONArray("permission_overwrites");
        switch (type) {
            case TEXT: {
                String topic = content.isNull("topic") ? null : content.getString("topic");
                TextChannelImpl channel = (TextChannelImpl)this.api.getTextChannelMap().get(content.getString("id"));
                if (channel == null) {
                    EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("id"), () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_UPDATE attemped to update a TextChannel that does not exist. JSON: " + content);
                    return null;
                }
                if (!StringUtils.equals(channel.getName(), name)) {
                    String oldName = channel.getName();
                    channel.setName(name);
                    this.api.getEventManager().handle(new TextChannelUpdateNameEvent(this.api, this.responseNumber, channel, oldName));
                }
                if (!StringUtils.equals(channel.getTopic(), topic)) {
                    String oldTopic = channel.getTopic();
                    channel.setTopic(topic);
                    this.api.getEventManager().handle(new TextChannelUpdateTopicEvent(this.api, this.responseNumber, channel, oldTopic));
                }
                if (channel.getPositionRaw() != position) {
                    int oldPosition = channel.getPositionRaw();
                    channel.setRawPosition(position);
                    this.api.getEventManager().handle(new TextChannelUpdatePositionEvent(this.api, this.responseNumber, channel, oldPosition));
                }
                for (int i = 0; i < permOverwrites.length(); ++i) {
                    this.handlePermissionOverride(permOverwrites.getJSONObject(i), channel, content, changedRoles, containedRoles, changedMembers, containedMembers);
                }
                List<Role> collect = channel.getRoleOverrideMap().keySet().stream().filter(role -> !containedRoles.contains(role)).collect(Collectors.toList());
                collect.forEach(role -> {
                    changedRoles.add((Role)role);
                    channel.getRoleOverrideMap().remove(role);
                });
                List<Member> collect1 = channel.getMemberOverrideMap().keySet().stream().filter(user -> !containedMembers.contains(user)).collect(Collectors.toList());
                collect1.forEach(member -> {
                    changedMembers.add((Member)member);
                    channel.getMemberOverrideMap().remove(member);
                });
                if (changedRoles.isEmpty() && changedMembers.isEmpty()) break;
                this.api.getEventManager().handle(new TextChannelUpdatePermissionsEvent(this.api, this.responseNumber, channel, changedRoles, changedMembers));
                break;
            }
            case VOICE: {
                VoiceChannelImpl channel = (VoiceChannelImpl)this.api.getVoiceChannelMap().get(content.getString("id"));
                int userLimit = content.getInt("user_limit");
                int bitrate = content.getInt("bitrate");
                if (channel == null) {
                    EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("id"), () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_UPDATE attemped to update a VoiceChannel that does not exist. JSON: " + content);
                    return null;
                }
                if (!StringUtils.equals(channel.getName(), name)) {
                    String oldName = channel.getName();
                    channel.setName(name);
                    this.api.getEventManager().handle(new VoiceChannelUpdateNameEvent(this.api, this.responseNumber, channel, oldName));
                }
                if (channel.getPositionRaw() != position) {
                    int oldPosition = channel.getPositionRaw();
                    channel.setRawPosition(position);
                    this.api.getEventManager().handle(new VoiceChannelUpdatePositionEvent(this.api, this.responseNumber, channel, oldPosition));
                }
                if (channel.getUserLimit() != userLimit) {
                    int oldLimit = channel.getUserLimit();
                    channel.setUserLimit(userLimit);
                    this.api.getEventManager().handle(new VoiceChannelUpdateUserLimitEvent(this.api, this.responseNumber, channel, oldLimit));
                }
                if (channel.getBitrate() != bitrate) {
                    int oldBitrate = channel.getBitrate();
                    channel.setBitrate(bitrate);
                    this.api.getEventManager().handle(new VoiceChannelUpdateBitrateEvent(this.api, this.responseNumber, channel, oldBitrate));
                }
                for (int i = 0; i < permOverwrites.length(); ++i) {
                    this.handlePermissionOverride(permOverwrites.getJSONObject(i), channel, content, changedRoles, containedRoles, changedMembers, containedMembers);
                }
                List<Role> collect = channel.getRoleOverrideMap().keySet().stream().filter(role -> !containedRoles.contains(role)).collect(Collectors.toList());
                collect.forEach(role -> {
                    changedRoles.add((Role)role);
                    channel.getRoleOverrideMap().remove(role);
                });
                List<Member> collect1 = channel.getMemberOverrideMap().keySet().stream().filter(user -> !containedMembers.contains(user)).collect(Collectors.toList());
                collect1.forEach(member -> {
                    changedMembers.add((Member)member);
                    channel.getMemberOverrideMap().remove(member);
                });
                if (changedRoles.isEmpty() && changedMembers.isEmpty()) break;
                this.api.getEventManager().handle(new VoiceChannelUpdatePermissionsEvent(this.api, this.responseNumber, channel, changedRoles, changedMembers));
                break;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_UPDATE provided an unrecognized channel type JSON: " + content);
            }
        }
        return null;
    }

    private void handlePermissionOverride(JSONObject override, Channel channel, JSONObject content, List<Role> changedRoles, List<Role> containedRoles, List<Member> changedMembers, List<Member> containedMembers) {
        String id = override.getString("id");
        int allow = override.getInt("allow");
        int deny = override.getInt("deny");
        switch (override.getString("type")) {
            case "role": {
                Role role = ((GuildImpl)channel.getGuild()).getRolesMap().get(id);
                if (role == null) {
                    EventCache.get(this.api).cache(EventCache.Type.ROLE, id, () -> this.handlePermissionOverride(override, channel, content, changedRoles, containedRoles, changedMembers, containedMembers));
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to create or update a PermissionOverride for a Role that doesn't exist! JSON: " + content);
                    return;
                }
                PermissionOverride permOverride = channel instanceof TextChannel ? ((TextChannelImpl)channel).getRoleOverrideMap().get(role) : ((VoiceChannelImpl)channel).getRoleOverrideMap().get(role);
                if (permOverride == null) {
                    permOverride = EntityBuilder.get(this.api).createPermissionOverride(override, channel);
                    changedRoles.add(role);
                } else if (permOverride.getAllowedRaw() != (long)allow || permOverride.getDeniedRaw() != (long)deny) {
                    ((PermissionOverrideImpl)permOverride).setAllow(allow);
                    ((PermissionOverrideImpl)permOverride).setDeny(deny);
                    changedRoles.add(role);
                }
                containedRoles.add(role);
                break;
            }
            case "member": {
                Member member = channel.getGuild().getMemberById(override.getString("id"));
                if (member == null) {
                    EventCache.get(this.api).cache(EventCache.Type.USER, id, () -> this.handlePermissionOverride(override, channel, content, changedRoles, containedRoles, changedMembers, containedMembers));
                    EventCache.LOG.debug("CHANNEL_UPDATE attempted to create or update a PermissionOverride for User that doesn't exist in this Guild! JSON: " + content);
                    return;
                }
                PermissionOverride permOverride = channel instanceof TextChannel ? ((TextChannelImpl)channel).getMemberOverrideMap().get(member) : ((VoiceChannelImpl)channel).getMemberOverrideMap().get(member);
                if (permOverride == null) {
                    permOverride = EntityBuilder.get(this.api).createPermissionOverride(override, channel);
                    changedMembers.add(member);
                } else if (permOverride.getAllowedRaw() != (long)allow || permOverride.getDeniedRaw() != (long)deny) {
                    ((PermissionOverrideImpl)permOverride).setAllow(allow);
                    ((PermissionOverrideImpl)permOverride).setDeny(deny);
                    changedMembers.add(member);
                }
                containedMembers.add(member);
                break;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_UPDATE provided an unrecognized PermissionOverride type. JSON: " + content);
            }
        }
    }

    private void handleGroup(JSONObject content) {
        String groupId = content.getString("id");
        String name = !content.isNull("name") ? content.getString("name") : null;
        String iconId = !content.isNull("icon") ? content.getString("icon") : null;
        String ownerId = content.getString("owner_id");
        GroupImpl group = (GroupImpl)this.api.asClient().getGroupById(groupId);
        if (group == null) {
            EventCache.get(this.api).cache(EventCache.Type.CHANNEL, groupId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Recieved CHANNEL_UPDATE for a group that was not yet cached. JSON: " + content);
            return;
        }
        User owner = group.getUserMap().get(ownerId);
        if (!Objects.equals(name, group.getName())) {
            String oldName = group.getName();
            group.setName(name);
            this.api.getEventManager().handle(new GroupUpdateNameEvent(this.api, this.responseNumber, group, oldName));
        }
        if (!Objects.equals(iconId, group.getIconId())) {
            String oldIconId = group.getIconId();
            group.setIconId(iconId);
            this.api.getEventManager().handle(new GroupUpdateIconEvent(this.api, this.responseNumber, group, oldIconId));
        }
        if (!Objects.equals(owner, group.getOwner())) {
            User oldOwner = group.getOwner();
            group.setOwner(owner);
            this.api.getEventManager().handle(new GroupUpdateOwnerEvent(this.api, this.responseNumber, group, oldOwner));
        }
    }
}

