/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.shadowfacts.discordchat.repack.com.mashape.unirest.http.Unirest;
import net.shadowfacts.discordchat.repack.com.mashape.unirest.request.body.MultipartBody;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.exceptions.VerificationLevelException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.AccountType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.MessageBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.MessageHistory;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Channel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.ChannelType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.ISnowflake;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Message;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.PermissionOverride;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.PermissionOverrideImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.PermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.ChannelManager;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.ChannelManagerUpdatable;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.ErrorResponse;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.IOUtil;
import net.shadowfacts.discordchat.repack.org.apache.http.util.Args;
import net.shadowfacts.discordchat.repack.org.json.JSONArray;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class TextChannelImpl
implements TextChannel {
    private final String id;
    private final GuildImpl guild;
    private final HashMap<Member, PermissionOverride> memberOverrides = new HashMap();
    private final HashMap<Role, PermissionOverride> roleOverrides = new HashMap();
    private volatile ChannelManager manager;
    private volatile ChannelManagerUpdatable managerUpdatable;
    private Object mngLock = new Object();
    private String name;
    private String topic;
    private int rawPosition;

    public TextChannelImpl(String id, Guild guild) {
        this.id = id;
        this.guild = (GuildImpl)guild;
    }

    @Override
    public String getAsMention() {
        return "<#" + this.getId() + '>';
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public RestAction<Void> deleteMessages(Collection<Message> messages) {
        return this.deleteMessagesByIds(messages.stream().map(ISnowflake::getId).collect(Collectors.toList()));
    }

    @Override
    public RestAction<Void> deleteMessagesByIds(Collection<String> messageIds) {
        this.checkPermission(Permission.MESSAGE_MANAGE, "Must have MESSAGE_MANAGE in order to bulk delete messages in this channel regardless of author.");
        if (messageIds.size() < 2 || messageIds.size() > 100) {
            throw new IllegalArgumentException("Must provide at least 2 or at most 100 messages to be deleted.");
        }
        JSONObject body = new JSONObject().put("messages", messageIds);
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGES.compile(this.id);
        return new RestAction<Void>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public boolean canTalk() {
        return this.canTalk(this.guild.getSelfMember());
    }

    @Override
    public boolean canTalk(Member member) {
        if (!this.guild.equals(member.getGuild())) {
            throw new IllegalArgumentException("Provided Member is not from the Guild that this TextChannel is part of.");
        }
        return member.hasPermission((Channel)this, Permission.MESSAGE_READ, Permission.MESSAGE_WRITE);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChannelType getType() {
        return ChannelType.TEXT;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public List<Member> getMembers() {
        return Collections.unmodifiableList(((GuildImpl)this.getGuild()).getMembersMap().values().stream().filter(m -> m.getPermissions(this).contains((Object)Permission.MESSAGE_READ)).collect(Collectors.toList()));
    }

    @Override
    public int getPosition() {
        List<TextChannel> channels = this.guild.getTextChannels();
        for (int i = 0; i < channels.size(); ++i) {
            if (channels.get(i) != this) continue;
            return i;
        }
        throw new RuntimeException("Somehow when determining position we never found the TextChannel in the Guild's channels? wtf?");
    }

    @Override
    public int getPositionRaw() {
        return this.rawPosition;
    }

    @Override
    public JDA getJDA() {
        return this.guild.getJDA();
    }

    @Override
    public RestAction<Message> sendMessage(String text) {
        return this.sendMessage(new MessageBuilder().appendString(text).build());
    }

    @Override
    public RestAction<Message> sendMessage(Message msg) {
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        JSONObject json = new JSONObject().put("content", msg.getRawContent()).put("tts", msg.isTTS());
        return new RestAction<Message>(this.getJDA(), route, (Object)json){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    Message m = EntityBuilder.get(TextChannelImpl.this.getJDA()).createMessage(response.getObject());
                    request.onSuccess(m);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Message> sendFile(File file, Message message) throws IOException {
        this.checkNull(file, "file");
        return this.sendFile(file, file.getName(), message);
    }

    @Override
    public RestAction<Message> sendFile(File file, String fileName, Message message) throws IOException {
        this.checkNull(file, "file");
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Provided file is either null, doesn't exist or is not readable!");
        }
        if (file.length() > 0x800000L) {
            throw new IllegalArgumentException("File is to big! Max file-size is 8MB");
        }
        return this.sendFile(IOUtil.readFully(file), fileName, message);
    }

    @Override
    public RestAction<Message> sendFile(InputStream data, String fileName, Message message) {
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_WRITE);
        this.checkPermission(Permission.MESSAGE_ATTACH_FILES);
        this.checkNull(data, "data InputStream");
        this.checkNull(fileName, "fileName");
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.id);
        MultipartBody body = Unirest.post("https://discordapp.com/api/" + route.getCompiledRoute()).fields(null);
        body.field("file", data, fileName);
        if (message != null) {
            body.field("content", message.getRawContent());
            body.field("tts", message.isTTS());
        }
        return new RestAction<Message>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(EntityBuilder.get(this.api).createMessage(response.getObject()));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Message> sendFile(byte[] data, String fileName, Message message) {
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_WRITE);
        this.checkPermission(Permission.MESSAGE_ATTACH_FILES);
        this.checkNull(fileName, "fileName");
        if (data.length > 0x800000) {
            throw new IllegalArgumentException("Provided data is too large! Max file-size is 8MB");
        }
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.id);
        MultipartBody body = Unirest.post("https://discordapp.com/api/" + route.getCompiledRoute()).fields(null);
        body.field("file", data, fileName);
        if (message != null) {
            body.field("content", message.getRawContent());
            body.field("tts", message.isTTS());
        }
        return new RestAction<Message>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(EntityBuilder.get(this.api).createMessage(response.getObject()));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Message> getMessageById(String messageId) {
        if (this.getJDA().getAccountType() != AccountType.BOT) {
            throw new AccountTypeException(AccountType.BOT);
        }
        this.checkNull(messageId, "messageId");
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_HISTORY);
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Message>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    Message m = EntityBuilder.get(TextChannelImpl.this.getJDA()).createMessage(response.getObject());
                    request.onSuccess(m);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> deleteMessageById(String messageId) {
        this.checkNull(messageId, "messageId");
        this.checkPermission(Permission.MESSAGE_READ);
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    ErrorResponse error = ErrorResponse.fromJSON(response.getObject());
                    if (error == ErrorResponse.MISSING_PERMISSIONS) {
                        if (!TextChannelImpl.this.guild.getSelfMember().hasPermission(Permission.MESSAGE_READ)) {
                            request.onFailure(new PermissionException(Permission.MESSAGE_READ));
                        } else {
                            request.onFailure(new PermissionException(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE permission to delete another users Messages"));
                        }
                    } else {
                        request.onFailure(response);
                    }
                }
            }
        };
    }

    @Override
    public MessageHistory getHistory() {
        return new MessageHistory(this);
    }

    @Override
    public RestAction<MessageHistory> getHistoryAround(Message markerMessage, int limit) {
        return MessageHistory.getHistoryAround((MessageChannel)this, markerMessage, limit);
    }

    @Override
    public RestAction<MessageHistory> getHistoryAround(String markedMessageId, int limit) {
        return MessageHistory.getHistoryAround((MessageChannel)this, markedMessageId, limit);
    }

    @Override
    public RestAction<Void> sendTyping() {
        Route.CompiledRoute route = Route.Channels.SEND_TYPING.compile(this.id);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> pinMessageById(String messageId) {
        this.checkNull(messageId, "messageId");
        this.checkPermission(Permission.MESSAGE_READ, "You cannot pin a message in a channel you can't access. (MESSAGE_READ)");
        this.checkPermission(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE to pin or unpin messages.");
        Route.CompiledRoute route = Route.Messages.ADD_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> unpinMessageById(String messageId) {
        this.checkNull(messageId, "messageId");
        this.checkPermission(Permission.MESSAGE_READ, "You cannot unpin a message in a channel you can't access. (MESSAGE_READ)");
        this.checkPermission(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE to pin or unpin messages.");
        Route.CompiledRoute route = Route.Messages.REMOVE_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<List<Message>> getPinnedMessages() {
        this.checkPermission(Permission.MESSAGE_READ, "Cannot get the pinned message of a channel without MESSAGE_READ access.");
        Route.CompiledRoute route = Route.Messages.GET_PINNED_MESSAGES.compile(this.getId());
        return new RestAction<List<Message>>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    LinkedList<Message> pinnedMessages = new LinkedList<Message>();
                    EntityBuilder builder = EntityBuilder.get(TextChannelImpl.this.getJDA());
                    JSONArray pins = response.getArray();
                    for (int i = 0; i < pins.length(); ++i) {
                        pinnedMessages.add(builder.createMessage(pins.getJSONObject(i)));
                    }
                    request.onSuccess(Collections.unmodifiableList(pinnedMessages));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public PermissionOverride getOverrideForMember(Member member) {
        return this.memberOverrides.get(member);
    }

    @Override
    public PermissionOverride getOverrideForRole(Role role) {
        return this.roleOverrides.get(role);
    }

    @Override
    public List<PermissionOverride> getPermissionOverrides() {
        ArrayList<PermissionOverride> overrides = new ArrayList<PermissionOverride>(this.memberOverrides.size() + this.roleOverrides.size());
        overrides.addAll(this.memberOverrides.values());
        overrides.addAll(this.roleOverrides.values());
        return Collections.unmodifiableList(overrides);
    }

    @Override
    public List<PermissionOverride> getMemberPermissionOverrides() {
        return Collections.unmodifiableList(new ArrayList<PermissionOverride>(this.memberOverrides.values()));
    }

    @Override
    public List<PermissionOverride> getRolePermissionOverrides() {
        return Collections.unmodifiableList(new ArrayList<PermissionOverride>(this.roleOverrides.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelManager getManager() {
        ChannelManager mng = this.manager;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.manager;
                if (mng == null) {
                    mng = this.manager = new ChannelManager(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelManagerUpdatable getManagerUpdatable() {
        ChannelManagerUpdatable mng = this.managerUpdatable;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.managerUpdatable;
                if (mng == null) {
                    mng = this.managerUpdatable = new ChannelManagerUpdatable(this);
                }
            }
        }
        return mng;
    }

    @Override
    public RestAction<Void> delete() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Route.CompiledRoute route = Route.Channels.DELETE_CHANNEL.compile(this.id);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<PermissionOverride> createPermissionOverride(final Member member) {
        this.checkPermission(Permission.MANAGE_PERMISSIONS);
        Args.notNull(member, "member");
        if (!this.guild.equals(member.getGuild())) {
            throw new IllegalArgumentException("Provided member is not from the same guild as this channel!");
        }
        if (this.getMemberOverrideMap().containsKey(member)) {
            throw new IllegalStateException("Provided member already has a PermissionOverride in this channel!");
        }
        final PermissionOverrideImpl override = new PermissionOverrideImpl(this, member, null);
        JSONObject body = new JSONObject().put("id", member.getUser().getId()).put("type", "member").put("allow", 0).put("deny", 0);
        Route.CompiledRoute route = Route.Channels.CREATE_PERM_OVERRIDE.compile(this.id, member.getUser().getId());
        return new RestAction<PermissionOverride>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                }
                TextChannelImpl.this.getMemberOverrideMap().put(member, override);
                request.onSuccess(override);
            }
        };
    }

    @Override
    public RestAction<PermissionOverride> createPermissionOverride(final Role role) {
        this.checkPermission(Permission.MANAGE_PERMISSIONS);
        Args.notNull(role, "role");
        if (!this.guild.equals(role.getGuild())) {
            throw new IllegalArgumentException("Provided role is not from the same guild as this channel!");
        }
        if (this.getRoleOverrideMap().containsKey(role)) {
            throw new IllegalStateException("Provided role already has a PermissionOverride in this channel!");
        }
        final PermissionOverrideImpl override = new PermissionOverrideImpl(this, null, role);
        JSONObject body = new JSONObject().put("id", role.getId()).put("type", "role").put("allow", 0).put("deny", 0);
        Route.CompiledRoute route = Route.Channels.CREATE_PERM_OVERRIDE.compile(this.id, role.getId());
        return new RestAction<PermissionOverride>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                }
                TextChannelImpl.this.getRoleOverrideMap().put(role, override);
                request.onSuccess(override);
            }
        };
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextChannel)) {
            return false;
        }
        TextChannel oTChannel = (TextChannel)o;
        return this == oTChannel || this.getId().equals(oTChannel.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "TC:" + this.getName() + '(' + this.getId() + ')';
    }

    @Override
    public int compareTo(TextChannel chan) {
        if (this == chan) {
            return 0;
        }
        if (this.getGuild() != chan.getGuild()) {
            throw new IllegalArgumentException("Cannot compare TextChannels that aren't from the same guild!");
        }
        if (this.getPositionRaw() != chan.getPositionRaw()) {
            return chan.getPositionRaw() - this.getPositionRaw();
        }
        OffsetDateTime thisTime = this.getCreationTime();
        OffsetDateTime chanTime = chan.getCreationTime();
        return chanTime.compareTo(thisTime);
    }

    public TextChannelImpl setName(String name) {
        this.name = name;
        return this;
    }

    public TextChannelImpl setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public TextChannelImpl setRawPosition(int rawPosition) {
        this.rawPosition = rawPosition;
        return this;
    }

    public HashMap<Member, PermissionOverride> getMemberOverrideMap() {
        return this.memberOverrides;
    }

    public HashMap<Role, PermissionOverride> getRoleOverrideMap() {
        return this.roleOverrides;
    }

    private void checkVerification() {
        if (!this.guild.checkVerification()) {
            throw new VerificationLevelException(this.guild.getVerificationLevel());
        }
    }

    private void checkPermission(Permission permission) {
        this.checkPermission(permission, null);
    }

    private void checkPermission(Permission permission, String message) {
        if (!this.guild.getSelfMember().hasPermission((Channel)this, permission)) {
            if (message != null) {
                throw new PermissionException(permission, message);
            }
            throw new PermissionException(permission);
        }
    }

    private void checkNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Provided " + name + " was null!");
        }
    }
}

