/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl;

import java.awt.Color;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Channel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.PermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.RoleManager;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.RoleManagerUpdatable;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.PermissionUtil;
import net.shadowfacts.discordchat.repack.org.apache.http.util.Args;

public class RoleImpl
implements Role {
    private final String id;
    private final Guild guild;
    private volatile RoleManager manager;
    private volatile RoleManagerUpdatable managerUpdatable;
    private Object mngLock = new Object();
    private String name;
    private Color color;
    private boolean managed;
    private boolean hoisted;
    private boolean mentionable;
    private long rawPermissions;
    private int rawPosition;

    public RoleImpl(String id, Guild guild) {
        this.id = id;
        this.guild = guild;
    }

    @Override
    public int getPosition() {
        if (this == this.guild.getPublicRole()) {
            return -1;
        }
        int i = this.guild.getRoles().size() - 2;
        for (Role r : this.guild.getRoles()) {
            if (r == this) {
                return i;
            }
            --i;
        }
        throw new RuntimeException("Somehow when determining position we never found the role in the Guild's roles? wtf?");
    }

    @Override
    public int getPositionRaw() {
        return this.rawPosition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public boolean isHoisted() {
        return this.hoisted;
    }

    @Override
    public boolean isMentionable() {
        return this.mentionable;
    }

    @Override
    public long getPermissionsRaw() {
        return this.rawPermissions;
    }

    @Override
    public List<Permission> getPermissions() {
        return Collections.unmodifiableList(Permission.getPermissions(this.rawPermissions));
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean hasPermission(Permission ... permissions) {
        long effectivePerms = this.rawPermissions | this.guild.getPublicRole().getPermissionsRaw();
        for (Permission perm : permissions) {
            if ((effectivePerms >> perm.getOffset() & 1L) == 1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPermission(Collection<Permission> permissions) {
        Args.notNull(permissions, "Permission Collection");
        return this.hasPermission(permissions.toArray(new Permission[permissions.size()]));
    }

    @Override
    public boolean hasPermission(Channel channel, Permission ... permissions) {
        long effectivePerms = PermissionUtil.getEffectivePermission(channel, this);
        for (Permission perm : permissions) {
            if ((effectivePerms >> perm.getOffset() & 1L) == 1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPermission(Channel channel, Collection<Permission> permissions) {
        Args.notNull(permissions, "Permission Collection");
        return this.hasPermission(channel, permissions.toArray(new Permission[permissions.size()]));
    }

    @Override
    public boolean canInteract(Role role) {
        return PermissionUtil.canInteract(this, role);
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoleManager getManager() {
        RoleManager mng = this.manager;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.manager;
                if (mng == null) {
                    mng = this.manager = new RoleManager(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoleManagerUpdatable getManagerUpdatable() {
        RoleManagerUpdatable mng = this.managerUpdatable;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.managerUpdatable;
                if (mng == null) {
                    mng = this.managerUpdatable = new RoleManagerUpdatable(this);
                }
            }
        }
        return mng;
    }

    @Override
    public RestAction<Void> delete() {
        if (!PermissionUtil.checkPermission(this.getGuild(), this.getGuild().getSelfMember(), Permission.MANAGE_PERMISSIONS)) {
            throw new PermissionException(Permission.MANAGE_PERMISSIONS);
        }
        if (!PermissionUtil.canInteract(this.getGuild().getSelfMember(), (Role)this)) {
            throw new PermissionException("Can't delete role >= highest self-role");
        }
        if (this.managed) {
            throw new UnsupportedOperationException("Cannot delete a Role that is managed. ");
        }
        Route.CompiledRoute route = Route.Roles.DELETE_ROLE.compile(this.guild.getId(), this.id);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public JDA getJDA() {
        return this.guild.getJDA();
    }

    @Override
    public String getAsMention() {
        return "<@&" + this.getId() + '>';
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Role)) {
            return false;
        }
        Role oRole = (Role)o;
        return this == oRole || this.getId().equals(oRole.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "R:" + this.getName() + '(' + this.getId() + ')';
    }

    @Override
    public int compareTo(Role r) {
        if (this == r) {
            return 0;
        }
        if (this.getGuild() != r.getGuild()) {
            throw new IllegalArgumentException("Cannot compare roles that aren't from the same guild!");
        }
        if (this.getPositionRaw() != r.getPositionRaw()) {
            return this.getPositionRaw() - r.getPositionRaw();
        }
        OffsetDateTime thisTime = this.getCreationTime();
        OffsetDateTime rTime = r.getCreationTime();
        return rTime.compareTo(thisTime);
    }

    public RoleImpl setName(String name) {
        this.name = name;
        return this;
    }

    public RoleImpl setColor(Color color) {
        this.color = color;
        return this;
    }

    public RoleImpl setManaged(boolean managed) {
        this.managed = managed;
        return this;
    }

    public RoleImpl setHoisted(boolean hoisted) {
        this.hoisted = hoisted;
        return this;
    }

    public RoleImpl setMentionable(boolean mentionable) {
        this.mentionable = mentionable;
        return this;
    }

    public RoleImpl setRawPermissions(long rawPermissions) {
        this.rawPermissions = rawPermissions;
        return this;
    }

    public RoleImpl setRawPosition(int rawPosition) {
        this.rawPosition = rawPosition;
        return this;
    }
}

