/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl;

import java.awt.Color;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.OnlineStatus;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Channel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Emote;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Game;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.GuildVoiceState;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.GuildVoiceStateImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.PermissionUtil;
import net.shadowfacts.discordchat.repack.org.apache.http.util.Args;

public class MemberImpl
implements Member {
    private final Guild guild;
    private final User user;
    private final TreeSet<Role> roles = new TreeSet((r1, r2) -> r2.compareTo(r1));
    private final GuildVoiceState voiceState;
    private String nickname;
    private OffsetDateTime joinDate;
    private Game game;
    private OnlineStatus onlineStatus = OnlineStatus.OFFLINE;

    public MemberImpl(Guild guild, User user) {
        this.guild = guild;
        this.user = user;
        this.voiceState = new GuildVoiceStateImpl(guild, this);
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public JDA getJDA() {
        return this.user.getJDA();
    }

    @Override
    public OffsetDateTime getJoinDate() {
        return this.joinDate;
    }

    @Override
    public GuildVoiceState getVoiceState() {
        return this.voiceState;
    }

    @Override
    public Game getGame() {
        return this.game;
    }

    @Override
    public OnlineStatus getOnlineStatus() {
        return this.onlineStatus;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getEffectiveName() {
        return this.nickname != null ? this.nickname : this.user.getName();
    }

    @Override
    public List<Role> getRoles() {
        return Collections.unmodifiableList(new ArrayList<Role>(this.roles));
    }

    @Override
    public Color getColor() {
        for (Role r : this.getRoles()) {
            if (r.getColor() == null) continue;
            return r.getColor();
        }
        return null;
    }

    @Override
    public List<Permission> getPermissions() {
        return Collections.unmodifiableList(Permission.getPermissions(PermissionUtil.getEffectivePermission(this.guild, (Member)this)));
    }

    @Override
    public List<Permission> getPermissions(Channel channel) {
        if (!this.guild.equals(channel.getGuild())) {
            throw new IllegalArgumentException("Provided channel is not in the same guild as this member!");
        }
        return Collections.unmodifiableList(Permission.getPermissions(PermissionUtil.getEffectivePermission(channel, (Member)this)));
    }

    @Override
    public boolean hasPermission(Permission ... permissions) {
        return PermissionUtil.checkPermission(this.guild, (Member)this, permissions);
    }

    @Override
    public boolean hasPermission(Collection<Permission> permissions) {
        Args.notNull(permissions, "Permission Collection");
        return this.hasPermission(permissions.toArray(new Permission[permissions.size()]));
    }

    @Override
    public boolean hasPermission(Channel channel, Permission ... permissions) {
        return PermissionUtil.checkPermission(channel, (Member)this, permissions);
    }

    @Override
    public boolean hasPermission(Channel channel, Collection<Permission> permissions) {
        Args.notNull(permissions, "Permission Collection");
        return this.hasPermission(channel, permissions.toArray(new Permission[permissions.size()]));
    }

    @Override
    public boolean canInteract(Member member) {
        return PermissionUtil.canInteract((Member)this, member);
    }

    @Override
    public boolean canInteract(Role role) {
        return PermissionUtil.canInteract((Member)this, role);
    }

    @Override
    public boolean canInteract(Emote emote) {
        return PermissionUtil.canInteract((Member)this, emote);
    }

    public MemberImpl setNickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    public MemberImpl setJoinDate(OffsetDateTime joinDate) {
        this.joinDate = joinDate;
        return this;
    }

    public MemberImpl setGame(Game game) {
        this.game = game;
        return this;
    }

    public MemberImpl setOnlineStatus(OnlineStatus onlineStatus) {
        this.onlineStatus = onlineStatus;
        return this;
    }

    public TreeSet<Role> getRoleSet() {
        return this.roles;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Member)) {
            return false;
        }
        Member oMember = (Member)o;
        return this == oMember || oMember.getUser().equals(this.user) && oMember.getGuild().equals(this.guild);
    }

    public int hashCode() {
        return (this.guild.getId() + this.user.getId()).hashCode();
    }

    public String toString() {
        return "MB:" + this.getEffectiveName() + '(' + this.user.toString() + " / " + this.guild.toString() + ')';
    }

    @Override
    public String getAsMention() {
        return this.user.getAsMention();
    }
}

