/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl;

import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.AccountType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Region;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Emote;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.VoiceChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.VoiceState;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.PermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.GuildController;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.GuildManager;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.GuildManagerUpdatable;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.MiscUtil;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.repack.org.apache.commons.lang3.StringUtils;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class GuildImpl
implements Guild {
    private final String id;
    private final JDAImpl api;
    private final HashMap<String, TextChannel> textChannels = new HashMap();
    private final HashMap<String, VoiceChannel> voiceChannels = new HashMap();
    private final HashMap<String, Member> members = new HashMap();
    private final HashMap<String, Role> roles = new HashMap();
    private final HashMap<String, Emote> emotes = new HashMap();
    private final HashMap<String, JSONObject> cachedPresences = new HashMap();
    private volatile GuildManager manager;
    private volatile GuildManagerUpdatable managerUpdatable;
    private volatile GuildController controller;
    private Object mngLock = new Object();
    private Member owner;
    private String name;
    private String iconId;
    private String splashId;
    private Region region;
    private TextChannel publicChannel;
    private VoiceChannel afkChannel;
    private Role publicRole;
    private Guild.VerificationLevel verificationLevel;
    private Guild.NotificationLevel defaultNotificationLevel;
    private Guild.MFALevel mfaLevel;
    private Guild.Timeout afkTimeout;
    private boolean available;
    private boolean canSendVerification = false;

    public GuildImpl(JDAImpl api, String id) {
        this.id = id;
        this.api = api;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public String getIconUrl() {
        return this.iconId == null ? null : "https://cdn.discordapp.com/icons/" + this.id + "/" + this.iconId + ".jpg";
    }

    @Override
    public String getSplashId() {
        return this.splashId;
    }

    @Override
    public String getSplashUrl() {
        return this.splashId == null ? null : "https://cdn.discordapp.com/splashes/" + this.id + "/" + this.splashId + ".jpg";
    }

    @Override
    public VoiceChannel getAfkChannel() {
        return this.afkChannel;
    }

    @Override
    public Member getOwner() {
        return this.owner;
    }

    @Override
    public Guild.Timeout getAfkTimeout() {
        return this.afkTimeout;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public boolean isMember(User user) {
        return this.members.containsKey(user.getId());
    }

    @Override
    public Member getSelfMember() {
        return this.getMember(this.getJDA().getSelfUser());
    }

    @Override
    public Member getMember(User user) {
        return this.getMemberById(user.getId());
    }

    @Override
    public Member getMemberById(String userId) {
        return this.members.get(userId);
    }

    @Override
    public List<Member> getMembers() {
        return Collections.unmodifiableList(new ArrayList<Member>(this.members.values()));
    }

    @Override
    public List<Member> getMembersByName(String name, boolean ignoreCase) {
        return Collections.unmodifiableList(this.members.values().stream().filter(m -> ignoreCase ? name.equalsIgnoreCase(m.getUser().getName()) : name.equals(m.getUser().getName())).collect(Collectors.toList()));
    }

    @Override
    public List<Member> getMembersByNickname(String nickname, boolean ignoreCase) {
        return Collections.unmodifiableList(this.members.values().stream().filter(m -> ignoreCase ? nickname.equalsIgnoreCase(m.getNickname()) : nickname.equals(m.getNickname())).collect(Collectors.toList()));
    }

    @Override
    public List<Member> getMembersByEffectiveName(String name, boolean ignoreCase) {
        return Collections.unmodifiableList(this.members.values().stream().filter(m -> ignoreCase ? name.equalsIgnoreCase(m.getEffectiveName()) : name.equals(m.getEffectiveName())).collect(Collectors.toList()));
    }

    @Override
    public List<Member> getMembersWithRoles(Role ... roles) {
        return this.getMembersWithRoles(Arrays.asList(roles));
    }

    @Override
    public List<Member> getMembersWithRoles(Collection<Role> roles) {
        return Collections.unmodifiableList(this.members.values().stream().filter(m -> m.getRoles().containsAll(roles)).collect(Collectors.toList()));
    }

    @Override
    public TextChannel getTextChannelById(String id) {
        return this.textChannels.get(id);
    }

    @Override
    public List<TextChannel> getTextChannelsByName(String name, boolean ignoreCase) {
        return Collections.unmodifiableList(this.textChannels.values().stream().filter(tc -> ignoreCase ? name.equalsIgnoreCase(tc.getName()) : name.equals(tc.getName())).collect(Collectors.toList()));
    }

    @Override
    public List<TextChannel> getTextChannels() {
        ArrayList<TextChannel> channels = new ArrayList<TextChannel>(this.textChannels.values());
        Collections.sort(channels, (c1, c2) -> c2.compareTo(c1));
        return Collections.unmodifiableList(channels);
    }

    @Override
    public VoiceChannel getVoiceChannelById(String id) {
        return this.voiceChannels.get(id);
    }

    @Override
    public List<VoiceChannel> getVoiceChannelsByName(String name, boolean ignoreCase) {
        return Collections.unmodifiableList(this.voiceChannels.values().stream().filter(vc -> ignoreCase ? name.equalsIgnoreCase(vc.getName()) : name.equals(vc.getName())).collect(Collectors.toList()));
    }

    @Override
    public List<VoiceChannel> getVoiceChannels() {
        ArrayList<VoiceChannel> channels = new ArrayList<VoiceChannel>(this.voiceChannels.values());
        Collections.sort(channels, (v1, v2) -> v2.compareTo(v1));
        return Collections.unmodifiableList(channels);
    }

    @Override
    public Role getRoleById(String id) {
        return this.roles.get(id);
    }

    @Override
    public List<Role> getRoles() {
        ArrayList<Role> list = new ArrayList<Role>(this.roles.values());
        Collections.sort(list, (r1, r2) -> r2.compareTo(r1));
        return Collections.unmodifiableList(list);
    }

    @Override
    public List<Role> getRolesByName(String name, boolean ignoreCase) {
        return Collections.unmodifiableList(this.roles.values().stream().filter(r -> ignoreCase ? name.equalsIgnoreCase(r.getName()) : name.equals(r.getName())).collect(Collectors.toList()));
    }

    @Override
    public Emote getEmoteById(String id) {
        return this.emotes.get(id);
    }

    @Override
    public List<Emote> getEmotes() {
        return Collections.unmodifiableList(new LinkedList<Emote>(this.emotes.values()));
    }

    @Override
    public List<Emote> getEmotesByName(String name, boolean ignoreCase) {
        return Collections.unmodifiableList(this.emotes.values().parallelStream().filter(e -> ignoreCase ? StringUtils.equalsIgnoreCase(e.getName(), name) : StringUtils.equals(e.getName(), name)).collect(Collectors.toList()));
    }

    @Override
    public Role getPublicRole() {
        return this.publicRole;
    }

    @Override
    public TextChannel getPublicChannel() {
        return this.publicChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GuildManager getManager() {
        GuildManager mng = this.manager;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.manager;
                if (mng == null) {
                    mng = this.manager = new GuildManager(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GuildManagerUpdatable getManagerUpdatable() {
        GuildManagerUpdatable mng = this.managerUpdatable;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.managerUpdatable;
                if (mng == null) {
                    mng = this.managerUpdatable = new GuildManagerUpdatable(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GuildController getController() {
        GuildController ctrl = this.controller;
        if (ctrl == null) {
            Object object = this.mngLock;
            synchronized (object) {
                ctrl = this.controller;
                if (ctrl == null) {
                    ctrl = this.controller = new GuildController(this);
                }
            }
        }
        return ctrl;
    }

    @Override
    public RestAction<Void> leave() {
        if (this.owner.equals(this.getSelfMember())) {
            throw new IllegalStateException("Cannot leave a guild that you are the owner of! Transfer guild ownership first!");
        }
        Route.CompiledRoute route = Route.Self.LEAVE_GUILD.compile(this.id);
        return new RestAction<Void>((JDA)this.api, route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> delete() {
        if (!this.owner.equals(this.getSelfMember())) {
            throw new PermissionException("Cannot delete a guild that you do not own!");
        }
        Route.CompiledRoute route = Route.Guilds.DELETE_GUILD.compile(this.id);
        return new RestAction<Void>((JDA)this.api, route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public List<VoiceState> getVoiceStates() {
        return Collections.unmodifiableList(this.members.values().stream().map(Member::getVoiceState).collect(Collectors.toList()));
    }

    @Override
    public Guild.VerificationLevel getVerificationLevel() {
        return this.verificationLevel;
    }

    @Override
    public Guild.NotificationLevel getDefaultNotificationLevel() {
        return this.defaultNotificationLevel;
    }

    @Override
    public Guild.MFALevel getRequiredMFALevel() {
        return this.mfaLevel;
    }

    @Override
    public boolean checkVerification() {
        if (this.api.getAccountType() == AccountType.BOT) {
            return true;
        }
        if (this.canSendVerification) {
            return true;
        }
        switch (this.verificationLevel) {
            case HIGH: {
                if (ChronoUnit.MINUTES.between(this.getSelfMember().getJoinDate(), OffsetDateTime.now()) < 10L) break;
            }
            case MEDIUM: {
                if (ChronoUnit.MINUTES.between(MiscUtil.getCreationTime(this.api.getSelfUser()), OffsetDateTime.now()) < 5L) break;
            }
            case LOW: {
                if (!this.api.getSelfUser().isVerified()) break;
            }
            case NONE: {
                this.canSendVerification = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public GuildImpl setAvailable(boolean available) {
        this.available = available;
        return this;
    }

    public GuildImpl setOwner(Member owner) {
        this.owner = owner;
        return this;
    }

    public GuildImpl setName(String name) {
        this.name = name;
        return this;
    }

    public GuildImpl setIconId(String iconId) {
        this.iconId = iconId;
        return this;
    }

    public GuildImpl setSplashId(String splashId) {
        this.splashId = splashId;
        return this;
    }

    public GuildImpl setRegion(Region region) {
        this.region = region;
        return this;
    }

    public GuildImpl setPublicChannel(TextChannel publicChannel) {
        this.publicChannel = publicChannel;
        return this;
    }

    public GuildImpl setAfkChannel(VoiceChannel afkChannel) {
        this.afkChannel = afkChannel;
        return this;
    }

    public GuildImpl setPublicRole(Role publicRole) {
        this.publicRole = publicRole;
        return this;
    }

    public GuildImpl setVerificationLevel(Guild.VerificationLevel level) {
        this.verificationLevel = level;
        this.canSendVerification = false;
        return this;
    }

    public GuildImpl setDefaultNotificationLevel(Guild.NotificationLevel level) {
        this.defaultNotificationLevel = level;
        return this;
    }

    public GuildImpl setRequiredMFALevel(Guild.MFALevel level) {
        this.mfaLevel = level;
        return this;
    }

    public GuildImpl setAfkTimeout(Guild.Timeout afkTimeout) {
        this.afkTimeout = afkTimeout;
        return this;
    }

    public HashMap<String, TextChannel> getTextChannelsMap() {
        return this.textChannels;
    }

    public HashMap<String, VoiceChannel> getVoiceChannelMap() {
        return this.voiceChannels;
    }

    public HashMap<String, Member> getMembersMap() {
        return this.members;
    }

    public HashMap<String, Role> getRolesMap() {
        return this.roles;
    }

    public HashMap<String, JSONObject> getCachedPresenceMap() {
        return this.cachedPresences;
    }

    public HashMap<String, Emote> getEmoteMap() {
        return this.emotes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Guild)) {
            return false;
        }
        Guild oGuild = (Guild)o;
        return this == oGuild || this.getId().equals(oGuild.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "G:" + this.getName() + '(' + this.getId() + ')';
    }
}

