/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.shadowfacts.discordchat.repack.org.apache.http.util.Args;

public enum Permission {
    CREATE_INSTANT_INVITE(0, true, true),
    KICK_MEMBERS(1, true, false),
    BAN_MEMBERS(2, true, false),
    ADMINISTRATOR(3, true, false),
    MANAGE_CHANNEL(4, true, true),
    MANAGE_SERVER(5, true, false),
    MESSAGE_READ(10, true, true),
    MESSAGE_WRITE(11, true, true),
    MESSAGE_TTS(12, true, true),
    MESSAGE_MANAGE(13, true, true),
    MESSAGE_EMBED_LINKS(14, true, true),
    MESSAGE_ATTACH_FILES(15, true, true),
    MESSAGE_HISTORY(16, true, true),
    MESSAGE_MENTION_EVERYONE(17, true, true),
    MESSAGE_EXT_EMOJI(18, true, true),
    VOICE_CONNECT(20, true, true),
    VOICE_SPEAK(21, true, true),
    VOICE_MUTE_OTHERS(22, true, true),
    VOICE_DEAF_OTHERS(23, true, true),
    VOICE_MOVE_OTHERS(24, true, true),
    VOICE_USE_VAD(25, true, true),
    NICKNAME_CHANGE(26, true, false),
    NICKNAME_MANAGE(27, true, false),
    MANAGE_ROLES(28, true, false),
    MANAGE_PERMISSIONS(28, false, true),
    MANAGE_WEBHOOKS(29, true, true),
    MANAGE_EMOTES(30, true, false),
    UNKNOWN(-1, false, false);

    private final int offset;
    private final boolean isGuild;
    private final boolean isChannel;

    private Permission(int offset, boolean isGuild, boolean isChannel) {
        this.offset = offset;
        this.isGuild = isGuild;
        this.isChannel = isChannel;
    }

    public int getOffset() {
        return this.offset;
    }

    public long getRawValue() {
        return 1 << this.getOffset();
    }

    public boolean isGuild() {
        return this.isGuild;
    }

    public boolean isChannel() {
        return this.isChannel;
    }

    public static Permission getFromOffset(int offset) {
        for (Permission perm : Permission.values()) {
            if (perm.offset != offset) continue;
            return perm;
        }
        return UNKNOWN;
    }

    public static List<Permission> getPermissions(long permissions) {
        LinkedList<Permission> perms = new LinkedList<Permission>();
        for (Permission perm : Permission.values()) {
            if (perm.equals((Object)UNKNOWN) || (permissions >> perm.getOffset() & 1L) != 1L) continue;
            perms.add(perm);
        }
        return perms;
    }

    public static long getRaw(Permission ... permissions) {
        long raw = 0L;
        for (Permission perm : permissions) {
            raw |= (long)(1 << perm.getOffset());
        }
        return raw;
    }

    public static long getRaw(Collection<Permission> permissions) {
        Args.notNull(permissions, "Permission Collection");
        return Permission.getRaw(permissions.toArray(new Permission[permissions.size()]));
    }
}

