/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Message;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.Event;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.message.MessageDeleteEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.message.MessageUpdateEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.PermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.hooks.EventListener;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.org.apache.commons.collections4.map.ListOrderedMap;
import net.shadowfacts.discordchat.repack.org.json.JSONArray;

public class MessageHistory
implements EventListener {
    protected final JDAImpl api;
    protected final MessageChannel channel;
    protected ListOrderedMap<String, Message> history = new ListOrderedMap();
    protected String markerId;

    public MessageHistory(MessageChannel channel) {
        this.api = (JDAImpl)channel.getJDA();
        this.channel = channel;
        if (channel instanceof TextChannel && !((TextChannel)channel).getGuild().getMember(this.api.getSelfUser()).hasPermission(Permission.MESSAGE_HISTORY)) {
            throw new PermissionException(Permission.MESSAGE_HISTORY);
        }
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public synchronized RestAction<List<Message>> retrievePast(int amount) {
        if (amount > 100 || amount < 0) {
            throw new IllegalArgumentException("Message retrieval limit is between 1 and 100 messages. No more, no less. Limit provided: " + amount);
        }
        Route.CompiledRoute route = this.history.isEmpty() ? Route.Messages.GET_MESSAGE_HISTORY.compile(this.channel.getId(), Integer.toString(amount)) : Route.Messages.GET_MESSAGE_HISTORY_BEFORE.compile(this.channel.getId(), Integer.toString(amount), this.history.lastKey());
        return new RestAction<List<Message>>((JDA)this.api, route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                }
                EntityBuilder builder = EntityBuilder.get(this.api);
                LinkedList<Message> msgs = new LinkedList<Message>();
                JSONArray historyJson = response.getArray();
                for (int i = 0; i < historyJson.length(); ++i) {
                    msgs.add(builder.createMessage(historyJson.getJSONObject(i)));
                }
                if (MessageHistory.this.history.isEmpty()) {
                    msgs.forEach(msg -> MessageHistory.this.history.put(msg.getId(), (Message)msg));
                }
                request.onSuccess(msgs);
            }
        };
    }

    public RestAction<List<Message>> retrieveFuture(int amount) {
        if (amount > 100 || amount < 0) {
            throw new IllegalArgumentException("Message retrieval limit is between 1 and 100 messages. No more, no less. Limit provided: " + amount);
        }
        if (this.history.isEmpty()) {
            throw new IllegalStateException("No messageId  is stored to use as the marker between the future and past.Either use MessageHistory(MessageChannel, String) or make a call to retrievePast(int) first.");
        }
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE_HISTORY_AFTER.compile(this.channel.getId(), Integer.toString(amount), this.history.firstKey());
        return new RestAction<List<Message>>((JDA)this.api, route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                }
                EntityBuilder builder = EntityBuilder.get(this.api);
                LinkedList<Message> msgs = new LinkedList<Message>();
                JSONArray historyJson = response.getArray();
                for (int i = 0; i < historyJson.length(); ++i) {
                    msgs.add(builder.createMessage(historyJson.getJSONObject(i)));
                }
                Iterator it = msgs.descendingIterator();
                while (it.hasNext()) {
                    Message m = (Message)it.next();
                    MessageHistory.this.history.put(0, m.getId(), m);
                }
                request.onSuccess(msgs);
            }
        };
    }

    public List<Message> getCachedHistory() {
        return Collections.unmodifiableList(new ArrayList<Message>(this.history.values()));
    }

    public Message getMessageById(String id) {
        return (Message)this.history.get(id);
    }

    public Message informUpdate(Message msg) {
        if (msg.getChannel().equals(this.channel) && this.history.containsKey(msg.getId())) {
            return this.history.put(msg.getId(), msg);
        }
        return null;
    }

    public Message informDeletion(Message msg) {
        if (msg.getChannel().equals(this.channel)) {
            return this.informDeletion(msg.getId());
        }
        return null;
    }

    public Message informDeletion(String id) {
        if (id == null) {
            throw new NullPointerException("Provided message id was null!");
        }
        return this.history.remove(id);
    }

    @Override
    public void onEvent(Event event) {
        MessageDeleteEvent mEvent;
        if (event instanceof MessageUpdateEvent) {
            this.informUpdate(((MessageUpdateEvent)event).getMessage());
        } else if (event instanceof MessageDeleteEvent && (mEvent = (MessageDeleteEvent)event).getChannel().equals(this.channel)) {
            this.history.remove(mEvent.getMessageId());
        }
    }

    public static RestAction<MessageHistory> getHistoryAround(MessageChannel channel, Message message, int limit) {
        if (!message.getChannel().equals(channel)) {
            throw new IllegalArgumentException("The provided Message is not from the MessageChannel!");
        }
        return MessageHistory.getHistoryAround(channel, message.getId(), limit);
    }

    public static RestAction<MessageHistory> getHistoryAround(final MessageChannel channel, final String markerMessageId, int limit) {
        if (markerMessageId == null) {
            throw new IllegalArgumentException("Provided markedMessageId cannot be null!");
        }
        if (limit > 100 || limit < 1) {
            throw new IllegalArgumentException("Provided limit was out of bounds. Minimum: 1, Max: 100. Provided: " + limit);
        }
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE_HISTORY_AROUND.compile(channel.getId(), Integer.toString(limit), markerMessageId);
        return new RestAction<MessageHistory>(channel.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                }
                MessageHistory mHistory = new MessageHistory(channel);
                mHistory.markerId = markerMessageId;
                EntityBuilder builder = EntityBuilder.get(this.api);
                LinkedList<Message> msgs = new LinkedList<Message>();
                JSONArray historyJson = response.getArray();
                for (int i = 0; i < historyJson.length(); ++i) {
                    msgs.add(builder.createMessage(historyJson.getJSONObject(i)));
                }
                msgs.forEach(msg -> mHistory.history.put(msg.getId(), (Message)msg));
                request.onSuccess(mHistory);
            }
        };
    }
}

