/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingFormatArgumentException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Message;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.MessageImpl;

public class MessageBuilder {
    public static final String USER_KEY = "%U%";
    public static final String ROLE_KEY = "%R%";
    public static final String TEXTCHANNEL_KEY = "%TC%";
    public static final String EVERYONE_KEY = "%E%";
    public static final String HERE_KEY = "%H%";
    protected final StringBuilder builder = new StringBuilder();
    protected final List<User> mentioned = new LinkedList<User>();
    protected final List<TextChannel> mentionedTextChannels = new LinkedList<TextChannel>();
    protected final List<Role> mentionedRoles = new LinkedList<Role>();
    protected boolean mentionEveryone = false;
    protected boolean isTTS = false;
    protected Pattern formatPattern = Pattern.compile(String.format("%s|%s|%s|%s|%s", "%U%", "%R%", "%TC%", "%E%", "%H%"));

    public MessageBuilder setTTS(boolean tts) {
        this.isTTS = tts;
        return this;
    }

    public MessageBuilder appendString(String text) {
        this.builder.append(text);
        return this;
    }

    public MessageBuilder appendString(String text, Formatting ... format) {
        boolean blockPresent = false;
        for (Formatting formatting : format) {
            if (formatting == Formatting.BLOCK) {
                blockPresent = true;
                continue;
            }
            this.builder.append(formatting.getTag());
        }
        if (blockPresent) {
            this.builder.append(Formatting.BLOCK.getTag());
        }
        this.builder.append(text);
        if (blockPresent) {
            this.builder.append(Formatting.BLOCK.getTag());
        }
        for (int i = format.length - 1; i >= 0; --i) {
            if (format[i] == Formatting.BLOCK) continue;
            this.builder.append(format[i].getTag());
        }
        return this;
    }

    public MessageBuilder appendFormat(String format, Object ... args) {
        if (format == null || format.isEmpty()) {
            return this;
        }
        int index = 0;
        int stringIndex = 0;
        StringBuilder sb = new StringBuilder();
        Matcher m = this.formatPattern.matcher(format);
        List<Class> classes = Arrays.asList(User.class, TextChannel.class, Role.class);
        while (m.find() && stringIndex < format.length()) {
            Class target = null;
            boolean everyone = false;
            switch (m.group()) {
                case "%U%": {
                    target = User.class;
                    break;
                }
                case "%TC%": {
                    target = TextChannel.class;
                    break;
                }
                case "%R%": {
                    target = Role.class;
                    break;
                }
                case "%E%": {
                    everyone = true;
                    break;
                }
                case "%H%": {
                    everyone = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("MessageBuilder's format regex triggered on an unknown key. How?!");
                }
            }
            sb.append(format.substring(stringIndex, m.start())).append("%s");
            stringIndex = m.end();
            if (target != null) {
                boolean found = false;
                for (int i = index; i < args.length; ++i) {
                    Object arg = args[i];
                    if (classes.stream().anyMatch(c -> c.isInstance(arg))) {
                        if (!target.isInstance(arg)) {
                            throw new IllegalArgumentException(String.format("Expected: %s at args index: %d but received: %s instead", target.getSimpleName(), index, arg.getClass().getSimpleName()));
                        }
                        if (arg instanceof User) {
                            User u = (User)arg;
                            args[i] = u.getAsMention();
                            this.mentioned.add(u);
                        } else if (arg instanceof TextChannel) {
                            TextChannel tc = (TextChannel)arg;
                            args[i] = tc.getAsMention();
                            this.mentionedTextChannels.add(tc);
                        } else if (arg instanceof Role) {
                            Role r = (Role)arg;
                            args[i] = r.getAsMention();
                            this.mentionedRoles.add(r);
                        } else {
                            throw new IllegalArgumentException("When checking instances of arguments, something failed. Contact dev.");
                        }
                        ++index;
                        found = true;
                        break;
                    }
                    ++index;
                }
                if (found) continue;
                throw new MissingFormatArgumentException(m.group());
            }
            if (everyone) {
                sb.append("@everyone");
                this.mentionEveryone = true;
                continue;
            }
            sb.append("@here");
            this.mentionEveryone = true;
        }
        if (stringIndex < format.length()) {
            sb.append(format.substring(stringIndex, format.length()));
        }
        String finalFormat = String.format(sb.toString(), args);
        this.builder.append(finalFormat);
        return this;
    }

    public MessageBuilder appendCodeBlock(String text, String language) {
        this.builder.append("```").append(language).append('\n').append(text).append("\n```");
        return this;
    }

    public MessageBuilder appendMention(User user) {
        this.builder.append("<@").append(user.getId()).append('>');
        this.mentioned.add(user);
        return this;
    }

    public MessageBuilder appendEveryoneMention() {
        this.builder.append("@everyone");
        this.mentionEveryone = true;
        return this;
    }

    public MessageBuilder appendHereMention() {
        this.builder.append("@here");
        this.mentionEveryone = true;
        return this;
    }

    public MessageBuilder appendMention(TextChannel channel) {
        this.builder.append("<#").append(channel.getId()).append('>');
        this.mentionedTextChannels.add(channel);
        return this;
    }

    public MessageBuilder appendMention(Role role) {
        this.builder.append("<@&").append(role.getId()).append('>');
        this.mentionedRoles.add(role);
        return this;
    }

    public int getLength() {
        return this.builder.length();
    }

    public Message build() {
        String message = this.builder.toString();
        if (message.isEmpty()) {
            throw new UnsupportedOperationException("Cannot build a Message with no content. (You never added any content to the message)");
        }
        if (message.length() > 2000) {
            throw new UnsupportedOperationException("Cannot build a Message with more than 2000 characters. Please limit your input.");
        }
        return new MessageImpl("", null, false).setContent(message).setTTS(this.isTTS).setMentionedUsers(this.mentioned).setMentionedChannels(this.mentionedTextChannels).setMentionedRoles(this.mentionedRoles).setMentionsEveryone(this.mentionEveryone);
    }

    public static enum Formatting {
        ITALICS("*"),
        BOLD("**"),
        STRIKETHROUGH("~~"),
        UNDERLINE("__"),
        BLOCK("`");

        private final String tag;

        private Formatting(String tag) {
            this.tag = tag;
        }

        private String getTag() {
            return this.tag;
        }
    }
}

