/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.login.LoginException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.AccountType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.OnlineStatus;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Game;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.hooks.IEventManager;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.impl.PresenceImpl;
import net.shadowfacts.discordchat.repack.org.apache.http.HttpHost;

public class JDABuilder {
    protected static boolean jdaCreated = false;
    protected static HttpHost proxy = null;
    protected final List<Object> listeners;
    protected AccountType accountType;
    protected String token = null;
    protected boolean enableVoice = true;
    protected boolean enableShutdownHook = true;
    protected boolean enableBulkDeleteSplitting = true;
    protected boolean autoReconnect = true;
    protected boolean idle = false;
    protected IEventManager eventManager = null;
    protected JDA.ShardInfo shardInfo = null;
    protected Game game = null;
    protected OnlineStatus status = OnlineStatus.ONLINE;

    public JDABuilder(AccountType accountType) {
        if (accountType == null) {
            throw new NullPointerException("Provided AccountType was null!");
        }
        this.accountType = accountType;
        this.listeners = new LinkedList<Object>();
    }

    public JDABuilder setToken(String token) {
        this.token = token;
        return this;
    }

    public JDABuilder setProxy(HttpHost proxy) {
        if (jdaCreated) {
            throw new UnsupportedOperationException("You cannot change the proxy after a JDA object has been created. Proxy settings are global among all instances!");
        }
        JDABuilder.proxy = proxy;
        return this;
    }

    public JDABuilder setAudioEnabled(boolean enabled) {
        this.enableVoice = enabled;
        return this;
    }

    public JDABuilder setBulkDeleteSplittingEnabled(boolean enabled) {
        this.enableBulkDeleteSplitting = enabled;
        return this;
    }

    public JDABuilder setEnableShutdownHook(boolean enable) {
        this.enableShutdownHook = enable;
        return this;
    }

    public JDABuilder setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    public JDABuilder setEventManager(IEventManager manager) {
        this.eventManager = manager;
        return this;
    }

    public JDABuilder setIdle(boolean idle) {
        this.idle = idle;
        return this;
    }

    public JDABuilder setGame(Game game) {
        this.game = game;
        return this;
    }

    public JDABuilder setStatus(OnlineStatus status) {
        if (status == null || status == OnlineStatus.UNKNOWN) {
            throw new IllegalArgumentException("OnlineStatus cannot be null or unknown!");
        }
        this.status = status;
        return this;
    }

    public JDABuilder addListener(Object ... listeners) {
        Collections.addAll(this.listeners, listeners);
        return this;
    }

    public JDABuilder removeListener(Object ... listeners) {
        this.listeners.removeAll(Arrays.asList(listeners));
        return this;
    }

    public JDABuilder useSharding(int shardId, int numShards) {
        if (shardId < 0 || numShards < 2 || shardId >= numShards) {
            throw new RuntimeException("This configuration of shardId and numShards is not allowed! 0 <= shardId < numShards with numShards > 1");
        }
        this.shardInfo = new JDA.ShardInfo(shardId, numShards);
        return this;
    }

    public JDA buildAsync() throws LoginException, IllegalArgumentException, RateLimitedException {
        jdaCreated = true;
        JDAImpl jda = new JDAImpl(this.accountType, proxy, this.autoReconnect, this.enableVoice, this.enableShutdownHook, this.enableBulkDeleteSplitting);
        if (this.eventManager != null) {
            jda.setEventManager(this.eventManager);
        }
        this.listeners.forEach(xva$0 -> jda.addEventListener(xva$0));
        jda.setStatus(JDA.Status.INITIALIZED);
        ((PresenceImpl)jda.getPresence()).setCacheGame(this.game).setCacheIdle(this.idle).setCacheStatus(this.status);
        jda.login(this.token, this.shardInfo);
        return jda;
    }

    public JDA buildBlocking() throws LoginException, IllegalArgumentException, InterruptedException, RateLimitedException {
        JDA jda = this.buildAsync();
        while (jda.getStatus() != JDA.Status.CONNECTED) {
            Thread.sleep(50L);
        }
        return jda;
    }
}

