/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.handle;

import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Relationship;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.events.relationship.FriendAddedEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.events.relationship.FriendRequestReceivedEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.events.relationship.FriendRequestSentEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.events.relationship.UserBlockedEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.EventCache;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.SocketHandler;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.WebSocketClient;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class RelationshipAddHandler
extends SocketHandler {
    public RelationshipAddHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        Relationship relationship = EntityBuilder.get(this.api).createRelationship(content);
        if (relationship == null) {
            WebSocketClient.LOG.warn("Received a RELATIONSHIP_ADD with an unknown type! JSON: " + content);
            return null;
        }
        switch (relationship.getType()) {
            case FRIEND: {
                this.api.getEventManager().handle(new FriendAddedEvent(this.api, this.responseNumber, relationship));
                break;
            }
            case BLOCKED: {
                this.api.getEventManager().handle(new UserBlockedEvent(this.api, this.responseNumber, relationship));
                break;
            }
            case INCOMING_FRIEND_REQUEST: {
                this.api.getEventManager().handle(new FriendRequestReceivedEvent(this.api, this.responseNumber, relationship));
                break;
            }
            case OUTGOING_FRIEND_REQUEST: {
                this.api.getEventManager().handle(new FriendRequestSentEvent(this.api, this.responseNumber, relationship));
                break;
            }
            default: {
                WebSocketClient.LOG.warn("Received a RELATIONSHIP_ADD with an unknown type! JSON: " + content);
                return null;
            }
        }
        EventCache.get(this.api).playbackCache(EventCache.Type.RELATIONSHIP, relationship.getUser().getId());
        EventCache.get(this.api).playbackCache(EventCache.Type.USER, relationship.getUser().getId());
        return null;
    }
}

