/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.handle;

import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl.CallImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl.CallUserImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.events.group.GroupUserJoinEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.EventCache;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.SocketHandler;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class ChannelRecipientAddHandler
extends SocketHandler {
    public ChannelRecipientAddHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String groupId = content.getString("channel_id");
        JSONObject userJson = content.getJSONObject("user");
        GroupImpl group = (GroupImpl)this.api.asClient().getGroupById(groupId);
        if (group == null) {
            EventCache.get(this.api).cache(EventCache.Type.CHANNEL, groupId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a CHANNEL_RECIPIENT_ADD for a group that is not yet cached! JSON: " + content);
            return null;
        }
        User user = EntityBuilder.get(this.api).createFakeUser(userJson, true);
        group.getUserMap().put(user.getId(), user);
        CallImpl call = (CallImpl)group.getCurrentCall();
        if (call != null) {
            call.getCallUserMap().put(user.getId(), new CallUserImpl(call, user));
        }
        this.api.getEventManager().handle(new GroupUserJoinEvent(this.api, this.responseNumber, group, user));
        EventCache.get(this.api).playbackCache(EventCache.Type.USER, user.getId());
        return null;
    }
}

