/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.handle;

import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.CallableChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Group;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl.CallImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.events.call.CallDeleteEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.EventCache;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.handle.SocketHandler;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class CallDeleteHandler
extends SocketHandler {
    public CallDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String channelId = content.getString("channel_id");
        CallableChannel channel = this.api.asClient().getGroupById(channelId);
        if (channel == null) {
            channel = this.api.getPrivateChannelMap().get(channelId);
        }
        if (channel == null) {
            EventCache.get(this.api).cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received CALL_DELETE for a Group/PrivateChannel that is not yet cached. JSON: " + content);
            return null;
        }
        CallImpl call = (CallImpl)channel.getCurrentCall();
        if (call == null) {
            EventCache.get(this.api).cache(EventCache.Type.CALL, channelId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a CALL_DELETE for a Call that is not yet cached. JSON: " + content);
            return null;
        }
        if (channel instanceof Group) {
            GroupImpl group = (GroupImpl)channel;
            group.setCurrentCall(null);
            call.getCallUserMap().forEach((userId, cUser) -> ((JDAClientImpl)this.api.asClient()).getCallUserMap().remove(userId));
        } else {
            PrivateChannelImpl priv = (PrivateChannelImpl)channel;
            priv.setCurrentCall(null);
            ((JDAClientImpl)this.api.asClient()).getCallUserMap().remove(priv.getUser().getId());
            ((JDAClientImpl)this.api.asClient()).getCallUserMap().remove(this.api.getSelfUser().getId());
        }
        this.api.getEventManager().handle(new CallDeleteEvent(this.api, this.responseNumber, call));
        return null;
    }
}

