/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.shadowfacts.discordchat.repack.com.mashape.unirest.http.Unirest;
import net.shadowfacts.discordchat.repack.com.mashape.unirest.request.body.MultipartBody;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Call;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Friend;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Group;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.MessageBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.MessageHistory;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.ChannelType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Message;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.IOUtil;
import net.shadowfacts.discordchat.repack.org.json.JSONArray;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class GroupImpl
implements Group {
    private final String id;
    private final JDAImpl api;
    private HashMap<String, User> userMap = new HashMap();
    private Call currentCall;
    private User owner;
    private String name;
    private String iconId;

    public GroupImpl(String id, JDAImpl api) {
        this.id = id;
        this.api = api;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChannelType getType() {
        return ChannelType.GROUP;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public String getIconUrl() {
        return this.iconId == null ? null : "https://cdn.discordapp.com/channel-icons/" + this.id + "/" + this.iconId + ".jpg";
    }

    @Override
    public User getOwner() {
        return this.owner;
    }

    @Override
    public List<User> getUsers() {
        return Collections.unmodifiableList(new ArrayList<User>(this.userMap.values()));
    }

    @Override
    public List<User> getNonFriendUsers() {
        ArrayList nonFriends = new ArrayList();
        this.userMap.forEach((userId, user) -> {
            Friend friend = this.api.asClient().getFriendById((String)userId);
            if (friend == null) {
                nonFriends.add(user);
            }
        });
        return Collections.unmodifiableList(nonFriends);
    }

    @Override
    public List<Friend> getFriends() {
        ArrayList<Friend> friends = new ArrayList<Friend>();
        for (String userId : this.userMap.keySet()) {
            Friend friend = this.api.asClient().getFriendById(userId);
            if (friend == null) continue;
            friends.add(friend);
        }
        return Collections.unmodifiableList(friends);
    }

    @Override
    public RestAction<Call> startCall() {
        return null;
    }

    @Override
    public Call getCurrentCall() {
        return this.currentCall;
    }

    @Override
    public RestAction leaveGroup() {
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public RestAction<Message> sendMessage(String text) {
        return this.sendMessage(new MessageBuilder().appendString(text).build());
    }

    @Override
    public RestAction<Message> sendMessage(Message msg) {
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        JSONObject json = new JSONObject().put("content", msg.getRawContent()).put("tts", msg.isTTS());
        return new RestAction<Message>(this.getJDA(), route, (Object)json){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    Message m = EntityBuilder.get(GroupImpl.this.getJDA()).createMessage(response.getObject());
                    request.onSuccess(m);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Message> sendFile(File file, Message message) throws IOException {
        this.checkNull(file, "file");
        return this.sendFile(file, file.getName(), message);
    }

    @Override
    public RestAction<Message> sendFile(File file, String fileName, Message message) throws IOException {
        this.checkNull(file, "file");
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Provided file is either null, doesn't exist or is not readable!");
        }
        if (file.length() > 0x800000L) {
            throw new IllegalArgumentException("File is to big! Max file-size is 8MB");
        }
        return this.sendFile(IOUtil.readFully(file), fileName, message);
    }

    @Override
    public RestAction<Message> sendFile(InputStream data, String fileName, Message message) {
        this.checkNull(data, "data InputStream");
        this.checkNull(fileName, "fileName");
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.id);
        MultipartBody body = Unirest.post("https://discordapp.com/api/" + route.getCompiledRoute()).fields(null);
        body.field("file", data, fileName);
        if (message != null) {
            body.field("content", message.getRawContent());
            body.field("tts", message.isTTS());
        }
        return new RestAction<Message>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(EntityBuilder.get(this.api).createMessage(response.getObject()));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Message> sendFile(byte[] data, String fileName, Message message) {
        this.checkNull(fileName, "fileName");
        if (data.length > 0x800000) {
            throw new IllegalArgumentException("Provided data is too large! Max file-size is 8MB");
        }
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.id);
        MultipartBody body = Unirest.post("https://discordapp.com/api/" + route.getCompiledRoute()).fields(null);
        body.field("file", data, fileName);
        if (message != null) {
            body.field("content", message.getRawContent());
            body.field("tts", message.isTTS());
        }
        return new RestAction<Message>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(EntityBuilder.get(this.api).createMessage(response.getObject()));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Message> getMessageById(String messageId) {
        this.checkNull(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Message>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    Message m = EntityBuilder.get(GroupImpl.this.getJDA()).createMessage(response.getObject());
                    request.onSuccess(m);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> deleteMessageById(String messageId) {
        this.checkNull(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public MessageHistory getHistory() {
        return new MessageHistory(this);
    }

    @Override
    public RestAction<MessageHistory> getHistoryAround(Message markerMessage, int limit) {
        return MessageHistory.getHistoryAround((MessageChannel)this, markerMessage, limit);
    }

    @Override
    public RestAction<MessageHistory> getHistoryAround(String markedMessageId, int limit) {
        return MessageHistory.getHistoryAround((MessageChannel)this, markedMessageId, limit);
    }

    @Override
    public RestAction<Void> sendTyping() {
        Route.CompiledRoute route = Route.Channels.SEND_TYPING.compile(this.id);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> pinMessageById(String messageId) {
        this.checkNull(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.ADD_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> unpinMessageById(String messageId) {
        this.checkNull(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.REMOVE_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<List<Message>> getPinnedMessages() {
        Route.CompiledRoute route = Route.Messages.GET_PINNED_MESSAGES.compile(this.getId());
        return new RestAction<List<Message>>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    LinkedList<Message> pinnedMessages = new LinkedList<Message>();
                    EntityBuilder builder = EntityBuilder.get(GroupImpl.this.getJDA());
                    JSONArray pins = response.getArray();
                    for (int i = 0; i < pins.length(); ++i) {
                        pinnedMessages.add(builder.createMessage(pins.getJSONObject(i)));
                    }
                    request.onSuccess(Collections.unmodifiableList(pinnedMessages));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public String toString() {
        return String.format("G:%s(%s)", this.getName(), this.getId());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Group)) {
            return false;
        }
        Group oGroup = (Group)o;
        return this.id.equals(oGroup.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public HashMap<String, User> getUserMap() {
        return this.userMap;
    }

    public GroupImpl setCurrentCall(Call call) {
        this.currentCall = call;
        return this;
    }

    public GroupImpl setOwner(User owner) {
        this.owner = owner;
        return this;
    }

    public GroupImpl setName(String name) {
        this.name = name;
        return this;
    }

    public GroupImpl setIconId(String iconId) {
        this.iconId = iconId;
        return this;
    }

    private void checkNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Provided " + name + " was null!");
        }
    }
}

