/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.com.sun.jna.win32;

import java.lang.reflect.Method;
import net.shadowfacts.discordchat.repack.com.sun.jna.FunctionMapper;
import net.shadowfacts.discordchat.repack.com.sun.jna.Native;
import net.shadowfacts.discordchat.repack.com.sun.jna.NativeLibrary;
import net.shadowfacts.discordchat.repack.com.sun.jna.NativeMapped;
import net.shadowfacts.discordchat.repack.com.sun.jna.NativeMappedConverter;
import net.shadowfacts.discordchat.repack.com.sun.jna.Pointer;

public class StdCallFunctionMapper
implements FunctionMapper {
    protected int getArgumentNativeStackSize(Class cls) {
        if (NativeMapped.class.isAssignableFrom(cls)) {
            cls = NativeMappedConverter.getInstance(cls).nativeType();
        }
        if (cls.isArray()) {
            return Pointer.SIZE;
        }
        try {
            return Native.getNativeSize(cls);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown native stack allocation size for " + cls);
        }
    }

    @Override
    public String getFunctionName(NativeLibrary library, Method method) {
        String name = method.getName();
        int pop = 0;
        Class<?>[] argTypes = method.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            pop += this.getArgumentNativeStackSize(argTypes[i]);
        }
        String decorated = name + "@" + pop;
        int conv = 63;
        try {
            name = library.getFunction(decorated, conv).getName();
        }
        catch (UnsatisfiedLinkError e) {
            try {
                name = library.getFunction("_" + decorated, conv).getName();
            }
            catch (UnsatisfiedLinkError e2) {
                // empty catch block
            }
        }
        return name;
    }
}

