/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core.command.impl.permissions;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.ILogger;
import net.shadowfacts.discordchat.api.command.ICommand;
import net.shadowfacts.discordchat.api.command.exception.CommandException;
import net.shadowfacts.discordchat.api.permission.IPermissionManager;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.core.command.exception.InvalidUsageException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;

public class CommandSetPermission
implements ICommand {
    private IDiscordChat discordChat;
    private ILogger logger;
    private IConfig config;
    private IPermissionManager permissionManager;

    public CommandSetPermission(IDiscordChat discordChat) {
        this.discordChat = discordChat;
        this.logger = discordChat.getLogger();
        this.config = discordChat.getConfig();
        this.permissionManager = discordChat.getPermissionManager();
    }

    @Override
    public String getName() {
        return "setPermission";
    }

    @Override
    public Permission getMinimumPermission() {
        return this.config.getMinimumPermission(this.getName());
    }

    @Override
    public void execute(String[] args, User sender, TextChannel channel) throws CommandException {
        if (args.length < 2) {
            throw new InvalidUsageException(this);
        }
        Permission permission = Permission.valueOf(args[args.length - 1].toUpperCase());
        String role = String.join((CharSequence)" ", Arrays.copyOfRange(args, 0, args.length - 1));
        List<Role> roles = channel.getGuild().getRolesByName(role, true);
        if (roles.isEmpty()) {
            this.discordChat.sendMessage("No such role: " + role, channel);
            return;
        }
        this.permissionManager.set(roles.get(0), permission);
        try {
            this.permissionManager.save();
            this.discordChat.sendMessage("Permissions updated");
        }
        catch (IOException e) {
            this.logger.error(e, "Unable to save permissions", new Object[0]);
        }
    }

    @Override
    public String getDescription() {
        return "Sets the permission of the given user";
    }

    @Override
    public String getUsage() {
        return "<role> <permission>";
    }
}

