/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core.command.impl.permissions;

import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.command.ICommand;
import net.shadowfacts.discordchat.api.command.exception.CommandException;
import net.shadowfacts.discordchat.api.permission.IPermissionManager;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;

public class CommandPermission
implements ICommand {
    private IDiscordChat discordChat;
    private IConfig config;
    private IPermissionManager permissionManager;

    public CommandPermission(IDiscordChat discordChat) {
        this.discordChat = discordChat;
        this.config = discordChat.getConfig();
        this.permissionManager = discordChat.getPermissionManager();
    }

    @Override
    public String getName() {
        return "permission";
    }

    @Override
    public Permission getMinimumPermission() {
        return this.config.getMinimumPermission(this.getName());
    }

    @Override
    public void execute(String[] args, User sender, TextChannel channel) throws CommandException {
        this.discordChat.sendMessage("Permission level for " + sender.getName() + ": " + (Object)((Object)this.permissionManager.get(sender, channel.getGuild())), channel);
    }

    @Override
    public String getDescription() {
        return "Retrieves the caller's permission";
    }

    @Override
    public String getUsage() {
        return "";
    }
}

