/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core.command.impl.meta;

import java.util.List;
import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.command.ICommand;
import net.shadowfacts.discordchat.api.command.exception.CommandException;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;

public class CommandRoleID
implements ICommand {
    private IDiscordChat discordChat;
    private IConfig config;

    public CommandRoleID(IDiscordChat discordChat) {
        this.discordChat = discordChat;
        this.config = discordChat.getConfig();
    }

    @Override
    public String getName() {
        return "roleid";
    }

    @Override
    public Permission getMinimumPermission() {
        return this.config.getMinimumPermission(this.getName());
    }

    @Override
    public void execute(String[] args, User sender, TextChannel channel) throws CommandException {
        String role = String.join((CharSequence)" ", args);
        List<Role> roles = channel.getGuild().getRolesByName(role, true);
        if (roles.isEmpty()) {
            this.discordChat.sendMessage("No such role: " + role);
        } else {
            this.discordChat.sendMessage("ID for role '" + roles.get(0).getName() + "' is " + roles.get(0).getId(), channel);
        }
    }

    @Override
    public String getDescription() {
        return "Retrieves the ID for the role with the given name";
    }

    @Override
    public String getUsage() {
        return "<role>";
    }
}

