/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core.command.impl.meta;

import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.command.ICommand;
import net.shadowfacts.discordchat.api.command.ICommandManager;
import net.shadowfacts.discordchat.api.command.exception.CommandException;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.core.command.exception.InvalidUsageException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;

public class CommandHelp
implements ICommand {
    private IDiscordChat discordChat;
    private IConfig config;
    private ICommandManager commandManager;

    public CommandHelp(IDiscordChat discordChat) {
        this.discordChat = discordChat;
        this.config = discordChat.getConfig();
        this.commandManager = discordChat.getCommandManager();
    }

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public Permission getMinimumPermission() {
        return this.config.getMinimumPermission(this.getName());
    }

    @Override
    public void execute(String[] args, User author, TextChannel channel) throws CommandException {
        if (args.length < 1) {
            throw new InvalidUsageException(this);
        }
        if (!this.commandManager.exists(args[0])) {
            throw new CommandException("No such command: " + args[0]);
        }
        this.commandManager.get(args[0]).handleHelp(author, channel).forEach(msg -> this.discordChat.sendMessage((String)msg, channel));
    }

    @Override
    public String getDescription() {
        return "Retrieves help for the given command.";
    }

    @Override
    public String getUsage() {
        return "<command>";
    }
}

