/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.command.ICommand;
import net.shadowfacts.discordchat.api.command.ICommandManager;
import net.shadowfacts.discordchat.api.command.exception.CommandException;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.discordchat.core.command.exception.InvalidPermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;

public class CommandManager
implements ICommandManager {
    private IDiscordChat discordChat;
    private Map<String, ICommand> commands = new HashMap<String, ICommand>();

    public CommandManager(IDiscordChat discordChat) {
        this.discordChat = discordChat;
    }

    @Override
    public IDiscordChat getDiscordChat() {
        return this.discordChat;
    }

    @Override
    public void register(ICommand command) {
        this.commands.put(command.getName().toLowerCase(), command);
    }

    @Override
    public boolean exists(String name) {
        return this.commands.containsKey(name.toLowerCase());
    }

    @Override
    public ICommand get(String name) {
        return this.commands.get(name.toLowerCase());
    }

    @Override
    public void execute(String message, User sender, TextChannel channel) {
        String[] bits = message.split(" ");
        try {
            if (!this.exists(bits[0])) {
                throw new CommandException("Unknown command: " + bits[0]);
            }
            ICommand command = this.get(bits[0]);
            this.checkPermission(command, sender, channel.getGuild());
            command.execute(Arrays.copyOfRange(bits, 1, bits.length), sender, channel);
        }
        catch (CommandException e) {
            channel.sendMessage("Error executing command: " + e.getLocalizedMessage());
        }
    }

    @Override
    public Collection<ICommand> getCommands() {
        return this.commands.values();
    }

    private void checkPermission(ICommand command, User user, Guild guild) throws InvalidPermissionException {
        Permission min = command.getMinimumPermission();
        Permission actual = this.discordChat.getPermissionManager().get(user, guild);
        if (!actual.has(min)) {
            throw new InvalidPermissionException(min, actual, command.getName() + " command");
        }
    }
}

