/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core;

import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.IMessageFormatter;

public class MessageFormatter
implements IMessageFormatter {
    private IConfig config;

    public MessageFormatter(IDiscordChat discordChat) {
        this.config = discordChat.getConfig();
    }

    @Override
    public String fromMC(String sender, String message) {
        return this.config.getFromMCFormat().replace("$1", sender).replace("$2", message);
    }

    @Override
    public String fromDiscord(String channel, String sender, String message) {
        return this.config.getFromDiscordFormat().replace("$1", channel).replace("$2", sender).replace("$3", message);
    }

    @Override
    public String death(String player, String message) {
        return this.config.getDeathFormat().replace("$1", player).replace("$2", message);
    }

    @Override
    public String achievement(String player, String achievement) {
        return this.config.getAchievementFormat().replace("$1", player).replace("$2", achievement);
    }

    @Override
    public String join(String player) {
        return this.config.getJoinFormat().replace("$1", player);
    }

    @Override
    public String leave(String player) {
        return this.config.getLeaveFormat().replace("$1", player);
    }
}

