/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import javax.security.auth.login.LoginException;
import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.IDiscordChat;
import net.shadowfacts.discordchat.api.ILogger;
import net.shadowfacts.discordchat.api.IMessageFormatter;
import net.shadowfacts.discordchat.api.IMinecraftAdapter;
import net.shadowfacts.discordchat.api.command.ICommandManager;
import net.shadowfacts.discordchat.api.permission.IPermissionManager;
import net.shadowfacts.discordchat.core.Config;
import net.shadowfacts.discordchat.core.Listener;
import net.shadowfacts.discordchat.core.Logger;
import net.shadowfacts.discordchat.core.MessageFormatter;
import net.shadowfacts.discordchat.core.command.CommandManager;
import net.shadowfacts.discordchat.core.command.impl.meta.CommandCommands;
import net.shadowfacts.discordchat.core.command.impl.meta.CommandHelp;
import net.shadowfacts.discordchat.core.command.impl.meta.CommandReload;
import net.shadowfacts.discordchat.core.command.impl.meta.CommandRoleID;
import net.shadowfacts.discordchat.core.command.impl.minecraft.CommandExecute;
import net.shadowfacts.discordchat.core.command.impl.minecraft.CommandOnline;
import net.shadowfacts.discordchat.core.command.impl.minecraft.CommandTPS;
import net.shadowfacts.discordchat.core.command.impl.minecraft.CommandUnstick;
import net.shadowfacts.discordchat.core.command.impl.permissions.CommandPermission;
import net.shadowfacts.discordchat.core.command.impl.permissions.CommandSetPermission;
import net.shadowfacts.discordchat.core.permission.PermissionManager;
import net.shadowfacts.discordchat.core.util.QueuedMessage;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.AccountType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDABuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Message;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.ErrorResponseException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;

public class DiscordChat
implements IDiscordChat {
    private IMinecraftAdapter minecraftAdapter;
    private Logger logger;
    private IConfig config;
    private PermissionManager permissionManager;
    private CommandManager commandManager;
    private MessageFormatter formatter;
    private boolean running = true;
    private JDA jda;
    private final LinkedBlockingQueue<QueuedMessage> sendQueue = new LinkedBlockingQueue();
    private TextChannel channel;

    public DiscordChat(File dcDir, IMinecraftAdapter minecraftAdapter) throws IOException {
        this.minecraftAdapter = minecraftAdapter;
        if (!dcDir.exists()) {
            dcDir.mkdirs();
        }
        this.logger = new Logger();
        this.config = new Config(new File(dcDir, "DiscordChat.conf"));
        this.permissionManager = new PermissionManager(this, new File(dcDir, "permissions.json"));
        this.commandManager = new CommandManager(this);
        this.formatter = new MessageFormatter(this);
        this.commandManager.register(new CommandHelp(this));
        this.commandManager.register(new CommandCommands(this));
        this.commandManager.register(new CommandRoleID(this));
        this.commandManager.register(new CommandReload(this));
        this.commandManager.register(new CommandOnline(this));
        this.commandManager.register(new CommandTPS(this));
        this.commandManager.register(new CommandExecute(this));
        this.commandManager.register(new CommandUnstick(this));
        this.commandManager.register(new CommandPermission(this));
        this.commandManager.register(new CommandSetPermission(this));
    }

    @Override
    public void connect() {
        new Thread(() -> {
            try {
                this.jda = new JDABuilder(AccountType.BOT).setToken(this.config.getToken()).addListener(new Listener(this)).buildBlocking();
            }
            catch (IllegalArgumentException | LoginException e) {
                throw new RuntimeException("Invalid Discord token. Please verify your token in the DiscordChat config file.", e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Guild guild = this.jda.getGuildById(this.config.getServerID());
            if (guild == null) {
                throw new RuntimeException("Invalid server ID");
            }
            List<TextChannel> channels = guild.getTextChannelsByName(this.config.getChannel(), true);
            if (channels.isEmpty()) {
                throw new RuntimeException("Invalid channel ID");
            }
        }, "DiscordChat-initializer").start();
    }

    @Override
    public void start() {
        if (this.running) {
            Thread thread = new Thread(this::sendQueueThread, "DiscordChat-send-queue");
            thread.setUncaughtExceptionHandler((thrd, t) -> this.logger.error(t, "Uncaught exception in DiscordChat-send-queue thread", new Object[0]));
            thread.start();
        }
    }

    private void sendQueueThread() {
        try {
            while (this.jda == null) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        QueuedMessage candidate = null;
        while (this.running) {
            try {
                if (candidate == null) {
                    candidate = this.sendQueue.take();
                }
                RestAction<Message> result = candidate.send();
                result.block();
                candidate = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (RateLimitedException e) {
                this.logger.debug("Message was rate limited, will try again in " + e.getRetryAfter(), new Object[0]);
                try {
                    Thread.sleep(e.getRetryAfter());
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            catch (ErrorResponseException e) {
                this.logger.error(e, "Error sending message to Discord: " + e.getErrorResponse().getCode() + " (" + e.getErrorResponse().getMeaning() + ")", new Object[0]);
            }
        }
    }

    @Override
    public void stop() {
        this.running = false;
        this.jda.shutdown();
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    public IConfig getConfig() {
        return this.config;
    }

    @Override
    public ICommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    public IPermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Override
    public IMessageFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public JDA getJDA() {
        return this.jda;
    }

    @Override
    public IMinecraftAdapter getMinecraftAdapter() {
        return this.minecraftAdapter;
    }

    @Override
    public void sendMessage(String message, MessageChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel cannot be null");
        }
        if (!this.running) {
            return;
        }
        if (message == null || message.isEmpty()) {
            return;
        }
        List users = this.jda.getGuildById(this.config.getServerID()).getMembers().stream().map(Member::getUser).collect(Collectors.toList());
        String temp = message.toLowerCase();
        for (User user : users) {
            if (!temp.contains("@" + user.getName().toLowerCase())) continue;
            message = message.replaceAll("(?i)@" + user.getName(), user.getAsMention());
        }
        this.sendQueue.add(new QueuedMessage(message, channel));
    }

    @Override
    public void sendMessage(String message) {
        if (this.channel == null) {
            while (this.jda == null) {
            }
            List<TextChannel> channels = this.jda.getTextChannelsByName(this.config.getChannel(), false);
            if (channels.size() < 1) {
                throw new RuntimeException("No such channel: " + this.config.getChannel());
            }
            this.channel = channels.get(0);
        }
        this.sendMessage(message, this.channel);
    }
}

