/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.core;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.shadowfacts.discordchat.api.IConfig;
import net.shadowfacts.discordchat.api.permission.Permission;
import net.shadowfacts.shadowlib.util.IOUtils;

public class Config
implements IConfig {
    private File file;
    private com.typesafe.config.Config config;

    public Config(File file) throws IOException {
        this.file = file;
        this.load();
    }

    @Override
    public void load() throws IOException {
        this.config = ConfigFactory.parseFile((File)this.file).withFallback((ConfigMergeable)ConfigFactory.load((String)"assets/discordchat/default.conf"));
        this.save();
    }

    @Override
    public void save() throws IOException {
        if (!this.file.exists()) {
            if (!this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            this.file.createNewFile();
        }
        ConfigObject toRender = this.config.root().withOnlyKey("discordchat");
        String s = toRender.render(ConfigRenderOptions.defaults().setOriginComments(false).setJson(false));
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes());
        FileOutputStream out = new FileOutputStream(this.file);
        IOUtils.copy(in, out);
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    @Override
    public String getToken() {
        return this.config.getString("discordchat.discord.token");
    }

    @Override
    public String getServerID() {
        return this.config.getString("discordchat.discord.server");
    }

    @Override
    public String getChannel() {
        return this.config.getString("discordchat.discord.channel");
    }

    @Override
    public String getCommandPrefix() {
        return this.config.getString("discordchat.commands.prefix");
    }

    @Override
    public Permission getMinimumPermission(String command) {
        return Permission.valueOf(this.config.getString("discordchat.commands.permission." + command).toUpperCase());
    }

    @Override
    public boolean sendDeathMessages() {
        return this.config.getBoolean("discordchat.relay.deaths");
    }

    @Override
    public boolean sendAchievementMessages() {
        return this.config.getBoolean("discordchat.relay.achievements");
    }

    @Override
    public boolean sendJoinLeaveMessages() {
        return this.config.getBoolean("discordchat.relay.joinleave");
    }

    @Override
    public String getFromMCFormat() {
        return this.config.getString("discordchat.format.fromMC");
    }

    @Override
    public String getFromDiscordFormat() {
        return this.config.getString("discordchat.format.fromDiscord");
    }

    @Override
    public String getDeathFormat() {
        return this.config.getString("discordchat.format.death");
    }

    @Override
    public String getAchievementFormat() {
        return this.config.getString("discordchat.format.achievement");
    }

    @Override
    public String getJoinFormat() {
        return this.config.getString("discordchat.format.join");
    }

    @Override
    public String getLeaveFormat() {
        return this.config.getString("discordchat.format.leave");
    }
}

