/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.world;

import com.google.common.base.Predicate;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.init.NetherBlocks;
import com.superdextor.adinferos.worldgen.WorldGenAbyssAcid;
import com.superdextor.adinferos.worldgen.WorldGenAcidLakes;
import com.superdextor.adinferos.worldgen.WorldGenAshTree;
import com.superdextor.adinferos.worldgen.WorldGenDarkFire;
import com.superdextor.adinferos.worldgen.WorldGenDimstone;
import com.superdextor.adinferos.worldgen.WorldGenObsidianPyramide;
import com.superdextor.adinferos.worldgen.WorldGenPhantomTree;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCavesHell;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.event.ForgeEventFactory;

public class ChunkProviderAbyss
implements IChunkGenerator {
    protected static final IBlockState air = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState darkstone = NetherBlocks.DARKSTONE.func_176223_P();
    protected static final IBlockState bedrock = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState darksand = NetherBlocks.DARK_SAND.func_176223_P();
    private final World world;
    private final Random rand;
    private final MapGenBase genCaves;
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] depthBuffer = new double[256];
    private double[] buffer;
    private NoiseGeneratorOctaves lperlinNoise1;
    private NoiseGeneratorOctaves lperlinNoise2;
    private NoiseGeneratorOctaves perlinNoise1;
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    private final WorldGenAbyssAcid acidTrapGen = new WorldGenAbyssAcid(true);
    private final WorldGenAbyssAcid abyssSpringGen = new WorldGenAbyssAcid(false);
    private final WorldGenAcidLakes acidLakesGen = new WorldGenAcidLakes();
    private final WorldGenDarkFire darkfireFeature = new WorldGenDarkFire();
    private final WorldGenDimstone dimGemGen = new WorldGenDimstone();
    private final WorldGenPhantomTree phantomTreeGen = new WorldGenPhantomTree(false);
    private final WorldGenAshTree ashTreeGen = new WorldGenAshTree(false);
    double[] pnr;
    double[] ar;
    double[] br;
    double[] noiseData4;
    double[] dr;

    public ChunkProviderAbyss(World worldIn, long seed) {
        this.world = worldIn;
        this.rand = new Random(seed);
        this.genCaves = new MapGenCavesHell();
        this.lperlinNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.lperlinNoise2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        worldIn.func_181544_b(63);
    }

    public void prepareHeights(int p_185936_1_, int p_185936_2_, ChunkPrimer primer) {
        int i = 4;
        int j = this.world.func_181545_F() / 2 + 1;
        int k = i + 1;
        int l = 17;
        int i1 = i + 1;
        this.buffer = this.getHeights(this.buffer, p_185936_1_ * i, 0, p_185936_2_ * i, k, l, i1);
        for (int j1 = 0; j1 < i; ++j1) {
            for (int k1 = 0; k1 < i; ++k1) {
                for (int l1 = 0; l1 < 16; ++l1) {
                    double d0 = 0.125;
                    double d1 = this.buffer[((j1 + 0) * i1 + k1 + 0) * l + l1 + 0];
                    double d2 = this.buffer[((j1 + 0) * i1 + k1 + 1) * l + l1 + 0];
                    double d3 = this.buffer[((j1 + 1) * i1 + k1 + 0) * l + l1 + 0];
                    double d4 = this.buffer[((j1 + 1) * i1 + k1 + 1) * l + l1 + 0];
                    double d5 = (this.buffer[((j1 + 0) * i1 + k1 + 0) * l + l1 + 1] - d1) * d0;
                    double d6 = (this.buffer[((j1 + 0) * i1 + k1 + 1) * l + l1 + 1] - d2) * d0;
                    double d7 = (this.buffer[((j1 + 1) * i1 + k1 + 0) * l + l1 + 1] - d3) * d0;
                    double d8 = (this.buffer[((j1 + 1) * i1 + k1 + 1) * l + l1 + 1] - d4) * d0;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int j2 = 0; j2 < 4; ++j2) {
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                IBlockState iblockstate = null;
                                if (l1 * 8 + i2 < j) {
                                    iblockstate = air;
                                }
                                if (d15 > 0.0) {
                                    iblockstate = darkstone;
                                }
                                int l2 = j2 + j1 * 4;
                                int i3 = i2 + l1 * 8;
                                int j3 = k2 + k1 * 4;
                                primer.func_177855_a(l2, i3, j3, iblockstate);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void buildSurfaces(int p_185937_1_, int p_185937_2_, ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)p_185937_1_, (int)p_185937_2_, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        int i = this.world.func_181545_F() + 1;
        double d0 = 0.03125;
        this.slowsandNoise = this.slowsandGravelNoiseGen.func_76304_a(this.slowsandNoise, p_185937_1_ * 16, p_185937_2_ * 16, 0, 16, 16, 1, d0, d0, 1.0);
        this.gravelNoise = this.slowsandGravelNoiseGen.func_76304_a(this.gravelNoise, p_185937_1_ * 16, 109, p_185937_2_ * 16, 16, 1, 16, d0, 1.0, d0);
        this.depthBuffer = this.netherrackExculsivityNoiseGen.func_76304_a(this.depthBuffer, p_185937_1_ * 16, p_185937_2_ * 16, 0, 16, 16, 1, d0 * 2.0, d0 * 2.0, d0 * 2.0);
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                boolean flag = this.slowsandNoise[j + k * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelNoise[j + k * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                int l = (int)(this.depthBuffer[j + k * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int i1 = -1;
                IBlockState iblockstate = darkstone;
                IBlockState iblockstate1 = darkstone;
                for (int j1 = 127; j1 >= 0; --j1) {
                    if (j1 < 127 - this.rand.nextInt(5) && j1 > this.rand.nextInt(5)) {
                        IBlockState iblockstate2 = primer.func_177856_a(k, j1, j);
                        if (iblockstate2.func_177230_c() != null && iblockstate2.func_185904_a() != Material.field_151579_a) {
                            if (iblockstate2.func_177230_c() != NetherBlocks.DARKSTONE) continue;
                            if (i1 == -1) {
                                if (l <= 0) {
                                    iblockstate = air;
                                    iblockstate1 = darkstone;
                                } else if (j1 >= i - 4 && j1 <= i + 1) {
                                    iblockstate = darkstone;
                                    iblockstate1 = darkstone;
                                    if (flag1) {
                                        iblockstate = darkstone;
                                        iblockstate1 = darkstone;
                                    }
                                    if (flag) {
                                        iblockstate = darksand;
                                        iblockstate1 = darksand;
                                    }
                                }
                                i1 = l;
                                if (j1 >= i - 1) {
                                    primer.func_177855_a(k, j1, j, iblockstate);
                                    continue;
                                }
                                primer.func_177855_a(k, j1, j, iblockstate1);
                                continue;
                            }
                            if (i1 <= 0) continue;
                            --i1;
                            primer.func_177855_a(k, j1, j, iblockstate1);
                            continue;
                        }
                        i1 = -1;
                        continue;
                    }
                    primer.func_177855_a(k, j1, j, bedrock);
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.prepareHeights(x, z, chunkprimer);
        this.buildSurfaces(x, z, chunkprimer);
        this.genCaves.func_186125_a(this.world, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        Biome[] abiome = this.world.func_72959_q().func_76933_b((Biome[])null, x * 16, z * 16, 16, 16);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)abiome[i]);
        }
        chunk.func_76613_n();
        return chunk;
    }

    private double[] getHeights(double[] p_185938_1_, int p_185938_2_, int p_185938_3_, int p_185938_4_, int p_185938_5_, int p_185938_6_, int p_185938_7_) {
        if (p_185938_1_ == null) {
            p_185938_1_ = new double[p_185938_5_ * p_185938_6_ * p_185938_7_];
        }
        double d0 = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.scaleNoise.func_76304_a(this.noiseData4, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, 1, p_185938_7_, 1.0, 0.0, 1.0);
        this.dr = this.depthNoise.func_76304_a(this.dr, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, 1, p_185938_7_, 100.0, 0.0, 100.0);
        this.pnr = this.perlinNoise1.func_76304_a(this.pnr, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_, d0 / 80.0, d1 / 60.0, d0 / 80.0);
        this.ar = this.lperlinNoise1.func_76304_a(this.ar, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_, d0, d1, d0);
        this.br = this.lperlinNoise2.func_76304_a(this.br, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_, d0, d1, d0);
        int i = 0;
        double[] adouble = new double[p_185938_6_];
        for (int j = 0; j < p_185938_6_; ++j) {
            adouble[j] = Math.cos((double)j * Math.PI * 6.0 / (double)p_185938_6_) * 2.0;
            double d2 = j;
            if (j > p_185938_6_ / 2) {
                d2 = p_185938_6_ - 1 - j;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = j;
            adouble[n] = adouble[n] - d2 * d2 * d2 * 10.0;
        }
        for (int l = 0; l < p_185938_5_; ++l) {
            for (int i1 = 0; i1 < p_185938_7_; ++i1) {
                double d3 = 0.0;
                for (int k = 0; k < p_185938_6_; ++k) {
                    double d4 = 0.0;
                    double d5 = adouble[k];
                    double d6 = this.ar[i] / 512.0;
                    double d7 = this.br[i] / 512.0;
                    double d8 = (this.pnr[i] / 10.0 + 1.0) / 2.0;
                    d4 = d8 < 0.0 ? d6 : (d8 > 1.0 ? d7 : d6 + (d7 - d6) * d8);
                    d4 -= d5;
                    if (k > p_185938_6_ - 4) {
                        double d9 = (float)(k - (p_185938_6_ - 4)) / 3.0f;
                        d4 = d4 * (1.0 - d9) + -10.0 * d9;
                    }
                    if ((double)k < d3) {
                        double d10 = (d3 - (double)k) / 4.0;
                        d10 = MathHelper.func_151237_a((double)d10, (double)0.0, (double)1.0);
                        d4 = d4 * (1.0 - d10) + -10.0 * d10;
                    }
                    p_185938_1_[i] = d4;
                    ++i;
                }
            }
        }
        return p_185938_1_;
    }

    public void func_185931_b(int x, int z) {
        int k;
        int i;
        NetherConfig.printDebugInfo("Chuck Provider Abyss: Providing Chuck: " + x + "/" + z);
        BlockPos blockpos = new BlockPos(x * 16, 0, z * 16);
        if (NetherConfig.genDarkfireChance > 0.0f) {
            i = (int)(5.0f * NetherConfig.genDarkfireChance);
            for (k = 0; k < i; ++k) {
                this.darkfireFeature.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
        if (NetherConfig.genDimstoneChance > 0.0f) {
            i = (int)(100.0f * NetherConfig.genDimstoneChance);
            for (k = 0; k < i; ++k) {
                this.dimGemGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
            for (k = 0; k < i; ++k) {
                this.dimGemGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
            }
        }
        if (NetherConfig.genAcidChance > 0.0f) {
            i = (int)(20.0f * NetherConfig.genAcidChance);
            for (k = 0; k < i; ++k) {
                this.acidTrapGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(108) + 10, this.rand.nextInt(16)));
            }
            for (k = 0; k < i / 2; ++k) {
                this.abyssSpringGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
            if (this.rand.nextFloat() < NetherConfig.genAcidChance) {
                this.acidLakesGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
        if (NetherConfig.genWitherOreChance > 0.0f) {
            i = (int)(100.0f * NetherConfig.genWitherOreChance) * 2;
            for (k = 0; k < i; ++k) {
                new WorldGenMinable(NetherBlocks.WITHER_ORE.func_176203_a(1), NetherConfig.genWitherOreMinSize + this.rand.nextInt(NetherConfig.genWitherOreMaxSize - NetherConfig.genWitherOreMinSize), (Predicate)BlockMatcher.func_177642_a((Block)NetherBlocks.DARKSTONE)).func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
        if (NetherConfig.genNetheriteOreChance > 0.0f) {
            i = (int)(100.0f * NetherConfig.genNetheriteOreChance) * 2;
            for (k = 0; k < i; ++k) {
                new WorldGenMinable(NetherBlocks.NETHERITE_ORE.func_176203_a(1), NetherConfig.genNetheriteOreMinSize + this.rand.nextInt(NetherConfig.genNetheriteOreMaxSize - NetherConfig.genNetheriteOreMinSize), (Predicate)BlockMatcher.func_177642_a((Block)NetherBlocks.DARKSTONE)).func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
        if (NetherConfig.genDimensionalOreChance > 0.0f) {
            i = (int)(100.0f * NetherConfig.genDimensionalOreChance) * 2;
            for (k = 0; k < i; ++k) {
                new WorldGenMinable(NetherBlocks.DIMENSIONAL_ORE.func_176223_P(), NetherConfig.genDimensionalOreMinSize + this.rand.nextInt(NetherConfig.genDimensionalOreMaxSize - NetherConfig.genDimensionalOreMinSize), (Predicate)BlockMatcher.func_177642_a((Block)NetherBlocks.DARKSTONE)).func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
        if (NetherConfig.genPhantomTreesChance > 0.0f) {
            i = (int)(10.0f * NetherConfig.genPhantomTreesChance);
            for (k = 0; k < i; ++k) {
                this.phantomTreeGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
        if (NetherConfig.genAshTreesChance > 0.0f) {
            i = (int)(10.0f * NetherConfig.genAshTreesChance);
            for (k = 0; k < i; ++k) {
                this.ashTreeGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
        if (NetherConfig.genObsidianPyramideChance > 0.0f) {
            i = (int)(20.0f * NetherConfig.genObsidianPyramideChance);
            for (k = 0; k < i; ++k) {
                new WorldGenObsidianPyramide().func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(120) + 4, this.rand.nextInt(16) + 8));
            }
        }
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position) {
        return null;
    }

    public void func_180514_a(Chunk p_180514_1_, int p_180514_2_, int p_180514_3_) {
    }
}

