/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.items;

import com.superdextor.adinferos.config.NetherConfig;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWormHole
extends Item {
    public ItemWormHole() {
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af() && NetherConfig.wormholeTravel) {
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("dimension", playerIn.field_71093_bK);
            nbt.func_74768_a("posX", pos.func_177958_n());
            nbt.func_74768_a("posY", pos.func_177956_o() + 1);
            nbt.func_74768_a("posZ", pos.func_177952_p());
            stack.func_77978_p().func_74782_a("coords", (NBTBase)nbt);
            for (int k = 0; k < 15; ++k) {
                playerIn.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, ((double)field_77697_d.nextFloat() - 0.5) * 0.5, ((double)field_77697_d.nextFloat() - 0.5) * 0.5, ((double)field_77697_d.nextFloat() - 0.5) * 0.5, new int[0]);
            }
            playerIn.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 0.4f);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.field_71075_bZ.field_75098_d) {
            playerIn.func_184811_cZ().func_185145_a((Item)this, 20);
        } else {
            playerIn.func_184811_cZ().func_185145_a((Item)this, 180);
        }
        if (!playerIn.func_70093_af() && NetherConfig.wormholeTravel) {
            if (!worldIn.field_72995_K && stack.func_77978_p() != null) {
                NBTTagCompound nbt = (NBTTagCompound)stack.func_77978_p().func_74781_a("coords");
                int dim = nbt.func_74762_e("dimension");
                int posX = nbt.func_74762_e("posX");
                int posY = nbt.func_74762_e("posY");
                int posZ = nbt.func_74762_e("posZ");
                this.teleportTo(worldIn, playerIn, stack, new BlockPos(posX, posY, posZ), dim);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List toolTip, boolean advanced) {
        if (stack.func_77978_p() != null) {
            if (stack.func_77978_p().func_74764_b("coords")) {
                NBTTagCompound nbt = (NBTTagCompound)stack.func_77978_p().func_74781_a("coords");
                int dim = nbt.func_74762_e("dimension");
                double posX = nbt.func_74762_e("posX");
                double posY = nbt.func_74762_e("posY");
                double posZ = nbt.func_74762_e("posZ");
                toolTip.add("Location: X " + posX + " Y " + posY + " Z " + posZ);
            }
        } else {
            toolTip.add("Sneak Click Ground to set Location");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    protected boolean teleportTo(World world, EntityPlayer player, ItemStack stack, BlockPos pos, int dimension) {
        if (player.field_71093_bK == dimension) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 120, 0, false, false));
            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 30, 0, false, false));
            stack.func_77972_a(1, (EntityLivingBase)player);
            BlockPos oldPos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("dimension", player.field_71093_bK);
            nbt.func_74768_a("posX", oldPos.func_177958_n());
            nbt.func_74768_a("posY", oldPos.func_177956_o());
            nbt.func_74768_a("posZ", oldPos.func_177952_p());
            stack.func_77978_p().func_74782_a("coords", (NBTBase)nbt);
            if (player instanceof EntityPlayerMP) {
                EnderTeleportEvent event;
                EntityPlayerMP entityplayermp = (EntityPlayerMP)player;
                if (entityplayermp.field_71135_a.func_147362_b().func_150724_d() && entityplayermp.field_70170_p == world && !entityplayermp.func_70608_bn() && !MinecraftForge.EVENT_BUS.post((Event)(event = new EnderTeleportEvent((EntityLivingBase)entityplayermp, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f)))) {
                    player.func_70634_a(event.getTargetX() + 0.5, event.getTargetY(), event.getTargetZ() + 0.5);
                    player.field_70143_R = 0.0f;
                    player.func_70097_a(DamageSource.field_76379_h, event.getAttackDamage());
                }
            }
            world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 0.6f);
            world.func_184133_a(null, oldPos, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 0.6f);
        }
        return true;
    }
}

