/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.items;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpawnerUpgrade
extends Item {
    public ItemSpawnerUpgrade() {
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack stack) {
        String s = UpgradeType.byItemStack(stack).getName();
        if (s == "empty") {
            return super.func_77653_i(stack);
        }
        return super.func_77653_i(stack) + " " + I18n.func_74838_a((String)("upgrade." + s));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        String s = UpgradeType.byItemStack(stack).getDesc();
        if (!s.isEmpty()) {
            tooltip.add(s);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (UpgradeType upgradeType : UpgradeType.values()) {
            if (!upgradeType.displayOnTab()) continue;
            subItems.add(new ItemStack((Item)this, 1, upgradeType.getMetadata()));
        }
    }

    public static enum UpgradeType {
        EMPTY(0, "empty", 0),
        RADIUS1(1, "radius1", 1, "Increases the spawn radius by 2"),
        RADIUS2(2, "radius2", 2, "Increases the spawn radius by 3"),
        RADIUS3(3, "radius3", 3, "Increases the spawn radius by 5", true),
        SPEED1(4, "speed1", 1, "Decreases the spawn delay by 2 seconds"),
        SPEED2(5, "speed2", 2, "Decreases the spawn delay by 4 seconds"),
        SPEED3(6, "speed3", 3, "Decreases the spawn delay by 6 seconds"),
        SPEED4(7, "speed4", 4, "Decreases the spawn delay by 8 seconds"),
        SPEED5(8, "speed5", 5, "Decreases the spawn delay by 10 seconds", true),
        IGNORESPAWNRULES(9, "ignorespawnrules", 0, "Ignores spawn rules (brightness, ground-block, ect..)", true),
        BLOODFILTER1(10, "bloodfilter1", 1, "Decreases blood use by 15%"),
        BLOODFILTER2(11, "bloodfilter2", 2, "Decreases blood use by 20%"),
        BLOODFILTER3(12, "bloodfilter3", 3, "Decreases blood use by 30%"),
        BLOODFILTER4(13, "bloodfilter4", 4, "Decreases blood use by 45%"),
        BLOODFILTER5(14, "bloodfilter5", 5, "Decreases blood use by 60%", true),
        SPAWNCOUNT1(15, "spawncount1", 1, "Increases spawn count by 1"),
        SPAWNCOUNT2(16, "spawncount2", 2, "Increases spawn count by 2"),
        SPAWNCOUNT3(17, "spawncount3", 3, "Increases spawn count by 3", true),
        MAXCOUNT1(18, "maxcount1", 1, "Increases max nearby entities by 2"),
        MAXCOUNT2(19, "maxcount2", 2, "Increases max nearby entities by 3"),
        MAXCOUNT3(20, "maxcount3", 3, "Increases max nearby entities by 4", true);

        private static final Map<Integer, UpgradeType> META_LOOKUP;
        private final int meta;
        private final String name;
        private final int tier;
        private final String desc;
        private final boolean showOnCreative;

        private UpgradeType(int metaIn, String nameIn, int tierIn) {
            this(metaIn, nameIn, tierIn, "");
        }

        private UpgradeType(int metaIn, String nameIn, int tierIn, String descIn) {
            this(metaIn, nameIn, tierIn, descIn, false);
        }

        private UpgradeType(int metaIn, String nameIn, int tierIn, String descIn, boolean showOnCreativeIn) {
            this.meta = metaIn;
            this.name = nameIn;
            this.tier = tierIn;
            this.desc = descIn;
            this.showOnCreative = showOnCreativeIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String getName() {
            return this.name;
        }

        public int getTier() {
            return this.tier;
        }

        public String getDesc() {
            return this.desc;
        }

        public boolean displayOnTab() {
            return this.showOnCreative;
        }

        public static UpgradeType byMetadata(int meta) {
            UpgradeType itemfishfood$fishtype = META_LOOKUP.get(meta);
            return itemfishfood$fishtype == null ? EMPTY : itemfishfood$fishtype;
        }

        public static UpgradeType byItemStack(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemSpawnerUpgrade ? UpgradeType.byMetadata(stack.func_77960_j()) : EMPTY;
        }

        static {
            META_LOOKUP = Maps.newHashMap();
            for (UpgradeType itemfishfood$fishtype : UpgradeType.values()) {
                META_LOOKUP.put(itemfishfood$fishtype.getMetadata(), itemfishfood$fishtype);
            }
        }
    }
}

