/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.blocks;

import com.superdextor.adinferos.init.NetherItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockHardenedLava
extends Block {
    protected static final AxisAlignedBB HARDENED_LAVA_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)4);

    public BlockHardenedLava() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.setHarvestLevel("pickaxe", 2);
    }

    public AxisAlignedBB func_180640_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return HARDENED_LAVA_AABB;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)meta, (int)0, (int)3)));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)AGE) > 0 && (rand.nextInt(3) == 0 || this.getSolidLavaBlockCount(worldIn, pos) < 4) && worldIn.func_175671_l(pos) > 11 - (Integer)state.func_177229_b((IProperty)AGE) - state.func_185891_c()) {
            this.doAge(worldIn, pos, state, rand, true);
        } else {
            worldIn.func_175684_a(pos, (Block)this, MathHelper.func_76136_a((Random)rand, (int)20, (int)40));
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        int i;
        if ((Integer)state.func_177229_b((IProperty)AGE) > 0 && blockIn == this && (i = this.getSolidLavaBlockCount(worldIn, pos)) < 2) {
            this.makeLava(worldIn, pos, state);
        }
    }

    private int getSolidLavaBlockCount(World worldIn, BlockPos pos) {
        int amount = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this || ++amount < 4) continue;
            return amount;
        }
        return amount;
    }

    protected void doAge(World worldIn, BlockPos pos, IBlockState state, Random rand, boolean isFirstcall) {
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i < 4) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            worldIn.func_175684_a(pos, (Block)this, MathHelper.func_76136_a((Random)rand, (int)20, (int)40));
        } else {
            this.makeLava(worldIn, pos, state);
            if (isFirstcall) {
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    BlockPos blockpos = pos.func_177972_a(enumfacing);
                    IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                    if (iblockstate.func_177230_c() != this) continue;
                    this.doAge(worldIn, blockpos, iblockstate, rand, false);
                }
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            this.makeLava(worldIn, pos, state);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        player.func_71020_j(0.025f);
        this.makeLava(worldIn, pos, state);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    protected void makeLava(World worldIn, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)AGE) > 0 || worldIn.field_73012_v.nextInt(17) == 0) {
            worldIn.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
            worldIn.func_180496_d(pos, (Block)Blocks.field_150353_l);
        } else {
            BlockHardenedLava.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(NetherItems.OBSIDIAN_NUGGET, 2 + worldIn.field_73012_v.nextInt(5)));
        }
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151656_f;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)entityIn;
            if (!entityIn.func_70045_F() && !entitylivingbase.func_70644_a(MobEffects.field_76426_n)) {
                ItemStack stack = entitylivingbase.func_184582_a(EntityEquipmentSlot.FEET);
                if (stack == null) {
                    entityIn.func_70015_d(3);
                } else if (entitylivingbase.func_70681_au().nextInt(12) == 0) {
                    stack.func_77972_a(1, entitylivingbase);
                }
            }
        }
    }
}

