/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.blocks;

import com.google.common.cache.LoadingCache;
import com.superdextor.adinferos.AdInferosSounds;
import com.superdextor.adinferos.AdInferosTab;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.monster.EntityPhantom;
import com.superdextor.adinferos.init.NetherBlocks;
import com.superdextor.adinferos.world.TeleporterAbyss;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAbyssPortal
extends BlockPortal {
    public static EnumFacing teleportDirection = EnumFacing.NORTH;
    public static Vec3d lastPortalVec = new Vec3d(0.0, 0.0, 0.0);

    public BlockAbyssPortal() {
        this.func_149715_a(0.5f);
        this.func_149663_c("abyss_portal");
        this.func_149647_a(AdInferosTab.AI_OTHER);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.field_73011_w.func_76569_d() && worldIn.func_82736_K().func_82766_b("doMobSpawning") && rand.nextInt(2000) < worldIn.func_175659_aa().func_151525_a()) {
            Entity entity;
            int i = pos.func_177956_o();
            BlockPos blockpos = pos;
            while (!worldIn.func_180495_p(blockpos).func_185896_q() && blockpos.func_177956_o() > 0) {
                blockpos = blockpos.func_177977_b();
            }
            if (i > 0 && !worldIn.func_180495_p(blockpos.func_177984_a()).func_185915_l() && (entity = ItemMonsterPlacer.func_77840_a((World)worldIn, (String)EntityList.func_188430_a(EntityPhantom.class), (double)((double)blockpos.func_177958_n() + 0.5), (double)((double)blockpos.func_177956_o() + 1.1), (double)((double)blockpos.func_177952_p() + 0.5))) != null) {
                entity.field_71088_bW = entity.func_82147_ab();
            }
        }
    }

    public boolean func_176548_d(World worldIn, BlockPos pos) {
        Size blockportal$size = new Size(worldIn, pos, EnumFacing.Axis.X);
        if (blockportal$size.isValid() && blockportal$size.portalBlockCount == 0) {
            blockportal$size.placePortalBlocks();
            return true;
        }
        Size blockportal$size1 = new Size(worldIn, pos, EnumFacing.Axis.Z);
        if (blockportal$size1.isValid() && blockportal$size1.portalBlockCount == 0) {
            blockportal$size1.placePortalBlocks();
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        Size blockportal$size1;
        if (NetherConfig.abyssPortalAnywhere) {
            return;
        }
        EnumFacing.Axis enumfacing$axis = (EnumFacing.Axis)state.func_177229_b((IProperty)field_176550_a);
        if (enumfacing$axis == EnumFacing.Axis.X) {
            Size blockportal$size = new Size(worldIn, pos, EnumFacing.Axis.X);
            if (!blockportal$size.isValid() || blockportal$size.portalBlockCount < blockportal$size.width * blockportal$size.height) {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else if (!(enumfacing$axis != EnumFacing.Axis.Z || (blockportal$size1 = new Size(worldIn, pos, EnumFacing.Axis.Z)).isValid() && blockportal$size1.portalBlockCount >= blockportal$size1.width * blockportal$size1.height)) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!NetherConfig.abyssPortalTravel) {
            return;
        }
        if (!worldIn.field_72995_K && entityIn instanceof EntityPlayerMP && !entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU()) {
            this.setInPortal(pos, (EntityPlayerMP)entityIn);
        }
    }

    private void setInPortal(BlockPos pos, EntityPlayerMP entityIn) {
        NetherConfig.printDebugInfo("Attempting to send " + entityIn.func_70005_c_() + " to/from the Abyss");
        MinecraftServer minecraftserver = entityIn.field_70170_p.func_73046_m();
        if (!entityIn.func_184218_aH() && !entityIn.func_70644_a(MobEffects.field_76431_k)) {
            entityIn.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 130, 0, false, false));
            int j = entityIn.field_70170_p.field_73011_w.func_186058_p().func_186068_a() == NetherConfig.dimensionIdAbyss ? 0 : NetherConfig.dimensionIdAbyss;
            BlockPattern.PatternHelper blockpattern$patternhelper = NetherBlocks.ABYSS_PORTAL.func_181089_f(entityIn.field_70170_p, pos);
            double d0 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)blockpattern$patternhelper.func_181117_a().func_177952_p() : (double)blockpattern$patternhelper.func_181117_a().func_177958_n();
            double d1 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? entityIn.field_70161_v : entityIn.field_70165_t;
            d1 = Math.abs(MathHelper.func_181160_c((double)(d1 - (double)(blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 1 : 0)), (double)d0, (double)(d0 - (double)blockpattern$patternhelper.func_181118_d())));
            double d2 = MathHelper.func_181160_c((double)(entityIn.field_70163_u - 1.0), (double)blockpattern$patternhelper.func_181117_a().func_177956_o(), (double)(blockpattern$patternhelper.func_181117_a().func_177956_o() - blockpattern$patternhelper.func_181119_e()));
            lastPortalVec = new Vec3d(d1, d2, 0.0);
            teleportDirection = blockpattern$patternhelper.func_177669_b();
            this.changeDimension(entityIn.field_70170_p, entityIn, j);
        }
    }

    private EntityPlayerMP changeDimension(World worldIn, EntityPlayerMP playerIn, int dimensionIn) {
        if (!ForgeHooks.onTravelToDimension((Entity)playerIn, (int)dimensionIn)) {
            return playerIn;
        }
        MinecraftServer minecraftserver = playerIn.func_184102_h();
        playerIn.field_71133_b.func_184103_al().transferPlayerToDimension(playerIn, dimensionIn, (Teleporter)new TeleporterAbyss(minecraftserver.func_71218_a(dimensionIn)));
        playerIn.field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(AdInferosSounds.ABYSSPORTAL_TRAVEL, SoundCategory.PLAYERS, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, 1.0f, 1.0f));
        return playerIn;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState worldIn, World pos, BlockPos state, Random rand) {
        if (rand.nextInt(100) == 0) {
            pos.func_184134_a((double)state.func_177958_n() + 0.5, (double)state.func_177956_o() + 0.5, (double)state.func_177952_p() + 0.5, AdInferosSounds.ABYSSPORTAL_AMBIENT, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)state.func_177958_n() + rand.nextFloat();
            double d1 = (float)state.func_177956_o() + rand.nextFloat();
            double d2 = (float)state.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (pos.func_180495_p(state.func_177976_e()).func_177230_c() != this && pos.func_180495_p(state.func_177974_f()).func_177230_c() != this) {
                d0 = (double)state.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)state.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            pos.func_175688_a(EnumParticleTypes.SUSPENDED_DEPTH, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151646_E;
    }

    public BlockPattern.PatternHelper func_181089_f(World worldIn, BlockPos p_181089_2_) {
        EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.Z;
        Size BlockAbyssPortal$size = new Size(worldIn, p_181089_2_, EnumFacing.Axis.X);
        LoadingCache loadingcache = BlockPattern.func_181627_a((World)worldIn, (boolean)true);
        if (!BlockAbyssPortal$size.isValid()) {
            enumfacing$axis = EnumFacing.Axis.X;
            BlockAbyssPortal$size = new Size(worldIn, p_181089_2_, EnumFacing.Axis.Z);
        }
        if (!BlockAbyssPortal$size.isValid()) {
            return new BlockPattern.PatternHelper(p_181089_2_, EnumFacing.NORTH, EnumFacing.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[EnumFacing.AxisDirection.values().length];
        EnumFacing enumfacing = BlockAbyssPortal$size.rightDir.func_176735_f();
        BlockPos blockpos = BlockAbyssPortal$size.bottomLeft.func_177981_b(BlockAbyssPortal$size.getHeight() - 1);
        for (EnumFacing.AxisDirection enumfacing$axisdirection : EnumFacing.AxisDirection.values()) {
            BlockPattern.PatternHelper blockpattern$patternhelper = new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection ? blockpos : blockpos.func_177967_a(BlockAbyssPortal$size.rightDir, BlockAbyssPortal$size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection, (EnumFacing.Axis)enumfacing$axis), EnumFacing.UP, loadingcache, BlockAbyssPortal$size.getWidth(), BlockAbyssPortal$size.getHeight(), 1);
            for (int i = 0; i < BlockAbyssPortal$size.getWidth(); ++i) {
                for (int j = 0; j < BlockAbyssPortal$size.getHeight(); ++j) {
                    BlockWorldState blockworldstate = blockpattern$patternhelper.func_177670_a(i, j, 1);
                    if (blockworldstate.func_177509_a() == null || blockworldstate.func_177509_a().func_185904_a() == Material.field_151579_a) continue;
                    int n = enumfacing$axisdirection.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        EnumFacing.AxisDirection enumfacing$axisdirection1 = EnumFacing.AxisDirection.POSITIVE;
        for (EnumFacing.AxisDirection enumfacing$axisdirection2 : EnumFacing.AxisDirection.values()) {
            if (aint[enumfacing$axisdirection2.ordinal()] >= aint[enumfacing$axisdirection1.ordinal()]) continue;
            enumfacing$axisdirection1 = enumfacing$axisdirection2;
        }
        return new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection1 ? blockpos : blockpos.func_177967_a(BlockAbyssPortal$size.rightDir, BlockAbyssPortal$size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection1, (EnumFacing.Axis)enumfacing$axis), EnumFacing.UP, loadingcache, BlockAbyssPortal$size.getWidth(), BlockAbyssPortal$size.getHeight(), 1);
    }

    public static class Size {
        private final World world;
        private final EnumFacing.Axis axis;
        private final EnumFacing rightDir;
        private final EnumFacing leftDir;
        private int portalBlockCount = 0;
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public Size(World worldIn, BlockPos p_i45694_2_, EnumFacing.Axis p_i45694_3_) {
            this.world = worldIn;
            this.axis = p_i45694_3_;
            if (p_i45694_3_ == EnumFacing.Axis.X) {
                this.leftDir = EnumFacing.EAST;
                this.rightDir = EnumFacing.WEST;
            } else {
                this.leftDir = EnumFacing.NORTH;
                this.rightDir = EnumFacing.SOUTH;
            }
            BlockPos blockpos = p_i45694_2_;
            while (p_i45694_2_.func_177956_o() > blockpos.func_177956_o() - 21 && p_i45694_2_.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(p_i45694_2_.func_177977_b()))) {
                p_i45694_2_ = p_i45694_2_.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(p_i45694_2_, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = p_i45694_2_.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos p_180120_1_, EnumFacing p_180120_2_) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = p_180120_1_.func_177967_a(p_180120_2_, i))) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == NetherBlocks.DARK_BRICKS; ++i) {
            }
            Block block = this.world.func_180495_p(p_180120_1_.func_177967_a(p_180120_2_, i)).func_177230_c();
            return block == NetherBlocks.DARK_BRICKS ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    Block block = this.world.func_180495_p(blockpos).func_177230_c();
                    if (!this.isEmptyBlock(this.world.func_180495_p(blockpos))) break block0;
                    if (block == NetherBlocks.ABYSS_PORTAL) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? (block = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir)).func_177230_c()) != NetherBlocks.DARK_BRICKS : i == this.width - 1 && (block = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir)).func_177230_c()) != NetherBlocks.DARK_BRICKS) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)).func_177230_c() == NetherBlocks.DARK_BRICKS) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean isEmptyBlock(IBlockState state) {
            Block blockIn = state.func_177230_c();
            return blockIn.func_149688_o(state) == Material.field_151579_a || blockIn == NetherBlocks.DARK_FIRE || blockIn == NetherBlocks.ABYSS_PORTAL;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), NetherBlocks.ABYSS_PORTAL.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)this.axis), 2);
                }
            }
        }
    }
}

