/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos;

import com.google.common.base.Predicate;
import com.superdextor.adinferos.AdInferosAchievements;
import com.superdextor.adinferos.AdInferosCore;
import com.superdextor.adinferos.AdInferosSounds;
import com.superdextor.adinferos.blocks.BlockAcid;
import com.superdextor.adinferos.blocks.BlockNetherSpawn;
import com.superdextor.adinferos.blocks.BlockSpawner;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.NetherMob;
import com.superdextor.adinferos.entity.monster.EntityGhost;
import com.superdextor.adinferos.entity.monster.EntityObsidianSheepman;
import com.superdextor.adinferos.entity.monster.EntityReaper;
import com.superdextor.adinferos.init.NetherBlocks;
import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.adinferos.items.ItemAmulet;
import com.superdextor.adinferos.items.ItemBloodBucket;
import com.superdextor.adinferos.items.ItemNetheriteArmor;
import com.superdextor.adinferos.items.ItemObsidianArmor;
import com.superdextor.adinferos.items.ItemTribeHeadband;
import com.superdextor.adinferos.items.ItemWitherArmor;
import com.superdextor.adinferos.network.CMessageUpdateDarkNether;
import com.superdextor.adinferos.network.CMessageUpdateNetherSurvival;
import com.superdextor.adinferos.world.ChunkProviderNetherSurvival;
import com.superdextor.adinferos.world.TeleporterNS;
import com.superdextor.thinkbigcore.ThinkBigCore;
import com.superdextor.thinkbigcore.helpers.InventoryHelper;
import com.superdextor.thinkbigcore.network.TBCNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetherEvents {
    private static Logger logger = LogManager.getLogger((String)"Ad Inferos [events]");
    private static final UUID customMovementUUID = UUID.fromString("219afd60-fde4-11e9-a4ac-0613237c5a34");

    public NetherEvents() {
        NetherConfig.printDebugInfo("Registered Event Hooks");
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        World world = e.player.field_70170_p;
        if (!world.field_72995_K && e.player != null) {
            boolean flag;
            EntityPlayerMP player = (EntityPlayerMP)e.player;
            StatisticsManagerServer file = player.func_147099_x();
            BlockPos pos = player.func_180470_cg();
            boolean bl = pos == null ? true : (flag = EntityPlayerMP.func_180467_a((World)world, (BlockPos)pos, (boolean)false) == null);
            if (flag && (AdInferosCore.proxy.isNetherSurvival() || BlockNetherSpawn.hasNetherSpawn((EntityPlayer)player))) {
                if (AdInferosCore.proxy.isNetherSurvival()) {
                    this.sendItems(world, player, file.func_77444_a(StatList.field_188069_A));
                }
                this.sendToHell(world, player, AdInferosCore.proxy.isNetherSurvival());
            }
        }
    }

    @SubscribeEvent
    public void onLogIn(PlayerEvent.PlayerLoggedInEvent e) {
        EntityPlayerMP player;
        StatisticsManagerServer file;
        World world = e.player.field_70170_p;
        this.updateIsNetherSurvival(world, e.player);
        if (!world.field_72995_K && AdInferosCore.proxy.isNetherSurvival() && !(file = (player = (EntityPlayerMP)e.player).func_147099_x()).func_77443_a(AdInferosAchievements.lifeInHell)) {
            player.func_71029_a((StatBase)AdInferosAchievements.lifeInHell);
            this.sendItems(world, player, 0);
            this.sendToHell(world, player, true);
            player.setSpawnChunk(player.func_180425_c(), true, -1);
        }
    }

    private void sendItems(World worldIn, EntityPlayerMP playerIn, int deathCount) {
        playerIn.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 90, 0, true, false));
        if (deathCount == 0) {
            playerIn.func_70690_d(new PotionEffect(MobEffects.field_188425_z, 12000, 0));
        } else {
            playerIn.func_70690_d(new PotionEffect(MobEffects.field_188425_z, 2400, 0));
        }
        if (deathCount < 2) {
            char s = '\"';
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagList bookPages = new NBTTagList();
            if (deathCount == 0) {
                compound.func_74778_a("title", "Welcome " + playerIn.func_70005_c_());
                bookPages.func_74742_a((NBTBase)new NBTTagString(s + "Welcome to your new Home. I cleaned the place up for you. Hope you like it. Oh yes we've already told the locals about your arrival, they'll come to great you soon.. And don't worry about escaping, since you live here, if you die again you'll just spawn back with us.." + s));
                bookPages.func_74742_a((NBTBase)new NBTTagString(s + "Oh, one more thing, as a result of being an resident here, your DNA has undergone some minor changes... \nHurt by Water/Rain \nGrowth of Horns \nMore Strength \nImmunity to Fire/Lava \nand Luck. Most of the locals will not target you if your 'lucky'" + s));
            } else {
                compound.func_74778_a("title", "Welcome back " + playerIn.func_70005_c_());
                bookPages.func_74742_a((NBTBase)new NBTTagString(s + "Welcome back. I see you've met the locals, Yes troubled fellows they are. Don't worry I'm sure you'll get used to em' soon enough.." + s));
            }
            compound.func_74782_a("pages", (NBTBase)bookPages);
            compound.func_74778_a("author", "Unknown");
            ItemStack book = new ItemStack(Items.field_151164_bB);
            ItemWritableBook.func_150930_a((NBTTagCompound)compound);
            book.func_77982_d(compound);
            playerIn.field_71071_by.func_70441_a(book);
        }
    }

    private EntityPlayerMP sendToHell(World worldIn, EntityPlayerMP playerIn, boolean morphDNA) {
        if (morphDNA) {
            playerIn.func_70690_d(new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE, 1, true, true));
            playerIn.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 3600, 0));
            playerIn.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 600, 1));
            playerIn.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.5);
        }
        if (playerIn.field_71093_bK != -1) {
            MinecraftServer minecraftserver = playerIn.func_184102_h();
            playerIn.field_71133_b.func_184103_al().transferPlayerToDimension(playerIn, -1, (Teleporter)new TeleporterNS(minecraftserver.func_71218_a(-1)));
            playerIn.field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(AdInferosSounds.ENTITY_GHOST_IDLE, SoundCategory.PLAYERS, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, 1.0f, 1.0f));
        }
        return playerIn;
    }

    @SubscribeEvent
    public void onLoadWorld(WorldEvent.Load e) {
        World world = e.getWorld();
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        if (!world.field_72995_K && world.func_72863_F() instanceof ChunkProviderServer) {
            ChunkProviderServer providerServer = (ChunkProviderServer)world.func_72863_F();
            if (providerServer.field_186029_c instanceof ChunkProviderNetherSurvival) {
                AdInferosCore.proxy.setNetherSurvival(true);
            } else {
                AdInferosCore.proxy.setNetherSurvival(false);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        World world = e.world;
        if (world.field_73011_w.getDimension() == -1 && e.phase == TickEvent.Phase.START && AdInferosCore.proxy.isNetherSurvival()) {
            int j;
            if (world.func_82736_K().func_82766_b("doDaylightCycle")) {
                world.func_72877_b(world.func_72820_D() + 1L);
            }
            if ((j = this.calculateSkylightSubtracted(world, 1.0f)) != world.func_175657_ab()) {
                world.func_175692_b(j);
            }
            if (AdInferosCore.proxy.isDarkNether() == world.func_72935_r()) {
                AdInferosCore.proxy.setDarkNether(!world.func_72935_r());
                TBCNetwork.sendToDimension((IMessage)new CMessageUpdateDarkNether(!world.func_72935_r()), (int)-1);
                List list = world.func_175661_b(EntityPlayerMP.class, (Predicate)new Predicate<EntityPlayerMP>(){

                    public boolean apply(EntityPlayerMP input) {
                        return true;
                    }
                });
                for (int i = 0; i < list.size(); ++i) {
                    EntityPlayerMP entityplayer = (EntityPlayerMP)list.get(i);
                    if (world.func_72935_r()) {
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_GREEN + "Light returns.."));
                        entityplayer.func_184185_a(SoundEvents.field_187814_ei, 1.0f, 1.0f);
                        continue;
                    }
                    entityplayer.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + "Darkness falls.."));
                    entityplayer.func_184185_a(AdInferosSounds.ABYSSPORTAL_TRIGGER, 1.0f, 1.0f);
                }
            }
        }
    }

    private int calculateSkylightSubtracted(World world, float partialTicks) {
        float f = this.getSunBrightnessFactor(world, partialTicks);
        f = 1.0f - f;
        return (int)(f * 11.0f);
    }

    private float getSunBrightnessFactor(World world, float partialTicks) {
        float f = this.calculateCelestialAngle(world.func_72912_H().func_76073_f(), partialTicks);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(world.func_72867_j(partialTicks) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(world.func_72819_i(partialTicks) * 5.0f) / 16.0));
        return f1;
    }

    private float calculateCelestialAngle(long worldTime, float partialTicks) {
        int i = (int)(worldTime % 24000L);
        float f = ((float)i + partialTicks) / 24000.0f - 0.25f;
        if (f < 0.0f) {
            f += 1.0f;
        }
        if (f > 1.0f) {
            f -= 1.0f;
        }
        float f1 = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
        f += (f1 - f) / 3.0f;
        return f;
    }

    private void updateIsNetherSurvival(World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (AdInferosCore.proxy.isNetherSurvival()) {
                TBCNetwork.sendTo((IMessage)new CMessageUpdateNetherSurvival(true), (EntityPlayerMP)((EntityPlayerMP)player));
            } else {
                TBCNetwork.sendTo((IMessage)new CMessageUpdateNetherSurvival(false), (EntityPlayerMP)((EntityPlayerMP)player));
            }
        }
    }

    @SubscribeEvent
    public void onChangedDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        int i = e.toDim;
        if (i == -1) {
            e.player.func_71029_a((StatBase)AdInferosAchievements.welcome);
        } else if (i == NetherConfig.dimensionIdAbyss) {
            e.player.func_71029_a((StatBase)AdInferosAchievements.abyss);
        }
    }

    @SubscribeEvent
    public void onItemPickup(PlayerEvent.ItemPickupEvent e) {
        Item item = e.pickedUp.func_92059_d().func_77973_b();
        if (item.equals(NetherItems.WITHER_DUST)) {
            e.player.func_71029_a((StatBase)AdInferosAchievements.wither);
        }
        if (item.equals(NetherItems.SCYTHE)) {
            e.player.func_71029_a((StatBase)AdInferosAchievements.scythe);
        }
        if (item.equals(Items.field_151128_bU) || item.equals(NetherItems.QUARTZ_CHUNK)) {
            e.player.func_71029_a((StatBase)AdInferosAchievements.quartz);
        }
        if (item.equals(NetherItems.NETHERITE_INGOT) || item.equals(NetherItems.NETHERITE_NUGGET)) {
            e.player.func_71029_a((StatBase)AdInferosAchievements.netherite);
        }
    }

    @SubscribeEvent
    public void onCraftItem(PlayerEvent.ItemCraftedEvent e) {
        Item item = e.crafting.func_77973_b();
        if (item.equals(NetherItems.QUARTZ_PICKAXE) || item.equals(NetherItems.GLOWSTONE_PICKAXE) || item.equals(NetherItems.OBSIDIAN_PICKAXE) || item.equals(NetherItems.WITHER_PICKAXE) || item.equals(NetherItems.NETHERITE_PICKAXE)) {
            e.player.func_71029_a((StatBase)AdInferosAchievements.hellProspector);
        }
        if (item == Item.func_150898_a((Block)NetherBlocks.ALTAR)) {
            e.player.func_71029_a((StatBase)AdInferosAchievements.hellAltar);
        }
    }

    @SubscribeEvent
    public void onDamage(LivingHurtEvent event) {
        EntityObsidianSheepman.ObsidianSheepmenTribe tribe;
        EntityPlayer attackerPlayer;
        ItemStack stack;
        if (event.getEntity() == null || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase entitylivingbase = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        if (attacker instanceof EntityPlayer && (stack = (attackerPlayer = (EntityPlayer)attacker).func_184582_a(EntityEquipmentSlot.HEAD)) != null && stack.func_77973_b() instanceof ItemTribeHeadband && (tribe = ItemTribeHeadband.getTribe(stack)) != null) {
            tribe.blackListEntity(entitylivingbase);
        }
        if (entitylivingbase instanceof EntityPlayer) {
            EntityObsidianSheepman.ObsidianSheepmenTribe tribe2;
            ItemStack stack2;
            ArrayList stacks;
            boolean flag;
            EntityPlayer entityPlayer = (EntityPlayer)entitylivingbase;
            EntityEquipmentSlot[] slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
            if (event.isCancelable() && source == DamageSource.field_82727_n) {
                flag = false;
                stacks = InventoryHelper.getItems((InventoryPlayer)entityPlayer.field_71071_by, (Item)NetherItems.AMULET, (int)1);
                block0: for (int k = 0; k < 4; ++k) {
                    if (entityPlayer.func_184582_a(slots[k]) != null && entityPlayer.func_184582_a(slots[k]).func_77973_b() instanceof ItemWitherArmor) {
                        flag = true;
                        break;
                    }
                    if (flag || !NetherConfig.amuletEffects || stacks.isEmpty()) continue;
                    for (ItemStack stackIn : stacks) {
                        if (!ItemAmulet.isActive(stackIn)) continue;
                        flag = true;
                        continue block0;
                    }
                }
                if (flag) {
                    event.setCanceled(true);
                }
            }
            if (event.isCancelable() && source.func_76347_k()) {
                flag = false;
                stacks = InventoryHelper.getItems((InventoryPlayer)entityPlayer.field_71071_by, (Item)NetherItems.AMULET, (int)0);
                if (!stacks.isEmpty()) {
                    for (ItemStack stackIn : stacks) {
                        if (!ItemAmulet.isActive(stackIn)) continue;
                        event.setCanceled(true);
                        break;
                    }
                }
            }
            if ((stack2 = entityPlayer.func_184582_a(EntityEquipmentSlot.HEAD)) != null && stack2.func_77973_b() instanceof ItemTribeHeadband && attacker instanceof EntityLivingBase && !(attacker instanceof EntityPlayer) && (tribe2 = ItemTribeHeadband.getTribe(stack2)) != null) {
                tribe2.blackListEntity((EntityLivingBase)attacker);
            }
        }
    }

    @SubscribeEvent
    public void onKillEntity(LivingDeathEvent event) {
        if (event.getEntity() == null || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        DamageSource source = event.getSource();
        Entity killer = source.func_76346_g();
        Entity killedEntity = event.getEntity();
        Random random = world.field_73012_v;
        if (killer instanceof EntityLivingBase) {
            random = ((EntityLivingBase)killer).func_70681_au();
        }
        if (killedEntity instanceof EntitySkeleton && ((EntitySkeleton)killedEntity).func_189771_df() == SkeletonType.WITHER) {
            int l = 0;
            if (killer instanceof EntityLivingBase) {
                l = random.nextInt(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)((EntityLivingBase)killer).func_184614_ca()) + 1);
            }
            killedEntity.func_70099_a(new ItemStack(NetherItems.WITHER_DUST, random.nextInt(3) + l), 0.0f);
        }
        if (killer instanceof EntityPlayer) {
            EntityPlayer killerPlayer = (EntityPlayer)killer;
            if (killedEntity instanceof EntityLivingBase) {
                EntityLivingBase killedLiving = (EntityLivingBase)killedEntity;
                ItemStack theBucket = null;
                EnumHand hand = null;
                if (killerPlayer.func_184614_ca() != null && (killerPlayer.func_184614_ca().func_77973_b() == NetherItems.GOLDEN_BUCKET || killerPlayer.func_184614_ca().func_77973_b() == NetherItems.GOLDEN_BUCKET_BLOOD)) {
                    theBucket = killerPlayer.func_184614_ca();
                    hand = EnumHand.MAIN_HAND;
                } else if (killerPlayer.func_184592_cb() != null && (killerPlayer.func_184592_cb().func_77973_b() == NetherItems.GOLDEN_BUCKET || killerPlayer.func_184592_cb().func_77973_b() == NetherItems.GOLDEN_BUCKET_BLOOD)) {
                    theBucket = killerPlayer.func_184592_cb();
                    hand = EnumHand.OFF_HAND;
                }
                if (theBucket != null && !BlockSpawner.isSpawnerEntity(killedEntity)) {
                    killerPlayer.func_184185_a(SoundEvents.field_187615_H, 0.9f, 1.4f);
                    if (theBucket.func_77973_b() == NetherItems.GOLDEN_BUCKET) {
                        theBucket = new ItemStack(NetherItems.GOLDEN_BUCKET_BLOOD);
                        ItemBloodBucket.setBlood(theBucket, (int)killedLiving.func_110138_aP());
                        killerPlayer.func_184611_a(hand, theBucket);
                    } else {
                        ItemBloodBucket.addBlood(theBucket, (int)killedLiving.func_110138_aP());
                    }
                }
            }
            if (killedEntity instanceof NetherMob || killedEntity instanceof EntityPigZombie || killedEntity instanceof EntityBlaze || killedEntity instanceof EntityGhast || killedEntity instanceof EntityMagmaCube) {
                killerPlayer.func_71029_a((StatBase)AdInferosAchievements.demonSlayer);
            }
            if (killedEntity instanceof EntityObsidianSheepman) {
                killerPlayer.func_71029_a((StatBase)AdInferosAchievements.obsidiancow);
            }
            if (NetherConfig.ghostSpawnFromEntities && !BlockSpawner.isSpawnerEntity(killedEntity)) {
                if (killedEntity instanceof EntityPigZombie && !((EntityPigZombie)killedEntity).func_70631_g_() && random.nextInt(30) == 0) {
                    EntityGhost.createGhost(world, (EntityLiving)killedEntity, "textures/entity/zombie_pigman.png");
                }
                if (killedEntity instanceof EntitySkeleton && random.nextInt(30) == (((EntitySkeleton)killedEntity).func_189771_df() == SkeletonType.WITHER ? 20 : 80)) {
                    EntityGhost.createGhost(world, (EntityLiving)killedEntity, ((EntitySkeleton)killedEntity).func_189771_df() == SkeletonType.WITHER ? "textures/entity/skeleton/wither_skeleton.png" : "textures/entity/skeleton/skeleton.png");
                }
                if (killedEntity instanceof EntityZombie && random.nextInt(30) == 80) {
                    EntityGhost.createGhost(world, (EntityLiving)killedEntity, "textures/entity/zombie/zombie.png");
                }
            }
        }
        if (NetherConfig.ghostSpawnFromPlayers && killedEntity instanceof EntityPlayer && killer instanceof EntityLiving && !(killer instanceof EntityGhost) && !(killer instanceof EntityReaper)) {
            EntityGhost.createGhost(world, (EntityPlayer)killedEntity);
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        if (event.side.equals((Object)Side.CLIENT) && event.player.equals((Object)ThinkBigCore.proxy.getClientPlayer())) {
            AdInferosCore.proxy.doUpdate();
            AdInferosCore.proxy.updatePlayerModel();
        } else if (event.side.equals((Object)Side.SERVER) && this.isValid((EntityLivingBase)event.player)) {
            World world = event.player.field_70170_p;
            EntityPlayer player = event.player;
            if (AdInferosCore.proxy.isNetherSurvival() && !player.func_70644_a(MobEffects.field_76426_n)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE, 1, true, true));
            }
            if (player.field_70143_R > 0.0f && !player.func_70093_af() && !player.func_180799_ab() && !player.func_70617_f_()) {
                boolean quartzFlag = false;
                ItemStack stack = null;
                ArrayList stacks = InventoryHelper.getItems((InventoryPlayer)player.field_71071_by, (Item)NetherItems.AMULET, (int)2);
                if (!stacks.isEmpty()) {
                    for (ItemStack stackIn : stacks) {
                        if (!ItemAmulet.isActive(stackIn)) continue;
                        stack = stackIn;
                        break;
                    }
                }
                if (NetherConfig.amuletEffects && !quartzFlag && stack != null) {
                    quartzFlag = true;
                }
                if (quartzFlag) {
                    player.field_70143_R = 0.08f;
                }
            }
            if (AdInferosCore.proxy.isNetherSurvival() && player.func_70026_G() && (!player.func_70090_H() || !this.isInAcid(world, player.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f)))) {
                player.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
            int obsidianCount = 0;
            EntityEquipmentSlot[] slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
            for (int k = 0; k < 4; ++k) {
                if (player.func_184582_a(slots[k]) == null || !(player.func_184582_a(slots[k]).func_77973_b() instanceof ItemObsidianArmor)) continue;
                ++obsidianCount;
            }
            int netheriteCount = 0;
            for (int k = 0; k < 4; ++k) {
                if (player.func_184582_a(slots[k]) == null || !(player.func_184582_a(slots[k]).func_77973_b() instanceof ItemNetheriteArmor)) continue;
                ++netheriteCount;
            }
            double value = 0.0;
            double f2 = 0.09 * (double)netheriteCount;
            double f1 = 0.07 * (double)obsidianCount;
            value = f2 - f1;
            if (value != 0.0) {
                this.updateMovementSpeed(player, value);
            } else {
                this.removeMovementSpeed(player);
            }
        }
    }

    private boolean isInAcid(World world, AxisAlignedBB bb) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    if (!(world.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2)).func_177230_c() instanceof BlockAcid)) continue;
                    blockpos$pooledmutableblockpos.func_185344_t();
                    return true;
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return false;
    }

    private boolean isValid(EntityLivingBase entitylivingbase) {
        AxisAlignedBB bb = entitylivingbase.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f);
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    if (entitylivingbase.field_70170_p.func_175667_e((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2))) continue;
                    blockpos$pooledmutableblockpos.func_185344_t();
                    return false;
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return true;
    }

    private void updateMovementSpeed(EntityPlayer player, double value) {
        IAttributeInstance atinst = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (atinst.func_111127_a(customMovementUUID) == null) {
            atinst.func_111121_a(new AttributeModifier(customMovementUUID, "AFMovementModifier", value, 2));
        } else if (atinst.func_111127_a(customMovementUUID).func_111164_d() != value) {
            this.removeMovementSpeed(player);
            atinst.func_111121_a(new AttributeModifier(customMovementUUID, "AFMovementModifier", value, 2));
        }
    }

    private void removeMovementSpeed(EntityPlayer player) {
        IAttributeInstance atinst = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (atinst.func_111127_a(customMovementUUID) != null) {
            atinst.func_188479_b(customMovementUUID);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void updateFog(EntityViewRenderEvent.FogColors event) {
        EntityPlayer player;
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && entity.func_70089_S() && AdInferosCore.proxy.isNetherSurvival() && entity.field_71093_bK == -1 && !(player = (EntityPlayer)entity).func_70644_a(MobEffects.field_76440_q)) {
            if (AdInferosCore.proxy.isDarkNether()) {
                event.setRed(0.0f);
                event.setGreen(0.0f);
                event.setBlue(0.0f);
            } else {
                event.setRed(0.5f);
                event.setGreen(0.15f);
                event.setBlue(0.15f);
            }
        }
    }
}

