/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.worldgen;

import com.superdextor.adinferos.blocks.BlockNetherLeaf;
import com.superdextor.adinferos.blocks.BlockNetherLog;
import com.superdextor.adinferos.blocks.BlockNetherPlanks;
import com.superdextor.adinferos.init.NetherBlocks;
import com.superdextor.thinkbigcore.worldgen.IOverridable;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenMagmaTree
extends WorldGenAbstractTree
implements IOverridable {
    private static final IBlockState log = NetherBlocks.LOG.func_176223_P().func_177226_a(BlockNetherLog.VARIANT, (Comparable)((Object)BlockNetherPlanks.EnumType.MAGMA));
    private static final IBlockState leaves = NetherBlocks.LEAVES.func_176223_P().func_177226_a(BlockNetherLeaf.VARIANT, (Comparable)((Object)BlockNetherPlanks.EnumType.MAGMA)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private final boolean playerMade;
    public boolean doOverride = false;

    public WorldGenMagmaTree(boolean notify, boolean playerMade) {
        super(notify);
        this.playerMade = playerMade;
    }

    public void doOverride() {
        this.doOverride = true;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(3) + rand.nextInt(2) + 6;
        int j = position.func_177958_n();
        int k = position.func_177956_o();
        int l = position.func_177952_p();
        if (this.doOverride || k >= 1 && k + i + 1 < 256) {
            BlockPos blockpos = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(blockpos);
            Block block = state.func_177230_c();
            if (!this.doOverride && this.playerMade ? state.func_177230_c() != Blocks.field_150353_l && block != Blocks.field_150424_aL && block != Blocks.field_150425_aM && block != NetherBlocks.DARKSTONE && block != NetherBlocks.DARK_SAND && block != NetherBlocks.GOLD_ORE && block != NetherBlocks.DIMENSIONAL_ORE && block != NetherBlocks.NETHERITE_ORE && block != NetherBlocks.WITHER_ORE && block != Blocks.field_150449_bY : state.func_177230_c() != Blocks.field_150353_l) {
                return false;
            }
            if (!this.doOverride && position.func_177956_o() >= worldIn.func_72800_K() - i - 1) {
                return false;
            }
            if (!this.doOverride && !this.func_181638_a(worldIn, position, i)) {
                return false;
            }
            this.onPlantGrow(worldIn, blockpos, position);
            this.onPlantGrow(worldIn, blockpos.func_177974_f(), position);
            this.onPlantGrow(worldIn, blockpos.func_177968_d(), position);
            this.onPlantGrow(worldIn, blockpos.func_177968_d().func_177974_f(), position);
            EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
            int i1 = i - rand.nextInt(4);
            int j1 = 2 - rand.nextInt(3);
            int k1 = j;
            int l1 = l;
            int i2 = k + i - 1;
            for (int j2 = 0; j2 < i; ++j2) {
                int k2;
                BlockPos blockpos1;
                if (j2 >= i1 && j1 > 0) {
                    k1 += enumfacing.func_82601_c();
                    l1 += enumfacing.func_82599_e();
                    --j1;
                }
                if (!(state = worldIn.func_180495_p(blockpos1 = new BlockPos(k1, k2 = k + j2, l1))).func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos1) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos1)) continue;
                this.func_181639_b(worldIn, blockpos1);
                this.func_181639_b(worldIn, blockpos1.func_177974_f());
                this.func_181639_b(worldIn, blockpos1.func_177968_d());
                this.func_181639_b(worldIn, blockpos1.func_177974_f().func_177968_d());
            }
            for (int i3 = -2; i3 <= 0; ++i3) {
                for (int l3 = -2; l3 <= 0; ++l3) {
                    int k4 = -1;
                    this.func_150526_a(worldIn, k1 + i3, i2 + k4, l1 + l3);
                    this.func_150526_a(worldIn, 1 + k1 - i3, i2 + k4, l1 + l3);
                    this.func_150526_a(worldIn, k1 + i3, i2 + k4, 1 + l1 - l3);
                    this.func_150526_a(worldIn, 1 + k1 - i3, i2 + k4, 1 + l1 - l3);
                    if (i3 <= -2 && l3 <= -1 || i3 == -1 && l3 == -2) continue;
                    k4 = 1;
                    this.func_150526_a(worldIn, k1 + i3, i2 + k4, l1 + l3);
                    this.func_150526_a(worldIn, 1 + k1 - i3, i2 + k4, l1 + l3);
                    this.func_150526_a(worldIn, k1 + i3, i2 + k4, 1 + l1 - l3);
                    this.func_150526_a(worldIn, 1 + k1 - i3, i2 + k4, 1 + l1 - l3);
                }
            }
            if (rand.nextBoolean()) {
                this.func_150526_a(worldIn, k1, i2 + 2, l1);
                this.func_150526_a(worldIn, k1 + 1, i2 + 2, l1);
                this.func_150526_a(worldIn, k1 + 1, i2 + 2, l1 + 1);
                this.func_150526_a(worldIn, k1, i2 + 2, l1 + 1);
            }
            for (int j3 = -3; j3 <= 4; ++j3) {
                for (int i4 = -3; i4 <= 4; ++i4) {
                    if (j3 == -3 && i4 == -3 || j3 == -3 && i4 == 4 || j3 == 4 && i4 == -3 || j3 == 4 && i4 == 4 || Math.abs(j3) >= 3 && Math.abs(i4) >= 3) continue;
                    this.func_150526_a(worldIn, k1 + j3, i2, l1 + i4);
                }
            }
            for (int k3 = -1; k3 <= 2; ++k3) {
                for (int j4 = -1; j4 <= 2; ++j4) {
                    if (k3 >= 0 && k3 <= 1 && j4 >= 0 && j4 <= 1 || rand.nextInt(3) > 0) continue;
                    int l4 = rand.nextInt(3) + 2;
                    for (int i5 = 0; i5 < l4; ++i5) {
                        this.func_181639_b(worldIn, new BlockPos(j + k3, i2 - i5 - 1, l + j4));
                    }
                    for (int j5 = -1; j5 <= 1; ++j5) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            this.func_150526_a(worldIn, k1 + k3 + j5, i2, l1 + j4 + l2);
                        }
                    }
                    for (int k5 = -2; k5 <= 2; ++k5) {
                        for (int l5 = -2; l5 <= 2; ++l5) {
                            if (Math.abs(k5) == 2 && Math.abs(l5) == 2) continue;
                            this.func_150526_a(worldIn, k1 + k3 + k5, i2 - 1, l1 + j4 + l5);
                        }
                    }
                }
            }
            this.doOverride = false;
            return true;
        }
        return false;
    }

    private boolean func_181638_a(World p_181638_1_, BlockPos p_181638_2_, int p_181638_3_) {
        int i = p_181638_2_.func_177958_n();
        int j = p_181638_2_.func_177956_o();
        int k = p_181638_2_.func_177952_p();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l = 0; l <= p_181638_3_ + 1; ++l) {
            int i1 = 1;
            if (l == 0) {
                i1 = 0;
            }
            if (l >= p_181638_3_ - 1) {
                i1 = 2;
            }
            for (int j1 = -i1; j1 <= i1; ++j1) {
                for (int k1 = -i1; k1 <= i1; ++k1) {
                    if (this.isReplaceable(p_181638_1_, (BlockPos)blockpos$mutableblockpos.func_181079_c(i + j1, j + l, k + k1))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void func_181639_b(World p_181639_1_, BlockPos p_181639_2_) {
        if (this.func_150523_a(p_181639_1_.func_180495_p(p_181639_2_).func_177230_c())) {
            this.func_175903_a(p_181639_1_, p_181639_2_, log);
        }
    }

    private void func_150526_a(World worldIn, int p_150526_2_, int p_150526_3_, int p_150526_4_) {
        BlockPos blockpos = new BlockPos(p_150526_2_, p_150526_3_, p_150526_4_);
        IBlockState state = worldIn.func_180495_p(blockpos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos)) {
            this.func_175903_a(worldIn, blockpos, leaves);
        }
    }

    private void onPlantGrow(World world, BlockPos pos, BlockPos source) {
        IBlockState state = world.func_180495_p(pos);
        state.func_177230_c().onPlantGrow(state, world, pos, source);
    }
}

