/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.inventory;

import com.superdextor.adinferos.init.NetherBlocks;
import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.adinferos.inventory.ContainerSpawner;
import com.superdextor.adinferos.inventory.ExtractorRecipes;
import com.superdextor.adinferos.items.ItemBloodBucket;
import com.superdextor.adinferos.items.ItemSoul;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntitySpawner
extends TileEntityMobSpawner
implements IInteractionObject,
ISidedInventory {
    private final MobSpawnerLogic spawnerLogic = new MobSpawnerLogic(this);
    private static final int[] slotsTop = new int[]{1};
    private static final int[] slotsBottom = new int[]{1, 1};
    private static final int[] slotsSides = new int[]{0};
    private int spawnerBlood;
    private ItemStack[] spawnerItemStacks = new ItemStack[5];
    private String spawnerCustomName;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.spawnerLogic.func_98270_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.spawnerItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j < 0 || j >= this.spawnerItemStacks.length) continue;
            this.spawnerItemStacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        this.spawnerBlood = compound.func_74762_e("Blood");
        if (compound.func_150297_b("CustomName", 8)) {
            this.spawnerCustomName = compound.func_74779_i("CustomName");
        }
        this.updateUpgrades();
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.updateUpgrades();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.spawnerLogic.func_189530_b(compound);
        compound.func_74768_a("Blood", this.spawnerBlood);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.spawnerItemStacks.length; ++i) {
            if (this.spawnerItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.spawnerItemStacks[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.spawnerCustomName);
        }
        return compound;
    }

    public void func_73660_a() {
        boolean shouldUpdate = false;
        if (!this.field_145850_b.field_72995_K && ItemBloodBucket.hasBlood(this.spawnerItemStacks[1])) {
            shouldUpdate = true;
            this.spawnerBlood += ItemBloodBucket.getBlood(this.spawnerItemStacks[1]);
            ItemBloodBucket.setBlood(this.spawnerItemStacks[1], 0);
            if (this.spawnerItemStacks[1].func_77973_b().equals(NetherItems.GOLDEN_BUCKET_BLOOD)) {
                this.spawnerItemStacks[1] = this.spawnerItemStacks[1].func_77960_j() > 0 ? null : new ItemStack(NetherItems.GOLDEN_BUCKET);
            }
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187621_J, SoundCategory.BLOCKS, 1.4f, 0.7f);
        }
        if (shouldUpdate) {
            this.func_70296_d();
        }
        this.spawnerLogic.func_98278_g();
    }

    private void updateUpgrades() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.spawnerLogic.updateEntityName();
            for (int i = 0; i < 3; ++i) {
                this.spawnerLogic.updateUpgrade(this.spawnerItemStacks[2 + i]);
            }
        } else if (this.field_145850_b != null) {
            this.spawnerLogic.updateEntityName();
        }
    }

    public Packet<?> getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189515_b(nbttagcompound);
        nbttagcompound.func_82580_o("SpawnPotentials");
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbttagcompound);
    }

    public boolean func_145842_c(int id, int type) {
        return this.spawnerLogic.func_98268_b(id);
    }

    public boolean func_183000_F() {
        return true;
    }

    public MobSpawnerBaseLogic func_145881_a() {
        return this.spawnerLogic;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.spawnerCustomName : "container.spawner";
    }

    public boolean func_145818_k_() {
        return this.spawnerCustomName != null && !this.spawnerCustomName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.spawnerItemStacks.length;
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        return this.spawnerItemStacks[index];
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a((ItemStack[])this.spawnerItemStacks, (int)index, (int)count);
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a((ItemStack[])this.spawnerItemStacks, (int)index);
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        boolean flag = stack != null && stack.func_77969_a(this.spawnerItemStacks[index]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.spawnerItemStacks[index]);
        this.spawnerItemStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (index != 1) {
            this.updateUpgrades();
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return stack == null || stack.func_77973_b() instanceof ItemSoul;
        }
        if (index == 1) {
            return ItemBloodBucket.hasBlood(stack);
        }
        return stack == null || stack.func_77960_j() > 0 && stack.func_77973_b() == NetherItems.SPAWNER_UPGRADE;
    }

    public int func_174887_a_(int id) {
        return this.spawnerBlood;
    }

    public void func_174885_b(int id, int value) {
        this.spawnerBlood = value;
    }

    public int func_174890_g() {
        return 1;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.spawnerItemStacks.length; ++i) {
            this.spawnerItemStacks[i] = null;
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index != 1 || !ItemBloodBucket.hasBlood(stack);
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerSpawner(playerInventory, (IInventory)this);
    }

    public String func_174875_k() {
        return "adinferos:spawner";
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public static class MobSpawnerLogic
    extends MobSpawnerBaseLogic {
        private final TileEntitySpawner tileEntitySpawner;
        private double mobRotation = 0.0;
        private double prevMobRotation = 0.0;
        private int spawnDelay = 20;
        private int minSpawnDelay = 300;
        private int maxSpawnDelay = 900;
        private final int spawnCountBase = 3;
        private final int spawnRangeBase = 4;
        private final int maxNearbyEntitiesBase = 5;
        protected int field_98289_l = 24;
        protected int field_98294_i = this.spawnCountBase;
        protected int field_98290_m = this.spawnRangeBase;
        protected int spawnDelayOffset = 0;
        protected int field_98292_k = this.maxNearbyEntitiesBase;
        protected boolean ignoreSpawnRules = false;
        protected float bloodDecrease = 1.0f;
        protected Entity displayEntity = null;
        protected int bloodPerSpawn = 0;
        protected String entityName = "";

        public MobSpawnerLogic(TileEntitySpawner spawnerIn) {
            this.tileEntitySpawner = spawnerIn;
        }

        private void applyDefaults() {
            this.field_98294_i = this.spawnCountBase;
            this.field_98290_m = this.spawnRangeBase;
            this.spawnDelayOffset = 0;
            this.field_98292_k = this.maxNearbyEntitiesBase;
            this.ignoreSpawnRules = false;
            this.bloodDecrease = 1.0f;
        }

        private void updateUpgrade(ItemStack stack) {
            if (stack == null || stack.func_77960_j() == 0 || stack.func_77973_b() != NetherItems.SPAWNER_UPGRADE) {
                return;
            }
            int i = stack.func_77960_j();
            switch (i) {
                default: {
                    break;
                }
                case 1: {
                    this.field_98290_m = this.spawnRangeBase + 2;
                    break;
                }
                case 2: {
                    this.field_98290_m = this.spawnRangeBase + 3;
                    break;
                }
                case 3: {
                    this.field_98290_m = this.spawnRangeBase + 5;
                    break;
                }
                case 4: {
                    this.spawnDelayOffset = 40;
                    break;
                }
                case 5: {
                    this.spawnDelayOffset = 80;
                    break;
                }
                case 6: {
                    this.spawnDelayOffset = 120;
                    break;
                }
                case 7: {
                    this.spawnDelayOffset = 160;
                    break;
                }
                case 8: {
                    this.spawnDelayOffset = 200;
                    break;
                }
                case 9: {
                    this.ignoreSpawnRules = true;
                    break;
                }
                case 10: {
                    this.bloodDecrease = 0.85f;
                    break;
                }
                case 11: {
                    this.bloodDecrease = 0.8f;
                    break;
                }
                case 12: {
                    this.bloodDecrease = 0.7f;
                    break;
                }
                case 13: {
                    this.bloodDecrease = 0.65f;
                    break;
                }
                case 14: {
                    this.bloodDecrease = 0.4f;
                    break;
                }
                case 15: {
                    this.field_98294_i = this.spawnCountBase + 1;
                    break;
                }
                case 16: {
                    this.field_98294_i = this.spawnCountBase + 2;
                    break;
                }
                case 17: {
                    this.field_98294_i = this.spawnCountBase + 3;
                    break;
                }
                case 18: {
                    this.field_98292_k = this.maxNearbyEntitiesBase + 2;
                    break;
                }
                case 19: {
                    this.field_98292_k = this.maxNearbyEntitiesBase + 3;
                    break;
                }
                case 20: {
                    this.field_98292_k = this.maxNearbyEntitiesBase + 4;
                }
            }
        }

        public void func_98272_a(String name) {
        }

        private boolean isActivated() {
            BlockPos blockpos = this.func_177221_b();
            return this.func_98271_a().func_175636_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, (double)this.field_98289_l);
        }

        public void func_98278_g() {
            if (!this.isActivated()) {
                this.prevMobRotation = this.mobRotation;
            } else {
                BlockPos blockpos = this.func_177221_b();
                if (this.func_98271_a().field_72995_K) {
                    double d3 = (float)blockpos.func_177958_n() + this.func_98271_a().field_73012_v.nextFloat();
                    double d4 = (float)blockpos.func_177956_o() + this.func_98271_a().field_73012_v.nextFloat();
                    double d5 = (float)blockpos.func_177952_p() + this.func_98271_a().field_73012_v.nextFloat();
                    this.func_98271_a().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d3, d4, d5, 0.0, 0.0, 0.0, new int[0]);
                    this.func_98271_a().func_175688_a(EnumParticleTypes.FLAME, d3, d4, d5, 0.0, 0.0, 0.0, new int[0]);
                    if (this.spawnDelay > 0) {
                        --this.spawnDelay;
                    }
                    this.prevMobRotation = this.mobRotation;
                    this.mobRotation = (this.mobRotation + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
                } else {
                    if (this.spawnDelay == -1) {
                        this.resetTimer();
                    }
                    if (this.spawnDelay > 0) {
                        --this.spawnDelay;
                        return;
                    }
                    if (this.entityName.isEmpty()) {
                        return;
                    }
                    int b = (int)((float)this.bloodPerSpawn * this.bloodDecrease);
                    boolean flag = false;
                    for (int i = 0; i < this.field_98294_i && b <= this.tileEntitySpawner.spawnerBlood; ++i) {
                        World world = this.func_98271_a();
                        Entity entity = EntityList.func_75620_a((String)this.entityName, (World)world);
                        if (entity == null) {
                            return;
                        }
                        int k = world.func_72872_a(entity.getClass(), new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g((double)this.field_98290_m)).size();
                        if (k >= this.field_98292_k) {
                            this.resetTimer();
                            return;
                        }
                        EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                        double d0 = (double)blockpos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5;
                        double d1 = blockpos.func_177956_o() + world.field_73012_v.nextInt(3) - 1;
                        double d2 = (double)blockpos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5;
                        entity.func_70012_b(d0, d1, d2, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        entity.func_184211_a("AdSpawnerEntity");
                        if (entityliving != null && (!entityliving.func_70601_bi() && !this.ignoreSpawnRules || !entityliving.func_70058_J())) continue;
                        if (entityliving != null) {
                            entityliving.func_180482_a(world.func_175649_E(new BlockPos(entity)), (IEntityLivingData)null);
                        }
                        TileEntitySpawner tileEntitySpawner = this.tileEntitySpawner;
                        tileEntitySpawner.spawnerBlood = tileEntitySpawner.spawnerBlood - b;
                        world.func_72838_d(entity);
                        world.func_175718_b(2004, blockpos, 0);
                        if (entityliving != null) {
                            entityliving.func_70656_aK();
                        }
                        flag = true;
                    }
                    if (flag) {
                        this.resetTimer();
                    }
                }
            }
        }

        private void resetTimer() {
            if (this.maxSpawnDelay <= this.minSpawnDelay) {
                this.spawnDelay = this.minSpawnDelay;
            } else {
                int i = this.maxSpawnDelay - this.minSpawnDelay;
                this.spawnDelay = this.minSpawnDelay + this.func_98271_a().field_73012_v.nextInt(i) - this.spawnDelayOffset;
            }
            this.func_98267_a(1);
        }

        public void func_98270_a(NBTTagCompound nbt) {
            this.spawnDelay = nbt.func_74765_d("Delay");
            this.updateEntityName();
            if (nbt.func_150297_b("MinSpawnDelay", 99)) {
                this.minSpawnDelay = nbt.func_74765_d("MinSpawnDelay");
                this.maxSpawnDelay = nbt.func_74765_d("MaxSpawnDelay");
                this.field_98294_i = nbt.func_74765_d("SpawnCount");
            }
            if (nbt.func_150297_b("MaxNearbyEntities", 99)) {
                this.field_98292_k = nbt.func_74765_d("MaxNearbyEntities");
                this.field_98289_l = nbt.func_74765_d("RequiredPlayerRange");
            }
            if (nbt.func_150297_b("SpawnRange", 99)) {
                this.field_98290_m = nbt.func_74765_d("SpawnRange");
            }
        }

        protected void updateEntityName() {
            if (ItemSoul.hasSoul(this.tileEntitySpawner.spawnerItemStacks[0])) {
                String s;
                this.entityName = s = ItemSoul.getSoulID(this.tileEntitySpawner.spawnerItemStacks[0]);
                ExtractorRecipes.ExtractorRecipe recipe = ExtractorRecipes.getRecipe(s);
                this.bloodPerSpawn = recipe == null ? 50 : recipe.bloodForSpawn;
            } else {
                this.bloodPerSpawn = 0;
                this.entityName = "";
            }
        }

        public NBTTagCompound func_189530_b(NBTTagCompound nbt) {
            String s = this.entityName;
            if (!StringUtils.func_151246_b((String)s)) {
                nbt.func_74777_a("Delay", (short)this.spawnDelay);
                nbt.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
                nbt.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
                nbt.func_74777_a("SpawnCount", (short)this.field_98294_i);
                nbt.func_74777_a("MaxNearbyEntities", (short)this.field_98292_k);
                nbt.func_74777_a("RequiredPlayerRange", (short)this.field_98289_l);
                nbt.func_74777_a("SpawnRange", (short)this.field_98290_m);
            }
            return nbt;
        }

        public boolean func_98268_b(int delay) {
            if (delay == 1 && this.func_98271_a().field_72995_K) {
                this.spawnDelay = this.minSpawnDelay;
                return true;
            }
            return false;
        }

        public void func_98267_a(int id) {
            this.tileEntitySpawner.field_145850_b.func_175641_c(this.tileEntitySpawner.field_174879_c, NetherBlocks.SPAWNER, id, 0);
        }

        public World func_98271_a() {
            return this.tileEntitySpawner.field_145850_b;
        }

        public BlockPos func_177221_b() {
            return this.tileEntitySpawner.field_174879_c;
        }

        @SideOnly(value=Side.CLIENT)
        public Entity func_184994_d() {
            if (this.entityName.isEmpty()) {
                if (this.displayEntity != null) {
                    this.displayEntity = null;
                }
            } else {
                boolean flag = false;
                if (this.displayEntity == null) {
                    flag = true;
                } else if (EntityList.func_75621_b((Entity)this.displayEntity) != this.entityName) {
                    flag = true;
                }
                if (flag) {
                    this.displayEntity = EntityList.func_75620_a((String)this.entityName, (World)this.func_98271_a());
                    if (this.displayEntity instanceof EntityLiving) {
                        ((EntityLiving)this.displayEntity).func_180482_a(this.func_98271_a().func_175649_E(this.func_177221_b()), null);
                    }
                }
            }
            return this.displayEntity;
        }

        @SideOnly(value=Side.CLIENT)
        public double func_177222_d() {
            return this.mobRotation;
        }

        @SideOnly(value=Side.CLIENT)
        public double func_177223_e() {
            return this.prevMobRotation;
        }
    }
}

