/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.inventory;

import com.google.common.base.Predicate;
import com.superdextor.adinferos.blocks.BlockChiseledNetherrack;
import com.superdextor.adinferos.entity.monster.EntityInfernumAvis;
import com.superdextor.adinferos.init.NetherBlocks;
import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.adinferos.inventory.AltarRecipes;
import com.superdextor.adinferos.inventory.ContainerAltar;
import com.superdextor.adinferos.items.ItemBloodBucket;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityAltar
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    private ItemStack[] altarItemStacks = new ItemStack[7];
    public int age;
    private int cookTime;
    private String customName;
    private static Random rand = new Random();
    private boolean isActive = false;
    public int blood = 0;
    private int bloodForBar = 600;
    private int summonCountdown = -1;
    private float recipeDuration = 0.0f;
    private boolean isObsidian = false;

    public void setObsidian() {
        this.isObsidian = true;
        this.bloodForBar = 200;
    }

    public int func_70302_i_() {
        return this.altarItemStacks.length;
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        return this.altarItemStacks[index];
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a((ItemStack[])this.altarItemStacks, (int)index, (int)count);
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a((ItemStack[])this.altarItemStacks, (int)index);
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        boolean flag = stack != null && stack.func_77969_a(this.altarItemStacks[index]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.altarItemStacks[index]);
        this.altarItemStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (index == 0 && !flag) {
            this.recipeDuration = 0.0f;
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : (this.isObsidian ? "container.obsidian_altar" : "container.infernum_altar");
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomInventoryName(String name) {
        this.customName = name;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.altarItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.altarItemStacks.length) continue;
            this.altarItemStacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.cookTime = compound.func_74765_d("CookTime");
        this.blood = compound.func_74762_e("Blood");
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        if (compound.func_74767_n("IsObsidian")) {
            this.setObsidian();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("CookTime", (short)this.cookTime);
        compound.func_74768_a("Blood", this.blood);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.altarItemStacks.length; ++i) {
            if (this.altarItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.altarItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        if (this.isObsidian) {
            compound.func_74757_a("IsObsidian", true);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_73660_a() {
        ++this.age;
        if (!this.field_145850_b.field_72995_K) {
            if (this.isObsidian) {
                if (this.summonCountdown > -1) {
                    --this.summonCountdown;
                    if (this.summonCountdown < 1) {
                        this.summonAvis();
                    }
                } else if (this.blood >= 1600) {
                    this.startSummon();
                }
            }
            if (this.altarItemStacks[0] != null && this.canAlter()) {
                if (rand.nextFloat() < this.recipeDuration) {
                    if (this.canAlter()) {
                        ++this.cookTime;
                        if (this.cookTime == 200) {
                            this.cookTime = 0;
                            this.alterItem();
                        }
                    } else {
                        this.cookTime = 0;
                    }
                }
            } else if (this.cookTime > 0) {
                --this.cookTime;
            }
            if (this.age % 20 == 0) {
                boolean wasActive = this.isActive;
                if (this.checkIsActive()) {
                    if (!wasActive) {
                        if (!this.isObsidian) {
                            IBlockState block = NetherBlocks.CHISELED_NETHERRACK.func_176203_a(1);
                            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(2, 1, 2), block);
                            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(-2, 1, 2), block);
                            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(-2, 1, -2), block);
                            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(2, 1, -2), block);
                        }
                        this.updateBloodHolders();
                    }
                } else if (wasActive) {
                    this.deactivateBlocks();
                }
            }
        } else {
            if (this.age % 20 == 0) {
                this.isActive = this.checkIsActive();
            }
            if (this.isActive) {
                if (this.age % 30 == 0) {
                    this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.07, 0.0, new int[0]);
                }
                if (this.age % 3 == 0) {
                    int i = Block.func_149682_b((Block)Blocks.field_150356_k);
                    this.field_145850_b.func_175688_a(EnumParticleTypes.BLOCK_DUST, (double)this.field_174879_c.func_177958_n() + 2.0 + rand.nextDouble(), (double)this.field_174879_c.func_177956_o() + 0.0, (double)this.field_174879_c.func_177952_p() + 0.0 + rand.nextDouble(), 0.0, 0.05, 0.0, new int[]{i});
                    this.field_145850_b.func_175688_a(EnumParticleTypes.BLOCK_DUST, (double)this.field_174879_c.func_177958_n() + 0.0 + rand.nextDouble(), (double)this.field_174879_c.func_177956_o() + 0.0, (double)this.field_174879_c.func_177952_p() + 2.0 + rand.nextDouble(), 0.0, 0.05, 0.0, new int[]{i});
                    this.field_145850_b.func_175688_a(EnumParticleTypes.BLOCK_DUST, (double)this.field_174879_c.func_177958_n() - 2.0 + rand.nextDouble(), (double)this.field_174879_c.func_177956_o() + 0.0, (double)this.field_174879_c.func_177952_p() + 0.0 + rand.nextDouble(), 0.0, 0.05, 0.0, new int[]{i});
                    this.field_145850_b.func_175688_a(EnumParticleTypes.BLOCK_DUST, (double)this.field_174879_c.func_177958_n() + 0.0 + rand.nextDouble(), (double)this.field_174879_c.func_177956_o() + 0.0, (double)this.field_174879_c.func_177952_p() - 2.0 + rand.nextDouble(), 0.0, 0.05, 0.0, new int[]{i});
                }
            }
        }
    }

    private boolean checkIsActive() {
        this.isActive = false;
        if (!(this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(2, -1, 0)).func_177230_c() instanceof BlockSoulSand)) {
            return false;
        }
        if (!(this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(-2, -1, 0)).func_177230_c() instanceof BlockSoulSand)) {
            return false;
        }
        if (!(this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(0, -1, -2)).func_177230_c() instanceof BlockSoulSand)) {
            return false;
        }
        if (!(this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(0, -1, 2)).func_177230_c() instanceof BlockSoulSand)) {
            return false;
        }
        if (this.isObsidian) {
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(2, 0, 2)).func_177230_c() != NetherBlocks.SMOOTH_OBSIDIAN) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(2, 0, -2)).func_177230_c() != NetherBlocks.SMOOTH_OBSIDIAN) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(-2, 0, -2)).func_177230_c() != NetherBlocks.SMOOTH_OBSIDIAN) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(-2, 0, 2)).func_177230_c() != NetherBlocks.SMOOTH_OBSIDIAN) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(2, 1, 2)).func_177230_c() != NetherBlocks.SMOOTH_OBSIDIAN) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(2, 1, -2)).func_177230_c() != NetherBlocks.SMOOTH_OBSIDIAN) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(-2, 1, -2)).func_177230_c() != NetherBlocks.SMOOTH_OBSIDIAN) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(-2, 1, 2)).func_177230_c() != NetherBlocks.SMOOTH_OBSIDIAN) {
                return false;
            }
        } else {
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(2, 0, 2)).func_177230_c() != NetherBlocks.SMOOTH_NETHERRACK) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(2, 0, -2)).func_177230_c() != NetherBlocks.SMOOTH_NETHERRACK) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(-2, 0, -2)).func_177230_c() != NetherBlocks.SMOOTH_NETHERRACK) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(-2, 0, 2)).func_177230_c() != NetherBlocks.SMOOTH_NETHERRACK) {
                return false;
            }
            if (!(this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(2, 1, 2)).func_177230_c() instanceof BlockChiseledNetherrack)) {
                return false;
            }
            if (!(this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(2, 1, -2)).func_177230_c() instanceof BlockChiseledNetherrack)) {
                return false;
            }
            if (!(this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(-2, 1, -2)).func_177230_c() instanceof BlockChiseledNetherrack)) {
                return false;
            }
            if (!(this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(-2, 1, 2)).func_177230_c() instanceof BlockChiseledNetherrack)) {
                return false;
            }
        }
        this.isActive = true;
        return true;
    }

    private void deactivateBlocks() {
        this.blood = 0;
        IBlockState block = Blocks.field_150425_aM.func_176223_P();
        if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(2, -1, 0)).func_177230_c().equals(NetherBlocks.BLOOD_HOLDER)) {
            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(2, -1, 0), block);
        }
        if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(-2, -1, 0)).func_177230_c().equals(NetherBlocks.BLOOD_HOLDER)) {
            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(-2, -1, 0), block);
        }
        if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(0, -1, -2)).func_177230_c().equals(NetherBlocks.BLOOD_HOLDER)) {
            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(0, -1, -2), block);
        }
        if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(0, -1, 2)).func_177230_c().equals(NetherBlocks.BLOOD_HOLDER)) {
            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(0, -1, 2), block);
        }
        block = NetherBlocks.CHISELED_NETHERRACK.func_176223_P();
        if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(2, 1, 2)).func_177230_c().equals(NetherBlocks.CHISELED_NETHERRACK)) {
            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(2, 1, 2), block);
        }
        if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(-2, 1, 2)).func_177230_c().equals(NetherBlocks.CHISELED_NETHERRACK)) {
            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(-2, 1, 2), block);
        }
        if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(2, 1, -2)).func_177230_c().equals(NetherBlocks.CHISELED_NETHERRACK)) {
            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(2, 1, -2), block);
        }
        if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(-2, 1, -2)).func_177230_c().equals(NetherBlocks.CHISELED_NETHERRACK)) {
            this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(-2, 1, -2), block);
        }
    }

    private void updateBloodHolders() {
        int i = this.getBlood();
        if (i > 9) {
            i = 9;
        }
        IBlockState block = NetherBlocks.BLOOD_HOLDER.func_176203_a(i);
        this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(2, -1, 0), block);
        this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(-2, -1, 0), block);
        this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(0, -1, -2), block);
        this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(0, -1, 2), block);
    }

    private void startSummon() {
        this.summonCountdown = 800;
        this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_187555_bJ, SoundCategory.BLOCKS, 1.0f, 0.6f);
        for (EntityPlayerMP entityplayermp : this.field_145850_b.func_175661_b(EntityPlayerMP.class, (Predicate)new Predicate<EntityPlayerMP>(){

            public boolean apply(EntityPlayerMP player) {
                return TileEntityAltar.this.getDistanceSqToEntity((Entity)player) < 240.0;
            }
        })) {
            entityplayermp.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + "You! You will pay for waking me.."));
        }
    }

    private void summonAvis() {
        this.summonCountdown = -1;
        this.blood = 0;
        EntityInfernumAvis infernumAvis = new EntityInfernumAvis(this.field_145850_b);
        this.field_145850_b.func_72876_a((Entity)infernumAvis, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 3.0f, true);
        infernumAvis.func_70012_b((double)this.func_174877_v().func_177958_n() - 0.5, this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() - 0.5, 0.0f, 0.0f);
        this.field_145850_b.func_72838_d((Entity)infernumAvis);
        infernumAvis.setSleeping(false);
        this.field_145850_b.func_180501_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P(), 3);
    }

    public void onBreak() {
        this.deactivateBlocks();
    }

    public int getBlood() {
        return this.blood / this.bloodForBar;
    }

    private boolean canAlter() {
        if (this.altarItemStacks[0] == null) {
            return false;
        }
        if (this.isObsidian && this.blood >= 1600) {
            return false;
        }
        if (this.altarItemStacks[0].func_77973_b().equals(NetherItems.GOLDEN_BUCKET) || ItemBloodBucket.getBlood(this.altarItemStacks[0]) > 0) {
            this.recipeDuration = 1.0f;
            return true;
        }
        if (this.isObsidian) {
            return false;
        }
        AltarRecipes.AltarRecipe recipe = AltarRecipes.getRecipe(this.altarItemStacks);
        if (recipe == null) {
            return false;
        }
        if (recipe.blood > this.blood) {
            return false;
        }
        this.recipeDuration = recipe.duration;
        return true;
    }

    public void alterItem() {
        if (this.canAlter()) {
            ItemStack itemstack;
            if (ItemBloodBucket.getBlood(this.altarItemStacks[0]) > 0) {
                this.blood += ItemBloodBucket.getBlood(this.altarItemStacks[0]);
                ItemBloodBucket.setBlood(this.altarItemStacks[0], 0);
                if (this.altarItemStacks[0].func_77973_b().equals(NetherItems.GOLDEN_BUCKET_BLOOD)) {
                    this.altarItemStacks[0] = this.altarItemStacks[0].func_77960_j() > 0 ? null : new ItemStack(NetherItems.GOLDEN_BUCKET);
                }
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187621_J, SoundCategory.BLOCKS, 1.4f, 0.7f);
                this.updateBloodHolders();
                return;
            }
            if (this.altarItemStacks[0].func_77973_b().equals(NetherItems.GOLDEN_BUCKET)) {
                ItemStack bloodBucket = new ItemStack(NetherItems.GOLDEN_BUCKET_BLOOD);
                ItemBloodBucket.setBlood(bloodBucket, this.blood);
                this.blood = 0;
                this.altarItemStacks[0] = bloodBucket;
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187633_N, SoundCategory.BLOCKS, 1.4f, 0.7f);
                this.updateBloodHolders();
                return;
            }
            if (this.isObsidian) {
                return;
            }
            AltarRecipes.AltarRecipe recipe = AltarRecipes.getRecipe(this.altarItemStacks);
            if (recipe.input1 != null) {
                this.altarItemStacks[1] = null;
            }
            if (recipe.input2 != null) {
                this.altarItemStacks[2] = null;
            }
            if (recipe.input3 != null) {
                this.altarItemStacks[3] = null;
            }
            if (recipe.input4 != null) {
                this.altarItemStacks[4] = null;
            }
            if (recipe.input5 != null) {
                this.altarItemStacks[5] = null;
            }
            if (recipe.input6 != null) {
                this.altarItemStacks[6] = null;
            }
            if ((itemstack = recipe.output) != null) {
                this.altarItemStacks[0] = itemstack.func_77946_l();
            }
            this.blood -= recipe.blood;
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 1.4f, 0.7f);
            this.updateBloodHolders();
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public String func_174875_k() {
        return "adinferos:infernum_alter";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerAltar(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.blood;
            }
            case 1: {
                return this.bloodForBar;
            }
            case 2: {
                return this.cookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.blood = value;
                break;
            }
            case 1: {
                this.bloodForBar = value;
                break;
            }
            case 2: {
                this.cookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.altarItemStacks.length; ++i) {
            this.altarItemStacks[i] = null;
        }
    }

    public double getDistanceSqToEntity(Entity entityIn) {
        double d0 = (double)this.func_174877_v().func_177958_n() - entityIn.field_70165_t;
        double d1 = (double)this.func_174877_v().func_177956_o() - entityIn.field_70163_u;
        double d2 = (double)this.func_174877_v().func_177952_p() - entityIn.field_70161_v;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int time) {
        return this.cookTime * time / 200;
    }

    public boolean isActive() {
        return this.isActive;
    }
}

