/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.init;

import com.superdextor.adinferos.blocks.BlockAcid;
import com.superdextor.adinferos.config.NetherConfig;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class NetherFluids {
    public static Fluid fluidAcid;
    public static BlockAcid blockAcid;
    public static Set<IFluidBlock> fluidBlocks;

    public static void registerFluids() {
        fluidAcid = NetherFluids.createFluid("acid", "blocks/acid", true);
        blockAcid = NetherFluids.registerFluidBlock(new BlockAcid(fluidAcid, Material.field_151586_h));
        NetherConfig.printDebugInfo("Registered Fluids");
    }

    private static Fluid createFluid(String name, String textureName, boolean hasFlowIcon) {
        ResourceLocation flowing;
        ResourceLocation still = new ResourceLocation("adinferos", textureName + "_still");
        Fluid fluid = new Fluid(name, still, flowing = hasFlowIcon ? new ResourceLocation("adinferos", textureName + "_flow") : still);
        if (!FluidRegistry.registerFluid((Fluid)fluid)) {
            throw new IllegalStateException(String.format("Unable to register fluid %s", fluid));
        }
        return fluid;
    }

    private static <T extends Block> T registerFluidBlock(T block) {
        String fluidName = ((IFluidBlock)block).getFluid().getUnlocalizedName().substring(6);
        block.func_149663_c(fluidName);
        GameRegistry.registerBlock(block, (String)fluidName);
        fluidBlocks.add((IFluidBlock)block);
        return block;
    }

    static {
        fluidBlocks = new HashSet<IFluidBlock>();
    }
}

