/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.entity.monster;

import com.google.common.base.Predicate;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.NetherMob;
import com.superdextor.adinferos.entity.monster.EntityGlowstoneSkeleton;
import com.superdextor.adinferos.entity.monster.EntityObsidianSheepman;
import com.superdextor.adinferos.entity.monster.EntityReaper;
import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.adinferos.world.WorldProviderAbyss;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySkeletonHorse
extends EntityMob
implements NetherMob {
    private static final DataParameter<Boolean> IS_WITHER = EntityDataManager.func_187226_a(EntitySkeletonHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_REARING = EntityDataManager.func_187226_a(EntitySkeletonHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    private int jumpRearingCounter;
    private float rearingAmount;
    private float prevRearingAmount;
    private float mouthOpenness;
    private float prevMouthOpenness;

    public EntitySkeletonHorse(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.4f, 1.6f);
        this.field_70178_ae = true;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, true, false, (Predicate)new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                return !input.func_70644_a(MobEffects.field_188425_z);
            }
        }));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
        this.field_70728_aV = 7;
    }

    public float func_70047_e() {
        return 1.9f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.34);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_WITHER, (Object)false);
        this.func_184212_Q().func_187214_a(IS_REARING, (Object)false);
    }

    public boolean isWither() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_WITHER);
    }

    public void setWither(boolean value) {
        this.func_184212_Q().func_187227_b(IS_WITHER, (Object)value);
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(10) == 0 && !this.func_70610_aX()) {
            this.setRearing(true);
        }
        return SoundEvents.field_187858_fe;
    }

    protected SoundEvent func_184601_bQ() {
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.setRearing(true);
        }
        return SoundEvents.field_187862_fg;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187860_ff;
    }

    protected Item func_146068_u() {
        return Items.field_151103_aS;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        super.func_70628_a(wasRecentlyHit, lootingModifier);
        if (this.isWither()) {
            int i = this.field_70146_Z.nextInt(3);
            if (lootingModifier > 0) {
                i += this.field_70146_Z.nextInt(lootingModifier + 1);
            }
            if (i > 0) {
                this.func_145779_a(NetherItems.WITHER_DUST, i);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        IEntityLivingData data = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73011_w instanceof WorldProviderAbyss && this.func_70681_au().nextInt(5) > 0) {
            this.setWither(true);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        }
        Object riderIn = null;
        if (this.field_70170_p.field_73012_v.nextInt(7) == 0) {
            riderIn = new EntitySkeleton(this.field_70170_p);
        } else if (this.field_70170_p.field_73012_v.nextInt(10) == 0) {
            riderIn = new EntityGlowstoneSkeleton(this.field_70170_p);
        } else if (this.field_70170_p.field_73012_v.nextInt(30) == 0) {
            riderIn = new EntityReaper(this.field_70170_p);
        } else if (this.field_70170_p.field_73012_v.nextInt(10) == 0) {
            riderIn = new EntityObsidianSheepman(this.field_70170_p);
            NBTTagCompound NBTTag = new NBTTagCompound();
            NBTTag.func_74777_a("Anger", (short)400);
            riderIn.func_70014_b(NBTTag);
        }
        if (riderIn != null) {
            riderIn.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            riderIn.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
            this.field_70170_p.func_72838_d((Entity)riderIn);
            riderIn.func_184220_m((Entity)this);
        }
        NetherConfig.printDebugInfo(this.func_70005_c_() + " was spawned at " + this.func_180425_c());
        return data;
    }

    public void func_70071_h_() {
        if (this.func_184186_bw() && this.jumpRearingCounter > 0 && ++this.jumpRearingCounter > 20) {
            this.jumpRearingCounter = 0;
            this.setRearing(false);
        }
        this.prevRearingAmount = this.rearingAmount;
        if (this.isRearing()) {
            this.rearingAmount += (1.0f - this.rearingAmount) * 0.4f + 0.05f;
            if (this.rearingAmount > 1.0f) {
                this.rearingAmount = 1.0f;
            }
        } else {
            this.rearingAmount += (0.8f * this.rearingAmount * this.rearingAmount * this.rearingAmount - this.rearingAmount) * 0.6f - 0.05f;
            if (this.rearingAmount < 0.0f) {
                this.rearingAmount = 0.0f;
            }
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.isWither() && source == DamageSource.field_82727_n) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            Entity entity = source.func_76346_g();
            return this.func_184207_aI() && this.func_184187_bx() != entity ? true : true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (this.isWither() && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 200));
            }
            return true;
        }
        return false;
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setWither(tagCompund.func_74767_n("Wither"));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Wither", this.isWither());
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)passenger;
            this.field_70761_aq = entityliving.field_70761_aq;
        }
        if (this.prevRearingAmount > 0.0f) {
            float f3 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f1 = 0.7f * this.prevRearingAmount;
            float f2 = 0.15f * this.prevRearingAmount;
            passenger.func_70107_b(this.field_70165_t + (double)(f1 * f3), this.field_70163_u + this.func_70042_X() + passenger.func_70033_W() + (double)f2, this.field_70161_v - (double)(f1 * f));
            if (passenger instanceof EntityLivingBase) {
                ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    public void setRearing(boolean value) {
        if (value) {
            this.jumpRearingCounter = 1;
        }
        this.func_184212_Q().func_187227_b(IS_REARING, (Object)value);
    }

    public boolean isRearing() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_REARING);
    }

    @SideOnly(value=Side.CLIENT)
    public float getRearingAmount(float p_110223_1_) {
        return this.prevRearingAmount + (this.rearingAmount - this.prevRearingAmount) * p_110223_1_;
    }

    @Override
    public boolean isDarkfireResistant() {
        return this.isWither();
    }

    @Override
    public boolean isCurseResistant() {
        return this.isWither();
    }

    @Override
    public boolean isWitherResistant() {
        return this.isWither();
    }

    @Override
    public boolean isAcidResistant() {
        return false;
    }

    @Override
    public boolean isSpikeResistant() {
        return false;
    }
}

