/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.entity.monster;

import com.mojang.authlib.GameProfile;
import com.superdextor.adinferos.AdInferosSounds;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.ISoulEntity;
import com.superdextor.adinferos.entity.NetherMob;
import com.superdextor.adinferos.init.NetherItems;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGhost
extends EntityFlying
implements IMob,
NetherMob {
    private GameProfile gameProfile = null;
    private int divingDelay = 0;
    private static final DataParameter<String> TEXTURES = EntityDataManager.func_187226_a(EntitySkeleton.class, (DataSerializer)DataSerializers.field_187194_d);
    private boolean isPlayerGhost = false;
    protected String soul = "";
    protected String soulName = "";

    public EntityGhost(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
        if (NetherConfig.ghostFireResistant) {
            this.field_70178_ae = true;
        }
        this.field_70728_aV = NetherConfig.ghostEXP;
        this.field_70145_X = true;
        this.field_70765_h = new GhostMoveHelper(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)NetherConfig.curseSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)NetherConfig.ghostHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a((double)NetherConfig.ghostDamage);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TEXTURES, (Object)"textures/entity/steve.png");
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.func_70638_az() != null) {
                ++this.divingDelay;
                if (this.divingDelay > 130) {
                    this.divingDelay = -this.field_70146_Z.nextInt(100);
                    this.func_184185_a(AdInferosSounds.ENTITY_GHOST_DIVE, this.func_70599_aP(), this.func_70647_i());
                    double d = 0.2;
                    if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                        d = 0.6;
                    }
                    if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        d = 0.8;
                    }
                    this.func_70605_aq().func_75642_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 1.0 + d);
                }
            } else {
                this.divingDelay = 0;
            }
        }
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return AdInferosSounds.ENTITY_GHOST_IDLE;
    }

    protected SoundEvent func_184601_bQ() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return AdInferosSounds.ENTITY_GHOST_DEATH;
    }

    protected Item func_146068_u() {
        return this.isPlayerGhost ? null : NetherItems.SOUL_FRAGMENT;
    }

    protected void func_184610_a(boolean playerKill, int looting, DamageSource source) {
        if (NetherConfig.ghostDrops) {
            super.func_184610_a(playerKill, looting, source);
        }
    }

    protected float func_70599_aP() {
        return 3.0f;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 4;
    }

    public float func_70047_e() {
        return 1.74f;
    }

    protected void func_145775_I() {
    }

    protected boolean func_145771_j(double x, double y, double z) {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        if (entityIn == this.func_70638_az()) {
            this.func_184609_a(EnumHand.MAIN_HAND);
            this.func_70652_k(entityIn);
        }
    }

    public boolean func_70094_T() {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                if (itemstack != null && itemstack1 != null && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_82727_n) {
            return false;
        }
        if (source == DamageSource.field_76372_a) {
            return false;
        }
        if (source == DamageSource.field_76371_c) {
            return false;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (flag) {
            double d0 = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
        return flag;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        IEntityLivingData data = super.func_180482_a(difficulty, livingdata);
        this.func_184185_a(AdInferosSounds.ENTITY_GHOST_SPAWN, this.func_70599_aP(), this.func_70647_i());
        this.setTextures(this.getRandomTexture());
        NetherConfig.printDebugInfo(this.func_70005_c_() + " was spawned at " + this.func_180425_c());
        return data;
    }

    public String getTextures() {
        return (String)this.func_184212_Q().func_187225_a(TEXTURES);
    }

    protected void setTextures(String value) {
        this.func_184212_Q().func_187227_b(TEXTURES, (Object)value);
    }

    private String getRandomTexture() {
        switch (this.field_70146_Z.nextInt(15)) {
            default: {
                return "textures/entity/steve.png";
            }
            case 1: {
                return "textures/entity/alex.png";
            }
            case 2: {
                return "player:herobrine";
            }
            case 3: {
                return "player:superdextor";
            }
            case 4: {
                return "player:obsidiancow";
            }
            case 5: {
                return "player:tigercubevan";
            }
            case 6: {
                return "player:Dragon_Potato";
            }
            case 7: {
                return "player:Unknown_Shadows";
            }
            case 8: {
                return "player:Pat_TBC";
            }
            case 9: {
                return "player:Mario";
            }
            case 10: {
                return "player:Luigi";
            }
            case 11: {
                return "player:Ryu";
            }
            case 12: {
                return "player:Jeb_";
            }
            case 13: {
                return "player:Dinnerbone";
            }
            case 14: 
        }
        return "player:OhNoz";
    }

    public void setSoul(EntityPlayer player) {
        this.setTextures("player:" + player.func_70005_c_());
    }

    public void setSoul(ISoulEntity soulEntity) {
        this.setTextures(soulEntity.getTexture());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74764_b("Textures") && tagCompund.func_74779_i("Textures") != null) {
            this.setTextures(tagCompund.func_74779_i("Textures"));
        }
        if (tagCompund.func_74767_n("PlayerGhost")) {
            this.isPlayerGhost = true;
        }
        this.soul = tagCompund.func_74779_i("Soul");
        this.soulName = tagCompund.func_74779_i("SoulName");
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74778_a("Textures", this.getTextures());
        tagCompound.func_74757_a("PlayerGhost", this.isPlayerGhost);
        tagCompound.func_74778_a("Soul", this.soul);
        tagCompound.func_74778_a("SoulName", this.soulName);
    }

    public GameProfile getGameProfile(String name) {
        if (this.gameProfile == null) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("Name", name);
            this.gameProfile = TileEntitySkull.func_174884_b((GameProfile)NBTUtil.func_152459_a((NBTTagCompound)compound));
        }
        return this.gameProfile;
    }

    public String getSoul() {
        return this.soul;
    }

    public String getSoulName() {
        return this.soulName;
    }

    @Override
    public boolean isDarkfireResistant() {
        return NetherConfig.ghostDarkfireResistant;
    }

    @Override
    public boolean isCurseResistant() {
        return NetherConfig.ghostCurseResistant;
    }

    @Override
    public boolean isWitherResistant() {
        return NetherConfig.ghostWitherResistant;
    }

    @Override
    public boolean isAcidResistant() {
        return NetherConfig.ghostAcidResistant;
    }

    @Override
    public boolean isSpikeResistant() {
        return true;
    }

    public static EntityGhost createGhost(World worldIn, EntityLiving entityLiving, String texture) {
        EntityGhost ghost = new EntityGhost(worldIn);
        ghost.func_70012_b(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, entityLiving.field_70177_z, entityLiving.field_70125_A);
        ghost.func_180482_a(worldIn.func_175649_E(entityLiving.func_180425_c()), null);
        ghost.setTextures(texture);
        ghost.soul = EntityList.func_75621_b((Entity)entityLiving);
        ghost.soulName = entityLiving.func_70005_c_();
        worldIn.func_72838_d((Entity)ghost);
        return ghost;
    }

    public static EntityGhost createGhost(World worldIn, EntityLiving entityLiving, ISoulEntity soulEntity) {
        EntityGhost ghost = new EntityGhost(worldIn);
        ghost.func_70012_b(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, entityLiving.field_70177_z, entityLiving.field_70125_A);
        ghost.func_180482_a(worldIn.func_175649_E(entityLiving.func_180425_c()), null);
        ghost.setSoul(soulEntity);
        worldIn.func_72838_d((Entity)ghost);
        ghost.soul = EntityList.func_75621_b((Entity)entityLiving);
        ghost.soulName = entityLiving.func_70005_c_();
        soulEntity.onCreateGhost(ghost);
        return ghost;
    }

    public static EntityGhost createGhost(World worldIn, EntityPlayer player) {
        EntityGhost ghost = new EntityGhost(worldIn);
        ghost.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        ghost.func_180482_a(worldIn.func_175649_E(player.func_180425_c()), null);
        ghost.setSoul(player);
        ghost.isPlayerGhost = true;
        worldIn.func_72838_d((Entity)ghost);
        return ghost;
    }

    static class GhostMoveHelper
    extends EntityMoveHelper {
        private EntityGhost parentEntity;
        private int courseChangeCooldown;

        public GhostMoveHelper(EntityGhost ghost) {
            super((EntityLiving)ghost);
            this.parentEntity = ghost;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                this.parentEntity.func_70659_e((float)(this.field_75645_e * this.parentEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    d3 = MathHelper.func_76133_a((double)d3);
                    this.parentEntity.field_70159_w += d0 / d3 * 0.1 * this.field_75645_e;
                    this.parentEntity.field_70181_x += d1 / d3 * 0.1 * this.field_75645_e;
                    this.parentEntity.field_70179_y += d2 / d3 * 0.1 * this.field_75645_e;
                }
            }
        }
    }

    static class AILookAround
    extends EntityAIBase {
        private EntityGhost parentEntity;

        public AILookAround(EntityGhost ghost) {
            this.parentEntity = ghost;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 57.295776f;
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                double d0 = 64.0;
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < d0 * d0) {
                    double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private EntityGhost parentEntity;

        public AIRandomFly(EntityGhost ghost) {
            this.parentEntity = ghost;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            if (this.parentEntity.func_70638_az() != null) {
                d0 = this.parentEntity.func_70638_az().field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                d1 = this.parentEntity.func_70638_az().field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                d2 = this.parentEntity.func_70638_az().field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            }
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }
}

