/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.entity.monster;

import com.google.common.base.Predicate;
import com.superdextor.adinferos.AdInferosCore;
import com.superdextor.adinferos.AdInferosSounds;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.NetherMob;
import com.superdextor.adinferos.init.NetherBlocks;
import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.adinferos.world.WorldProviderAbyss;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityCurse
extends EntityMob
implements NetherMob {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityCurse.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityCurse(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 1.95f);
        if (NetherConfig.curseFireResistant) {
            this.field_70178_ae = true;
        }
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, true, false, (Predicate)new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer input) {
                return !input.func_70644_a(MobEffects.field_188425_z);
            }
        }));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
        this.field_70728_aV = NetherConfig.curseEXP;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)NetherConfig.curseHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)NetherConfig.curseSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)NetherConfig.curseDamage);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TYPE, (Object)0);
    }

    public int getType() {
        return (Integer)this.func_184212_Q().func_187225_a(TYPE);
    }

    public void setType(int value) {
        this.func_184212_Q().func_187227_b(TYPE, (Object)value);
    }

    private IBlockState getCurseIn() {
        switch (this.getType()) {
            case 1: {
                return NetherBlocks.CURSE.func_176203_a(1);
            }
            case 2: {
                return NetherBlocks.CURSE.func_176203_a(2);
            }
            case 3: {
                return NetherBlocks.CURSE.func_176203_a(3);
            }
        }
        return NetherBlocks.CURSE.func_176223_P();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && NetherConfig.curseTrail) {
            for (int l = 0; l < 4; ++l) {
                int k;
                int j;
                int i = MathHelper.func_76128_c((double)(this.field_70165_t + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)(this.field_70161_v + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
                if (this.field_70170_p.func_180495_p(blockpos).func_185904_a() != Material.field_151579_a || !NetherBlocks.CURSE.func_176196_c(this.field_70170_p, blockpos)) continue;
                this.field_70170_p.func_175656_a(blockpos, this.getCurseIn());
            }
        } else if (this.field_70146_Z.nextFloat() < 0.4f) {
            switch (this.getType()) {
                case 1: {
                    double d0 = (double)((float)this.field_70165_t + this.field_70146_Z.nextFloat()) - 0.5;
                    double d1 = (float)this.field_70163_u;
                    double d2 = (double)((float)this.field_70161_v + this.field_70146_Z.nextFloat()) - 0.5;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.03, 0.0, new int[0]);
                    break;
                }
                case 2: {
                    double d0 = (double)((float)this.field_70165_t + this.field_70146_Z.nextFloat()) - 0.5;
                    double d1 = (float)this.field_70163_u;
                    double d2 = (double)((float)this.field_70161_v + this.field_70146_Z.nextFloat()) - 0.5;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, d0, d1, d2, 0.1, 0.1, 0.1, new int[0]);
                    break;
                }
                case 3: {
                    double d0 = (double)((float)this.field_70165_t + this.field_70146_Z.nextFloat()) - 0.5;
                    double d1 = (float)this.field_70163_u;
                    double d2 = (double)((float)this.field_70161_v + this.field_70146_Z.nextFloat()) - 0.5;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, d0, d1, d2, 0.1, 0.5, 0.0, new int[0]);
                    break;
                }
                default: {
                    double d0 = (double)((float)this.field_70165_t + this.field_70146_Z.nextFloat()) - 0.5;
                    double d1 = (float)this.field_70163_u;
                    double d2 = (double)((float)this.field_70161_v + this.field_70146_Z.nextFloat()) - 0.5;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, d0, d1, d2, 0.5, 0.0, 1.0, new int[0]);
                    break;
                }
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return AdInferosSounds.ENTITY_CURSE_IDLE;
    }

    protected SoundEvent func_184601_bQ() {
        return AdInferosSounds.ENTITY_CURSE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AdInferosSounds.ENTITY_CURSE_DEATH;
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.field_73011_w.getDimension() == -1 && !AdInferosCore.proxy.isDarkNether()) {
            return false;
        }
        return super.func_70601_bi();
    }

    protected boolean func_70814_o() {
        return true;
    }

    protected Item func_146068_u() {
        switch (this.getType()) {
            case 1: {
                return Items.field_151137_ax;
            }
            case 2: {
                return NetherItems.WITHER_DUST;
            }
            case 3: {
                return Items.field_151070_bp;
            }
        }
        return Items.field_151016_H;
    }

    protected void func_184610_a(boolean playerKill, int looting, DamageSource source) {
        if (NetherConfig.curseDrops) {
            super.func_184610_a(playerKill, looting, source);
        }
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.7f;
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setType(tagCompund.func_74762_e("Type"));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Type", this.getType());
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        IEntityLivingData data = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73011_w instanceof WorldProviderAbyss) {
            if (this.field_70146_Z.nextBoolean()) {
                this.setType(2);
            } else {
                this.setType(0);
            }
        } else if (this.field_70146_Z.nextBoolean()) {
            this.setType(1);
        } else {
            this.setType(3);
        }
        NetherConfig.printDebugInfo(this.func_70005_c_() + " was spawned at " + this.func_180425_c());
        return data;
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (NetherConfig.curseDebuffs && entity instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                int b0 = 2;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    b0 = 6;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    b0 = 10;
                }
                if (b0 > 0) {
                    switch (this.getType()) {
                        case 1: {
                            entity.func_70015_d(b0 / 2);
                            break;
                        }
                        case 2: {
                            entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_82731_v, b0 * 48, 0));
                            break;
                        }
                        case 3: {
                            entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76436_u, b0 * 38, 0));
                            break;
                        }
                        default: {
                            entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76431_k, b0 * 38, 0));
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    public boolean isDarkfireResistant() {
        return NetherConfig.curseDarkfireResistant;
    }

    @Override
    public boolean isCurseResistant() {
        return NetherConfig.curseCurseResistant;
    }

    @Override
    public boolean isWitherResistant() {
        return NetherConfig.curseWitherResistant;
    }

    @Override
    public boolean isAcidResistant() {
        return NetherConfig.curseAcidResistant;
    }

    @Override
    public boolean isSpikeResistant() {
        return false;
    }
}

