/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.blocks;

import com.superdextor.adinferos.entity.NetherMob;
import com.superdextor.adinferos.init.NetherItems;
import com.superdextor.thinkbigcore.blocks.BlockCustom;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWitherBlock
extends BlockCustom {
    protected static final AxisAlignedBB WITHER_BLOCK_AABB = new AxisAlignedBB(0.01, 0.01, 0.01, 0.99, 0.99, 0.99);
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockWitherBlock(Material materialIn, int type) {
        super(materialIn);
        this.setBeaconBlock();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.DUST)));
        this.func_149711_c(10.0f);
        this.func_149752_b(20.0f);
        this.setStepSound(SoundType.field_185852_e);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata() == 1 ? Item.func_150898_a((Block)this) : NetherItems.WITHER_DUST;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        if (((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata() == 1) {
            return 1;
        }
        return 9;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata() == 1 ? 1 : 0;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        NetherMob nethermob;
        boolean flag = entity instanceof EntityLivingBase;
        if (entity instanceof NetherMob && (nethermob = (NetherMob)entity).isWitherResistant()) {
            flag = false;
        }
        if (flag) {
            int i = ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 120, i));
            entity.func_70097_a(DamageSource.field_82727_n, (float)(2 + i));
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return WITHER_BLOCK_AABB;
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151670_w;
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (EnumType BlockWitherBlock$enumtype : EnumType.values()) {
            list.add(new ItemStack(itemIn, 1, BlockWitherBlock$enumtype.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public static enum EnumType implements IStringSerializable
    {
        DUST(0, "dust"),
        GEM(1, "gem");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int metaIn, String nameIn) {
            this.meta = metaIn;
            this.name = nameIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType BlockWitherBlock$enumtype;
                EnumType.META_LOOKUP[BlockWitherBlock$enumtype.getMetadata()] = BlockWitherBlock$enumtype = enumTypeArray[i];
            }
        }
    }
}

