/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.blocks;

import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class BlockNetherSpawn
extends Block {
    public BlockNetherSpawn() {
        super(Material.field_151576_e, MapColor.field_151656_f);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (worldIn.field_73011_w.getDimension() == -1) {
            playerIn.func_180473_a(null, false);
            BlockNetherSpawn.setNetherSpawn(playerIn, pos, !BlockNetherSpawn.hasNetherSpawn(playerIn));
            if (BlockNetherSpawn.hasNetherSpawn(playerIn)) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString("Spawn Point Set"));
            } else {
                playerIn.func_146105_b((ITextComponent)new TextComponentString("Spawn Point Removed"));
            }
            return true;
        }
        playerIn.func_146105_b((ITextComponent)new TextComponentString("You must be in the Nether to set your Spawn."));
        return false;
    }

    public static void setNetherSpawn(EntityPlayer playerIn, BlockPos pos, boolean apply) {
        if (apply) {
            playerIn.func_184211_a("NetherSpawn=X" + pos.func_177958_n() + "Y" + pos.func_177956_o() + "Z" + pos.func_177952_p());
        } else {
            playerIn.func_184216_O().removeIf(new Predicate<String>(){

                @Override
                public boolean test(String t) {
                    return !t.isEmpty() && t.contains("NetherSpawn=");
                }
            });
        }
    }

    public static boolean hasNetherSpawn(EntityPlayer playerIn) {
        Set tags = playerIn.func_184216_O();
        if (tags.isEmpty()) {
            return false;
        }
        for (String s : tags) {
            if (s.isEmpty() || !s.contains("NetherSpawn=")) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getNetherSpawn(EntityPlayer playerIn) {
        Set tags = playerIn.func_184216_O();
        if (tags.isEmpty()) {
            return null;
        }
        for (String s : tags) {
            if (s.isEmpty() || !s.contains("NetherSpawn=")) continue;
            try {
                return BlockNetherSpawn.parseBlockPos(s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static BlockPos parseBlockPos(String args) throws Exception {
        String input = args.substring(12).toLowerCase();
        String x = input.substring(1, input.indexOf("y"));
        String y = input.substring(input.indexOf("y") + 1, input.indexOf("z"));
        String z = input.substring(input.indexOf("z") + 1);
        return new BlockPos(BlockNetherSpawn.parseDouble(x, -30000000, 30000000), BlockNetherSpawn.parseDouble(y, 0, 256), BlockNetherSpawn.parseDouble(z, -30000000, 30000000));
    }

    public static double parseDouble(String input, int min, int max) throws Exception {
        double d0 = Double.parseDouble(input);
        if (min != 0 || max != 0) {
            if (d0 < (double)min) {
                throw new Exception();
            }
            if (d0 > (double)max) {
                throw new Exception();
            }
        }
        return d0;
    }
}

